# coding=utf-8
# DO NOT EDIT! This code is generated by truckxi-api.

import httpx
import json

from .proto import *

class scm_purchase(object):

    def __init__(self, appname: str, addr: str, timeout: float = 0.5, token: str = ''):
        """
        :param appname: 发起请求方的微服务的名称, 将被写入到Header中发送给被请求的服务方
        :param addr: 被请求的服务地址, 格式为 "http://{ip}:{port}", 也可以是服务域名
        :param timeout: 超时时间, float型, 单位为秒
        :param token: 认证token
        """
        self.timeout = timeout
        self.appname = appname
        self.addr = addr
        self.token = token
        self.headers = {"X-SRC-APP": appname}
        
        limits = httpx.Limits(max_keepalive_connections=20, max_connections=100, keepalive_expiry=5)  # 一些附加限制
        self.client = httpx.AsyncClient(limits=limits, base_url=addr, timeout=timeout)  # 内网服务, 超时时间为0.1秒

    async def _check_alive(self):
        """
        通过API来检测服务可用性
        
        :param client: httpx.AsyncClient实例
        :return: 服务是否可用
        """
        api = '/api/server/api_keepalive'
        resp = await self.client.get(api)
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return True
            else:
                return False
        return False

    async def purchase_order_list(self, req: PurchaseOrderListReq, headerOpts: dict = {}) -> PurchaseOrderListResp:
        """
         Purchase Orders
        """
        api = "/api/purchase/order/list"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def create_purchase_order(self, req: CreatePurchaseOrderReq, headerOpts: dict = {}) -> CreatePurchaseOrderResp:
        """
         Create Purchase Order
        """
        api = "/api/purchase/order/create"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def update_purchase_order(self, req: UpdatePurchaseOrderReq, headerOpts: dict = {}) -> UpdatePurchaseOrderResp:
        """
         Update Purchase Order
        """
        api = "/api/purchase/order/update"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def syn_purchase_order(self, req: SynPurchaseOrderReq, headerOpts: dict = {}) -> UpdatePurchaseOrderResp:
        """
         Syn Purchase Order
        """
        api = "/api/purchase/order/syn"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def void_purchase_order(self, req: VoidPurchaseOrderReq, headerOpts: dict = {}) -> VoidPurchaseOrderResp:
        """
         Void Purchase Order
        """
        api = "/api/purchase/order/void"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.delete(api, content=json.dumps(req.dump_()), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def get_purchase_order_by_id(self, req: GetPurchaseOrderByIdReq, headerOpts: dict = {}) -> GetPurchaseOrderByIdResp:
        """
         Get Purchase Order By Id
        """
        api = "/api/purchase/order/by_id"
        headers = self.headers.copy()
        try:
            resp = await self.client.get(api, params=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def get_purchase_order_by_order_num(self, req: GetPurchaseOrderByOrderNumReq, headerOpts: dict = {}) -> GetPurchaseOrderByIdResp:
        """
         Get Purchase Order By Num
        """
        api = "/api/purchase/order/by_order_num"
        headers = self.headers.copy()
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.get(api, params=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def get_purchased_for_inventory(self, req: GetPurchasedForInventoryReq, headerOpts: dict = {}) -> GetPurchasedForInventoryResp:
        """
         Get Purchased For Inventory
        """
        api = "/api/purchase/order/get_purchased_for_inventory"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def binding_batch_id(self, req: BindingBatchIdReq, headerOpts: dict = {}) -> BindingBatchIdResp:
        """
         Binding Batch Id
        """
        api = "/api/purchase/order/binding_batch_id"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def new_purchase_return_from_vendor(self, req: NewPurchaseReturnFromVendorReq, headerOpts: dict = {}) -> NewPurchaseReturnFromVendorResp:
        """
         New Purchase Return From Vendor
        """
        api = "/api/purchase/return/new_from_vendor"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def new_purchase_return_from_po(self, req: NewPurchaseReturnFromPOReq, headerOpts: dict = {}) -> NewPurchaseReturnFromPOResp:
        """
         New Purchase Return From PO
        """
        api = "/api/purchase/return/new_from_po"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def purchase_return_list(self, req: PurchaseReturnListReq, headerOpts: dict = {}) -> PurchaseReturnListResp:
        """
         Purchase Return List
        """
        api = "/api/purchase/return/purchase_return_list"
        headers = self.headers.copy()
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.get(api, params=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def update_purchase_return(self, req: UpdatePurchaseReturnReq, headerOpts: dict = {}) -> UpdatePurchaseReturnResp:
        """
         Update Purchase Return
        """
        api = "/api/purchase/return/update"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.put(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def purchase_return_by_id(self, req: PurchaseReturnByIdReq, headerOpts: dict = {}) -> PurchaseReturnByIdResp:
        """
         Purchase Return By Id
        """
        api = "/api/purchase/return/by_id"
        headers = self.headers.copy()
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.get(api, params=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def void_purchase_return(self, req: VoidPurchaseReturnReq, headerOpts: dict = {}) -> VoidPurchaseReturnResp:
        """
         Void Purchase Return
        """
        api = "/api/purchase/return/void"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.delete(api, content=json.dumps(req.dump_()), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def new_receving(self, req: NewRecevingReq, headerOpts: dict = {}) -> NewRecevingResp:
        """
         New Receving
        """
        api = "/api/purchase/receving/new"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def update_receving(self, req: UpdateRecevingReq, headerOpts: dict = {}) -> UpdateRecevingResp:
        """
         Update Receving
        """
        api = "/api/purchase/receving/update"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.put(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def void_receving(self, req: VoidRecevingReq, headerOpts: dict = {}) -> VoidRecevingResp:
        """
         Void Receving
        """
        api = "/api/purchase/receving/void"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.delete(api, content=json.dumps(req.dump_()), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def finalize_receving(self, req: FinalizeRecevingReq, headerOpts: dict = {}) -> FinalizeRecevingResp:
        """
         Finalize Receving
        """
        api = "/api/purchase/receving/finalize"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def receive_list(self, req: ReceiveListReq, headerOpts: dict = {}) -> ReceiveListResp:
        """
         Receveing List
        """
        api = "/api/purchase/receving/list"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def get_purchase_receveing(self, req: GetRecevingByIdOrNumReq, headerOpts: dict = {}) -> GetRecevingByIdOrNumResp:
        """
         Get Receveing By Id
        """
        api = "/api/purchase/receving/by_id_or_num"
        headers = self.headers.copy()
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.get(api, params=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def vendor_list(self, req: VendorListReq, headerOpts: dict = {}) -> VendorListResp:
        """
         Vendor List
        """
        api = "/api/vendor/list"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def create_vendor(self, req: CreateVendorReq, headerOpts: dict = {}) -> CreateVendorResp:
        """
         Create Vendor
        """
        api = "/api/vendor/create"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/x-www-form-urlencoded'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, data=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def app_create_vendor(self, req: AppCreateVendorReq, headerOpts: dict = {}) -> CreateVendorResp:
        """
         APP Create Vendor
        """
        api = "/api/vendor/app_create_vendor"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def update_vendor(self, req: UpdateVendorReq, headerOpts: dict = {}) -> UpdateVendorResp:
        """
         Update Vendor
        """
        api = "/api/vendor/update"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.put(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def delete_vendor(self, req: DeleteVendorReq, headerOpts: dict = {}) -> DeleteVendorResp:
        """
         Delete Vendor
        """
        api = "/api/vendor/delete"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.delete(api, content=json.dumps(req.dump_()), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def deactive_vendor(self, req: DeleteVendorReq, headerOpts: dict = {}) -> DeleteVendorResp:
        """
         DeActive Vendor
        """
        api = "/api/vendor/deactive"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.put(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def get_vendor_by_id(self, req: GetVendorByIdReq, headerOpts: dict = {}) -> GetVendorByIdResp:
        """
         Get Vendor By ID
        """
        api = "/api/vendor/get_by_id"
        headers = self.headers.copy()
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.get(api, params=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def get_vendor_by_company_id(self, req: GetVendorByCompanyIdReq, headerOpts: dict = {}) -> GetVendorByCompanyIdResp:
        """
         Get Vendor By AppCompanyId and CenterCompanyId
        """
        api = "/api/vendor/get_vendor_by_company_id"
        headers = self.headers.copy()
        try:
            resp = await self.client.get(api, params=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def get_center_products(self, req: GetProductsByVendorReq, headerOpts: dict = {}) -> GetProductsByVendorResp:
        """
         From Vendor Get Center Products
        """
        api = "/api/vendor/get_center_products"
        headers = self.headers.copy()
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.get(api, params=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def get_center_groups(self, req: GetGroupsAndCategoriesByVendorReq, headerOpts: dict = {}) -> GetGroupsAndCategoriesByVendorResp:
        """
         From Vendor Get Center Gorups
        """
        api = "/api/vendor/get_center_groups"
        headers = self.headers.copy()
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.get(api, params=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def get_vendors_by_ids(self, req: GetVendorsByIdsReq, headerOpts: dict = {}) -> GetVendorsByIdsResp:
        """
         get Vendors By Vendor Ids
        """
        api = "/api/vendor/get_vendors_by_ids"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def get_products_by_center_products(self, req: GetProductsByCenterReq, headerOpts: dict = {}) -> GetProductsByCenterResp:
        """
         From Center Product Map APP Product (跳过此跳板直接去调用inventory服务)
        """
        api = "/api/vendor/get_products_by_center_products"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def balance_forward(self, req: BalanceForwardReq, headerOpts: dict = {}) -> BalanceForwardResp:
        """
         Balance Forward
        """
        api = "/api/vendor/balance_forward"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def total_invoice(self, req: TotalInvoiceReq, headerOpts: dict = {}) -> TotalInvoiceResp:
        """
         Total Invoice
        """
        api = "/api/vendor/total_invoice"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def total_payment(self, req: TotalPaymentReq, headerOpts: dict = {}) -> TotalPaymentResp:
        """
         Total Payment
        """
        api = "/api/vendor/total_payment"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def outstanding_balance(self, req: OutstandingBalanceReq, headerOpts: dict = {}) -> OutstandingBalanceResp:
        """
         Outstanding Balance
        """
        api = "/api/vendor/outstanding_balance"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def remaining_balance(self, req: RemainingBalanceReq, headerOpts: dict = {}) -> RemainingBalanceResp:
        """
         Remaining Balance
        """
        api = "/api/vendor/remaining_balance"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def vendor_aged_report(self, req: VendorAgedReportReq, headerOpts: dict = {}) -> VendorAgedReportResp:
        """
         Vendor Aged Report
        """
        api = "/api/vendor/vendor_aged_report"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def vendor_aged_report_with_date_range(self, req: VendorAgedReportWithDateRangeReq, headerOpts: dict = {}) -> VendorAgedReportWithDateRangeResp:
        """
         Vendor Aged Report With Date Range
        """
        api = "/api/vendor/vendor_aged_report_with_date_range"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def create_vendor_address(self, req: CreateVendorAddressReq, headerOpts: dict = {}) -> CreateVendorAddressResp:
        """
         Create Vendor Address
        """
        api = "/api/vendor/address/create"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def vendor_address_list(self, req: GetVendorAddressListReq, headerOpts: dict = {}) -> GetVendorAddressListResp:
        """
         Vendor Address List
        """
        api = "/api/vendor/address/list"
        headers = self.headers.copy()
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.get(api, params=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def update_vendor_address(self, req: UpdateVendorAddressReq, headerOpts: dict = {}) -> UpdateVendorAddressResp:
        """
         Update Vendor Address
        """
        api = "/api/vendor/address/update"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.put(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def delete_vendor_address(self, req: DeleteVendorAddressReq, headerOpts: dict = {}) -> DeleteVendorAddressResp:
        """
         Delete Vendor Address
        """
        api = "/api/vendor/address/delete"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.delete(api, content=json.dumps(req.dump_()), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def get_vendor_address_by_id(self, req: GetVendorAddressByIdReq, headerOpts: dict = {}) -> GetVendorAddressByIdResp:
        """
         Get Vendor Address By ID
        """
        api = "/api/vendor/address/by_id"
        headers = self.headers.copy()
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.get(api, params=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def vendor_credit_balance(self, req: VendorCreditBalanceReq, headerOpts: dict = {}) -> VendorCreditBalanceResp:
        """
         Credit Balance
        """
        api = "/api/vendor/credit_balance"
        headers = self.headers.copy()
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.get(api, params=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def set_vendor_credit_balance(self, req: SetVendorCreditBalanceReq, headerOpts: dict = {}) -> SetVendorCreditBalanceResp:
        """
         Set Credit Balance
        """
        api = "/api/vendor/set_vendor_credit_balance"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def from_vendor_get_unpaid_order(self, req: UnpaidPurchaseOrderReq, headerOpts: dict = {}) -> UnpaidPurchaseOrderResp:
        """
         From Vendor Get Unpaid order
        """
        api = "/api/purchase/ap/from_vendor_get_unpaid_order"
        headers = self.headers.copy()
        try:
            resp = await self.client.get(api, params=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def from_po_get_pi(self, req: UnpaidPoIdReq, headerOpts: dict = {}) -> UnpaidPiListResp:
        """
         From Po get Pi
        """
        api = "/api/purchase/ap/from_po_get_pi"
        headers = self.headers.copy()
        try:
            resp = await self.client.get(api, params=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def new_ap_from_vendor(self, req: NewAPFromVendorReq, headerOpts: dict = {}) -> NewAPFromVendorResp:
        """
         Create AP From Vendor
        """
        api = "/api/purchase/ap/new-ap-from-vendor"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def new_ap_from_po(self, req: NewAPFromPOReq, headerOpts: dict = {}) -> NewAPFromPOResp:
        """
         Create AP From PO
        """
        api = "/api/purchase/ap/new-ap-from-po"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def ap_list(self, req: APListReq, headerOpts: dict = {}) -> APListResp:
        """
         AP List
        """
        api = "/api/purchase/ap/list"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def ap_aged_report(self, req: APAgedReportReq, headerOpts: dict = {}) -> APAgedReportResp:
        """
         AP Aged Report
        """
        api = "/api/purchase/ap/aged-report"
        headers = self.headers.copy()
        try:
            resp = await self.client.get(api, params=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def create_credit_memo(self, req: CreateCreditMemoReq, headerOpts: dict = {}) -> CreateCreditMemoResp:
        """
         Create a credit memo
        """
        api = "/api/purchase/credit_memo/create"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def update_credit_memo(self, req: UpdateCreditMemoReq, headerOpts: dict = {}) -> UpdateCreditMemoResp:
        """
         Update a credit memo
        """
        api = "/api/purchase/credit_memo/update"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        try:
            resp = await self.client.put(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def get_credit_memo_by_id(self, req: GetCreditMemoByIdReq, headerOpts: dict = {}) -> GetCreditMemoByIdResp:
        """
         Get a credit memo
        """
        api = "/api/purchase/credit_memo/get_by_id"
        headers = self.headers.copy()
        try:
            resp = await self.client.get(api, params=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def list_credit_memos(self, req: ListCreditMemosReq, headerOpts: dict = {}) -> ListCreditMemosResp:
        """
         List credit memos
        """
        api = "/api/purchase/credit_memo/list"
        headers = self.headers.copy()
        try:
            resp = await self.client.get(api, params=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def delete_credit_memo(self, req: DeleteCreditMemoReq, headerOpts: dict = {}) -> DeleteCreditMemoResp:
        """
         Delete a credit memo
        """
        api = "/api/purchase/credit_memo/delete"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        try:
            resp = await self.client.delete(api, content=json.dumps(req.dump_()), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}
