from __future__ import annotations
# DO NOT EDIT! This code is generated by truckxi-api.

from dataclasses import dataclass
from .verify import verify
from datetime import datetime

def _dump_value(v):
    if isinstance(v, (list, tuple)):
        return list(map(_dump_value, v))
    if isinstance(v, dict):
        return {k:_dump_value(v) for k, v in v.items()}
    if isinstance(v, Enum):
        return v.value
    if hasattr(v, 'dump_'):
        return v.dump_()
    if isinstance(v, datetime):
        return v.isoformat()
    return v

class Enum:
    def __init__(self, value):
        self.value = value
    def __str__(self):
        return str(self.value)
    def __repr__(self):
        return str(self.value)


class PurchaseStatus(Enum):
    '''
    Purchase Status
    '''
    # Test
    Test = "Test"
    # Pending
    Pending = "Pending"
    # Open
    Open = "Open"
    # Partial
    Partial = "Partially Invoiced"
    # Invoiced
    Invoiced = "Invoiced"
    # Void
    Void = "Void"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "Test": True,
            "Pending": True,
            "Open": True,
            "Partially Invoiced": True,
            "Invoiced": True,
            "Void": True,
            
        }
        if d.get(self.value) is None:
            self.value = PurchaseStatus.Test
        return None

class PurchaseOrderListGroupBy(Enum):
    '''
    Purchase Order List Group By
    '''
    # Test
    Test = "Test"
    # Vendor
    VendorName = "VendorName"
    # Creator
    CreateUserName = "createUserName"
    # Purchaser
    PurchaserName = "purchaserName"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "Test": True,
            "VendorName": True,
            "createUserName": True,
            "purchaserName": True,
            
        }
        if d.get(self.value) is None:
            self.value = PurchaseOrderListGroupBy.Test
        return None

class PurchaseOrderListSortBy(Enum):
    '''
    Purchase Order List Sort By
    '''
    # Id
    IdDESC = "-id"
    # PO No. ASC
    OrderNumASC = "orderNum"
    # PO No. DESC
    OrderNumDESC = "-orderNum"
    # Vendor ASC
    VendorNumASC = "vendorNum"
    # Vendor DESC
    VendorNumDESC = "-vendorNum"
    # Created ASC
    PostDatetimeASC = "postDatetime"
    # Created DESC
    PostDatetimeDESC = "-postDatetime"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "-id": True,
            "orderNum": True,
            "-orderNum": True,
            "vendorNum": True,
            "-vendorNum": True,
            "postDatetime": True,
            "-postDatetime": True,
            
        }
        if d.get(self.value) is None:
            self.value = PurchaseOrderListSortBy.IdDESC
        return None

class ShippingMethod(Enum):
    '''
    Shipping Method
    '''
    # Test
    Test = "Test"
    # Delivery
    Delivery = "Delivery"
    # Pickup
    Pickup = "Pickup"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "Test": True,
            "Delivery": True,
            "Pickup": True,
            
        }
        if d.get(self.value) is None:
            self.value = ShippingMethod.Test
        return None

class ReturnType(Enum):
    '''
    Return Type
    '''
    # Test
    Test = "Test"
    # Redelivery
    Redelivery = "Redelivery"
    # Receive Credit
    ReceiveCredit = "ReceiveCredit"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "Test": True,
            "Redelivery": True,
            "ReceiveCredit": True,
            
        }
        if d.get(self.value) is None:
            self.value = ReturnType.Test
        return None

class ReturnReason(Enum):
    '''
    Return Reason
    '''
    # Test
    Test = "Test"
    # Damaged
    Damaged = "Damaged"
    # Defective
    Defective = "Defective"
    # No Need
    NoNeed = "NoNeed"
    # Repair
    Repair = "Repair"
    # Wrong Item
    WrongItem = "WrongItem"
    # Missing
    Missing = "Missing"
    # Other
    Other = "Other"
    # Out
    Out = "Out"
    # Short
    Short = "Short"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "Test": True,
            "Damaged": True,
            "Defective": True,
            "NoNeed": True,
            "Repair": True,
            "WrongItem": True,
            "Missing": True,
            "Other": True,
            "Out": True,
            "Short": True,
            
        }
        if d.get(self.value) is None:
            self.value = ReturnReason.Test
        return None

class CarryType(Enum):
    '''
    Carry Type
    '''
    # Dry
    Dry = "Dry"
    # Refrigerated
    Refrigerated = "Refrigerated"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "Dry": True,
            "Refrigerated": True,
            
        }
        if d.get(self.value) is None:
            return ValueError('Invalid value for CarryType: %s' % self.value)
        return None

class PurchaseReturnStatus(Enum):
    '''
    Purchase Return Status
    '''
    # Test
    Test = "Test"
    # Quote
    Quote = "Quote"
    # Open
    Open = "Open"
    # Void
    Void = "Void"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "Test": True,
            "Quote": True,
            "Open": True,
            "Void": True,
            
        }
        if d.get(self.value) is None:
            self.value = PurchaseReturnStatus.Test
        return None

class PurchaseReturnGroupBy(Enum):
    '''
    Purchase Return Group By
    '''
    # Test
    Test = "Test"
    # ReturnStatus
    ReturnStatus = "returnStatus"
    # VendorNum
    VendorNum = "vendorNum"
    # OrderDate
    OrderDate = "orderDate"
    # Shipping Method
    ShippingMethod = "shippingMethod"
    # Return Type
    ReturnType = "returnType"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "Test": True,
            "returnStatus": True,
            "vendorNum": True,
            "orderDate": True,
            "shippingMethod": True,
            "returnType": True,
            
        }
        if d.get(self.value) is None:
            self.value = PurchaseReturnGroupBy.Test
        return None

class PurchaseReturnSortBy(Enum):
    '''
    Purchase Return Sort By
    '''
    # Test
    Test = "Test"
    # Return No. ASC
    ReturnNoAsc = "ReturnNo"
    # Return No. DESC
    ReturnNoDesc = "-ReturnNo"
    # PO No. ASC
    PoNoAsc = "PoNo"
    # PO No. DESC
    PoNoDesc = "-PoNo"
    # Products ASC
    ProductsAsc = "Products"
    # Products DESC
    ProductsDesc = "-Products"
    # Vendor ASC
    VendorAsc = "Vendor"
    # Vendor DESC
    VendorDesc = "-Vendor"
    # Vendor No. ASC
    VendorNo = "VendorNo"
    # Vendor No. DESC
    VendorNoDesc = "-VendorNo"
    # Return ASC
    ReturnAsc = "Return"
    # Return DESC
    ReturnDesc = "-Return"
    # Return Type ASC
    ReturnTypeAsc = "ReturnType"
    # Return Type DESC
    ReturnTypeDesc = "-ReturnType"
    # Service $ ASC
    ServiceAsc = "Service"
    # Service $ DESC
    ServiceDesc = "-Service"
    # Return Date ASC
    ReturnDateAsc = "ReturnDate"
    # Return Date DESC
    ReturnDateDesc = "-ReturnDate"
    # Operator ASC
    OperatorAsc = "Operator"
    # Operator DESC
    OperatorDesc = "-Operator"
    # Created ASC
    CreatedAsc = "Created"
    # Created DESC
    CreatedDesc = "-Created"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "Test": True,
            "ReturnNo": True,
            "-ReturnNo": True,
            "PoNo": True,
            "-PoNo": True,
            "Products": True,
            "-Products": True,
            "Vendor": True,
            "-Vendor": True,
            "VendorNo": True,
            "-VendorNo": True,
            "Return": True,
            "-Return": True,
            "ReturnType": True,
            "-ReturnType": True,
            "Service": True,
            "-Service": True,
            "ReturnDate": True,
            "-ReturnDate": True,
            "Operator": True,
            "-Operator": True,
            "Created": True,
            "-Created": True,
            
        }
        if d.get(self.value) is None:
            self.value = PurchaseReturnSortBy.Test
        return None

class CostSharingFormula(Enum):
    '''
    Cost Sharing Formula
    '''
    # Percentage
    Percentage = "Percentage"
    # Average By Unit
    AverageByUnit = "AverageByUnit"
    # Average By Weight
    AverageByWeight = "AverageByWeight"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "Percentage": True,
            "AverageByUnit": True,
            "AverageByWeight": True,
            
        }
        if d.get(self.value) is None:
            return ValueError('Invalid value for CostSharingFormula: %s' % self.value)
        return None

class ReceiveStatus(Enum):
    '''
    Receive Status
    '''
    # ALL
    Test = "Test"
    # Open
    Open = "Open"
    # Finalized
    Finalized = "Finalized"
    # Void
    Void = "Void"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "Test": True,
            "Open": True,
            "Finalized": True,
            "Void": True,
            
        }
        if d.get(self.value) is None:
            self.value = ReceiveStatus.Test
        return None

class ReceiveListSort(Enum):
    '''
    ReceiveListSort
    '''
    # Test
    Test = "Test"
    # RCV No. ASC
    ReceiveNoAsc = "ReceiveNo"
    # RCV No. DESC
    ReceiveNoDesc = "-ReceiveNo"
    # From ASC
    FromAsc = "From"
    # From DESC
    FromDesc = "-From"
    # Total $ ASC
    TotalAsc = "Total"
    # Total $ DESC
    TotalDesc = "-Total"
    # Service $ ASC
    ServiceAsc = "Service"
    # Service $ DESC
    ServiceDesc = "-Service"
    # Vendor Invoice ASC
    VendorInvoiceAsc = "VendorInvoice"
    # Vendor Invoice DESC
    VendorInvoiceDesc = "-VendorInvoice"
    # Warehouse ASC
    WarehouseAsc = "Warehouse"
    # Warehouse DESC
    WarehouseDesc = "-Warehouse"
    # Receive Date ASC
    ReceiveDateAsc = "ReceiveDate"
    # Receive Date DESC
    ReceiveDateDesc = "-ReceiveDate"
    # Operator ASC
    OperatorAsc = "Operator"
    # Operator DESC
    OperatorDesc = "-Operator"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "Test": True,
            "ReceiveNo": True,
            "-ReceiveNo": True,
            "From": True,
            "-From": True,
            "Total": True,
            "-Total": True,
            "Service": True,
            "-Service": True,
            "VendorInvoice": True,
            "-VendorInvoice": True,
            "Warehouse": True,
            "-Warehouse": True,
            "ReceiveDate": True,
            "-ReceiveDate": True,
            "Operator": True,
            "-Operator": True,
            
        }
        if d.get(self.value) is None:
            self.value = ReceiveListSort.Test
        return None

class VendorStatus(Enum):
    '''
    Vendor Status
    '''
    # Test
    Test = "Test"
    # Active
    Active = "Active"
    # InActive
    InActive = "InActive"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "Test": True,
            "Active": True,
            "InActive": True,
            
        }
        if d.get(self.value) is None:
            self.value = VendorStatus.Test
        return None

class Business(Enum):
    '''
    Business
    '''
    # Test
    Test = "Test"
    # Retail
    Retail = "Retail"
    # WholeSale
    WholeSale = "WholeSale"
    # ECOM
    ECOM = "ECOM"
    # Restaurant
    Restaurant = "Restaurant"
    # Supermarket
    Supermarket = "Supermarket"
    # Other
    Other = "Other"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "Test": True,
            "Retail": True,
            "WholeSale": True,
            "ECOM": True,
            "Restaurant": True,
            "Supermarket": True,
            "Other": True,
            
        }
        if d.get(self.value) is None:
            self.value = Business.Test
        return None

class PaymentTerm(Enum):
    '''
    Payment Term
    '''
    # Test
    Test = "Test"
    # COD
    COD = "COD"
    # Net 30
    Net30 = "Net30"
    # Net 45
    Net45 = "Net45"
    # Net 60
    Net60 = "Net60"
    # Net 90
    Net90 = "Net90"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "Test": True,
            "COD": True,
            "Net30": True,
            "Net45": True,
            "Net60": True,
            "Net90": True,
            
        }
        if d.get(self.value) is None:
            self.value = PaymentTerm.Test
        return None

class VendorSortBy(Enum):
    '''
    Vendor Sort
    '''
    # Test
    Test = "Test"
    # Name
    Name = "name"
    # Vendor No.
    VendorNo = "vendorNum"
    # Business
    Business = "businessType"
    # Payment Terms
    PaymentTerms = "paymentTerms"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "Test": True,
            "name": True,
            "vendorNum": True,
            "businessType": True,
            "paymentTerms": True,
            
        }
        if d.get(self.value) is None:
            self.value = VendorSortBy.Test
        return None

class Order(Enum):
    '''
    Order
    '''
    # Test
    Test = "Test"
    # Asc
    Asc = "asc"
    # Desc
    Desc = "desc"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "Test": True,
            "asc": True,
            "desc": True,
            
        }
        if d.get(self.value) is None:
            self.value = Order.Test
        return None

class AddressType(Enum):
    '''
    AddressType
    '''
    # Shipping
    Shipping = "Shipping"
    # Billing
    Billing = "Billing"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "Shipping": True,
            "Billing": True,
            
        }
        if d.get(self.value) is None:
            self.value = AddressType.Shipping
        return None

class BalanceForwardBy(Enum):
    '''
    Balance Forward By
    '''
    # Created Date
    CreatedDate = 1
    # Payment Date
    PaymentDate = 2
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            1: True,
            2: True,
            
        }
        if d.get(self.value) is None:
            return ValueError('Invalid value for BalanceForwardBy: %s' % self.value)
        return None

class TransNoStatus(Enum):
    '''
    Trans No. Status
    '''
    # Non
    Non = 1
    # Partial
    Partial = 2
    # Complete
    Complete = 3
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            1: True,
            2: True,
            3: True,
            
        }
        if d.get(self.value) is None:
            return ValueError('Invalid value for TransNoStatus: %s' % self.value)
        return None

class PaymentMethod(Enum):
    '''
    Payment Method
    '''
    # Test
    Test = "Test"
    # Cash
    Cash = "Cash"
    # Credit Card
    CreditCard = "CreditCard"
    # Apple Pay
    ApplePay = "ApplePay"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "Test": True,
            "Cash": True,
            "CreditCard": True,
            "ApplePay": True,
            
        }
        if d.get(self.value) is None:
            self.value = PaymentMethod.Test
        return None

class PaymentAccount(Enum):
    '''
    Payment Account
    '''
    # Test
    Test = "Test"
    # COD
    COD = "COD"
    # BOA
    BOA = "BOA"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "Test": True,
            "COD": True,
            "BOA": True,
            
        }
        if d.get(self.value) is None:
            self.value = PaymentAccount.Test
        return None

class APStatus(Enum):
    '''
    AP Status
    '''
    # Test
    Test = "Test"
    # Open
    Open = "Open"
    # Complete
    Complete = "Complete"
    # Void
    Void = "Void"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "Test": True,
            "Open": True,
            "Complete": True,
            "Void": True,
            
        }
        if d.get(self.value) is None:
            self.value = APStatus.Test
        return None

class APListGroupBy(Enum):
    '''
    AP List Group By
    '''
    # Test
    Test = "Test"
    # Status
    Status = "Status"
    # Vendor
    Vendor = "Vendor"
    # Payment Date
    PaymentDate = "PaymentDate"
    # Method
    Method = "Method"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "Test": True,
            "Status": True,
            "Vendor": True,
            "PaymentDate": True,
            "Method": True,
            
        }
        if d.get(self.value) is None:
            self.value = APListGroupBy.Test
        return None

class APAgedReportStatus(Enum):
    '''
    Vendor
    '''
    # Test
    Test = "Test"
    # Active
    Active = "Active"
    # Inactive
    Inactive = "Inactive"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "Test": True,
            "Active": True,
            "Inactive": True,
            
        }
        if d.get(self.value) is None:
            self.value = APAgedReportStatus.Test
        return None

class CreditMemoStatus(Enum):
    '''
    Credit Memo Status
    '''
    # Test
    Test = "Test"
    # Credit
    Credit = "Credit"
    # Partially Used
    PartiallyUsed = "Partially Used "
    # Used
    Used = "Used"
    # Void
    Void = "Void"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "Test": True,
            "Credit": True,
            "Partially Used ": True,
            "Used": True,
            "Void": True,
            
        }
        if d.get(self.value) is None:
            self.value = CreditMemoStatus.Test
        return None

class ListCreditMemoSort(Enum):
    '''
    List Credit Memo Sort
    '''
    # Test
    Test = "Test"
    # Credit Memo No. ASC
    CdNumAsc = "cdNum"
    # Credit Memo No. DESC
    CdNumDesc = "-cdNum"
    # Total Amount ASC
    FinalPriceAsc = "finalPrice"
    # Total Amount DESC
    FinalPriceDesc = "-finalPrice"
    # Vendor ASC
    VendorNumAsc = "vendorNum"
    # Vendor DESC
    VendorNumDesc = "-vendorNum"
    # Note ASC
    MiscNoteAsc = "miscNote"
    # Note DESC
    MiscNoteDesc = "-miscNote"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "Test": True,
            "cdNum": True,
            "-cdNum": True,
            "finalPrice": True,
            "-finalPrice": True,
            "vendorNum": True,
            "-vendorNum": True,
            "miscNote": True,
            "-miscNote": True,
            
        }
        if d.get(self.value) is None:
            self.value = ListCreditMemoSort.Test
        return None

@dataclass(slots=True)
class Ok:
    '''
    '''
    # success: true, fail: false
    ok: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ok')
            if value not in (None,'null', 'none','None'):
                self.ok = bool(value)
            else:
                self.ok = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ok': self.ok,
        }

@dataclass(slots=True)
class TimeRange:
    '''
    '''
    # start time
    startTime: str
    # end time
    endTime: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('startTime')
            if value not in (None,'null', 'none','None'):
                self.startTime = str(value)
            else:
                self.startTime = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('endTime')
            if value not in (None,'null', 'none','None'):
                self.endTime = str(value)
            else:
                self.endTime = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'startTime': self.startTime,
            'endTime': self.endTime,
        }

@dataclass(slots=True)
class SynProductLine:
    '''
    '''
    # Product ID
    productId: int
    # quantity
    quantity: int
    # weight
    weight: float
    # UnitPrice
    unitPrice: str
    # subtotal
    subtotal: str
    # notation
    notation: str
    # Name
    name: str
    # Description
    description: str
    # NetWeight
    netWeight: float
    # RefNum
    refNum: str
    # ProductNum
    productNum: str
    # ProductType
    productType: str
    # PackageSize
    packageSize: str
    # PackageType
    packageType: str
    # Thumbnail
    thumbnail: str
    # Specification
    specification: str
    # Dimension
    dimension: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('productId')
            if value not in (None,'null', 'none','None'):
                self.productId = int(value)
            else:
                self.productId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('quantity')
            if value not in (None,'null', 'none','None'):
                self.quantity = int(value)
            else:
                self.quantity = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('weight')
            if value not in (None,'null', 'none','None'):
                self.weight = float(value)
            else:
                self.weight = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('unitPrice')
            if value not in (None,'null', 'none','None'):
                self.unitPrice = str(value)
            else:
                self.unitPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('subtotal')
            if value not in (None,'null', 'none','None'):
                self.subtotal = str(value)
            else:
                self.subtotal = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('notation')
            if value not in (None,'null', 'none','None'):
                self.notation = str(value)
            else:
                self.notation = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('description')
            if value not in (None,'null', 'none','None'):
                self.description = str(value)
            else:
                self.description = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('netWeight')
            if value not in (None,'null', 'none','None'):
                self.netWeight = float(value)
            else:
                self.netWeight = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('refNum')
            if value not in (None,'null', 'none','None'):
                self.refNum = str(value)
            else:
                self.refNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productNum')
            if value not in (None,'null', 'none','None'):
                self.productNum = str(value)
            else:
                self.productNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productType')
            if value not in (None,'null', 'none','None'):
                self.productType = str(value)
            else:
                self.productType = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packageSize')
            if value not in (None,'null', 'none','None'):
                self.packageSize = str(value)
            else:
                self.packageSize = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packageType')
            if value not in (None,'null', 'none','None'):
                self.packageType = str(value)
            else:
                self.packageType = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('thumbnail')
            if value not in (None,'null', 'none','None'):
                self.thumbnail = str(value)
            else:
                self.thumbnail = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('specification')
            if value not in (None,'null', 'none','None'):
                self.specification = str(value)
            else:
                self.specification = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('dimension')
            if value not in (None,'null', 'none','None'):
                self.dimension = str(value)
            else:
                self.dimension = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.productId), [('gt', 0),])
        if err is not None:
            return err
        _, err = verify(int(self.quantity), [('gt', 0),])
        if err is not None:
            return err
        _, err = verify(float(self.weight), [('gt', 0),])
        if err is not None:
            return err
        _, err = verify(str(self.unitPrice), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.subtotal), [('required', True),])
        if err is not None:
            return err
        
        
        
        
        
        
        
        
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'productId': self.productId,
            'quantity': self.quantity,
            'weight': self.weight,
            'unitPrice': self.unitPrice,
            'subtotal': self.subtotal,
            'notation': self.notation,
            'name': self.name,
            'description': self.description,
            'netWeight': self.netWeight,
            'refNum': self.refNum,
            'productNum': self.productNum,
            'productType': self.productType,
            'packageSize': self.packageSize,
            'packageType': self.packageType,
            'thumbnail': self.thumbnail,
            'specification': self.specification,
            'dimension': self.dimension,
        }

@dataclass(slots=True)
class CreatePurchaseOrderProduct:
    '''
    '''
    # CenterProduct ID
    centerProductId: int
    # AppproductId
    productId: int
    # Name
    name: str
    # Description
    description: str
    # RefNum
    refNum: str
    # ProductNum
    productNum: str
    # NetWeight
    netWeight: float
    # Quantity
    quantity: int
    # Unit Price
    unitPrice: str
    # Weight
    weight: float
    # Note
    notation: str
    # Location
    location: int
    # expireDate
    expireDate: str
    # packDate
    packDate: str
    # ProductType
    productType: str
    # PackageSize 
    packageSize: str
    # PackageType
    packageType: str
    # Thumbnail
    thumbnail: list[str]
    # Specification
    specification: list[str]
    # Dimension
    dimension: list[str]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('centerProductId')
            if value not in (None,'null', 'none','None'):
                self.centerProductId = int(value)
            else:
                self.centerProductId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productId')
            if value not in (None,'null', 'none','None'):
                self.productId = int(value)
            else:
                self.productId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('description')
            if value not in (None,'null', 'none','None'):
                self.description = str(value)
            else:
                self.description = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('refNum')
            if value not in (None,'null', 'none','None'):
                self.refNum = str(value)
            else:
                self.refNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productNum')
            if value not in (None,'null', 'none','None'):
                self.productNum = str(value)
            else:
                self.productNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('netWeight')
            if value not in (None,'null', 'none','None'):
                self.netWeight = float(value)
            else:
                self.netWeight = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('quantity')
            if value not in (None,'null', 'none','None'):
                self.quantity = int(value)
            else:
                self.quantity = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('unitPrice')
            if value not in (None,'null', 'none','None'):
                self.unitPrice = str(value)
            else:
                self.unitPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('weight')
            if value not in (None,'null', 'none','None'):
                self.weight = float(value)
            else:
                self.weight = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('notation')
            if value not in (None,'null', 'none','None'):
                self.notation = str(value)
            else:
                self.notation = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('location')
            if value not in (None,'null', 'none','None'):
                self.location = int(value)
            else:
                self.location = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('expireDate')
            if value not in (None,'null', 'none','None'):
                self.expireDate = str(value)
            else:
                self.expireDate = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packDate')
            if value not in (None,'null', 'none','None'):
                self.packDate = str(value)
            else:
                self.packDate = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productType')
            if value not in (None,'null', 'none','None'):
                self.productType = str(value)
            else:
                self.productType = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packageSize')
            if value not in (None,'null', 'none','None'):
                self.packageSize = str(value)
            else:
                self.packageSize = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packageType')
            if value not in (None,'null', 'none','None'):
                self.packageType = str(value)
            else:
                self.packageType = None
        except Exception as e:
            raise e
        
        self.thumbnail = list(map(lambda x: str(x), data.get('thumbnail') if data.get('thumbnail') else []))
        self.specification = list(map(lambda x: str(x), data.get('specification') if data.get('specification') else []))
        self.dimension = list(map(lambda x: str(x), data.get('dimension') if data.get('dimension') else []))

    def valid(self):
        '''check object is valid'''
        
        
        _, err = verify(str(self.name), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.description), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.refNum), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.productNum), [('required', True),])
        if err is not None:
            return err
        _, err = verify(float(self.netWeight), [('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.quantity), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.unitPrice), [('required', True),])
        if err is not None:
            return err
        
        
        
        
        
        
        
        
        # TODO valid list
        # TODO valid list
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'centerProductId': self.centerProductId,
            'productId': self.productId,
            'name': self.name,
            'description': self.description,
            'refNum': self.refNum,
            'productNum': self.productNum,
            'netWeight': self.netWeight,
            'quantity': self.quantity,
            'unitPrice': self.unitPrice,
            'weight': self.weight,
            'notation': self.notation,
            'location': self.location,
            'expireDate': self.expireDate,
            'packDate': self.packDate,
            'productType': self.productType,
            'packageSize': self.packageSize,
            'packageType': self.packageType,
            'thumbnail': _dump_value(self.thumbnail),
            'specification': _dump_value(self.specification),
            'dimension': _dump_value(self.dimension),
        }

@dataclass(slots=True)
class Shipping:
    '''
    '''
    # Shipping
    shippingMethod: ShippingMethod
    # Shipping Address
    shippingAddress: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.shippingMethod = ShippingMethod(data.get('shippingMethod'))
        try:
            value = data.get('shippingAddress')
            if value not in (None,'null', 'none','None'):
                self.shippingAddress = str(value)
            else:
                self.shippingAddress = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        err = self.shippingMethod.valid()
        if err is not None:
            return err
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'shippingMethod': self.shippingMethod.value,
            'shippingAddress': self.shippingAddress,
        }

@dataclass(slots=True)
class ServiceFee:
    '''
    '''
    # Shipping $
    shippingPrice: str
    # Handling $
    handlingPrice: str
    # Misc $
    miscPrice: str
    # Adjustment $
    adjustmentPrice: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('shippingPrice')
            if value not in (None,'null', 'none','None'):
                self.shippingPrice = str(value)
            else:
                self.shippingPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('handlingPrice')
            if value not in (None,'null', 'none','None'):
                self.handlingPrice = str(value)
            else:
                self.handlingPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('miscPrice')
            if value not in (None,'null', 'none','None'):
                self.miscPrice = str(value)
            else:
                self.miscPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('adjustmentPrice')
            if value not in (None,'null', 'none','None'):
                self.adjustmentPrice = str(value)
            else:
                self.adjustmentPrice = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'shippingPrice': self.shippingPrice,
            'handlingPrice': self.handlingPrice,
            'miscPrice': self.miscPrice,
            'adjustmentPrice': self.adjustmentPrice,
        }

@dataclass(slots=True)
class CreatePurchaseOrderReq:
    '''
    '''
    # Company ID
    companyId: int
    # Warehouse ID
    warehouseId: int
    # Vendor ID
    vendorId: int
    # VendorNum
    vendorNum: str
    # VendorInvNo
    vendorInvNo: str
    # Purchaser
    purchaserId: int
    # PurchaserName
    purchaserName: str
    # ETA Date
    etaDatetime: str
    # POST Date
    postDatetime: str
    # Note
    note: str
    # Products
    products: list[CreatePurchaseOrderProduct]
    # Shipping
    shipping: Shipping
    # Service Fee
    serviceFee: ServiceFee
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('warehouseId')
            if value not in (None,'null', 'none','None'):
                self.warehouseId = int(value)
            else:
                self.warehouseId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorId')
            if value not in (None,'null', 'none','None'):
                self.vendorId = int(value)
            else:
                self.vendorId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorNum')
            if value not in (None,'null', 'none','None'):
                self.vendorNum = str(value)
            else:
                self.vendorNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorInvNo')
            if value not in (None,'null', 'none','None'):
                self.vendorInvNo = str(value)
            else:
                self.vendorInvNo = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('purchaserId')
            if value not in (None,'null', 'none','None'):
                self.purchaserId = int(value)
            else:
                self.purchaserId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('purchaserName')
            if value not in (None,'null', 'none','None'):
                self.purchaserName = str(value)
            else:
                self.purchaserName = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('etaDatetime')
            if value not in (None,'null', 'none','None'):
                self.etaDatetime = str(value)
            else:
                self.etaDatetime = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('postDatetime')
            if value not in (None,'null', 'none','None'):
                self.postDatetime = str(value)
            else:
                self.postDatetime = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('note')
            if value not in (None,'null', 'none','None'):
                self.note = str(value)
            else:
                self.note = None
        except Exception as e:
            raise e
        
        self.products = list(map(lambda x: CreatePurchaseOrderProduct(x), data.get('products') if data.get('products') else []))
        self.shipping = Shipping(data.get('shipping')) if data.get('shipping') else None
        self.serviceFee = ServiceFee(data.get('serviceFee')) if data.get('serviceFee') else None

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.companyId), [('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.warehouseId), [('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.vendorId), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.vendorNum), [('required', True),])
        if err is not None:
            return err
        
        _, err = verify(int(self.purchaserId), [('required', True),])
        if err is not None:
            return err
        
        
        
        
        # TODO valid list
        if False or self.shipping is not None:
            err = self.shipping.valid()
        else:
            err = None
        if err is not None:
            return err
        if False or self.serviceFee is not None:
            err = self.serviceFee.valid()
        else:
            err = None
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'companyId': self.companyId,
            'warehouseId': self.warehouseId,
            'vendorId': self.vendorId,
            'vendorNum': self.vendorNum,
            'vendorInvNo': self.vendorInvNo,
            'purchaserId': self.purchaserId,
            'purchaserName': self.purchaserName,
            'etaDatetime': self.etaDatetime,
            'postDatetime': self.postDatetime,
            'note': self.note,
            'products': _dump_value(self.products),
            'shipping': self.shipping.dump_(),
            'serviceFee': self.serviceFee.dump_(),
        }

@dataclass(slots=True)
class CreatePurchaseOrderResp:
    '''
    '''
    # Id
    id: int
    # OrderNum 
    orderNum: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('orderNum')
            if value not in (None,'null', 'none','None'):
                self.orderNum = str(value)
            else:
                self.orderNum = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'orderNum': self.orderNum,
        }

@dataclass(slots=True)
class UpdatePurchaseOrderReq:
    '''
    '''
    # Company ID
    companyId: int
    # Warehouse ID
    warehouseId: int
    # Vendor ID
    vendorId: int
    # VendorNum
    vendorNum: str
    # VendorInvNo
    vendorInvNo: str
    # Purchaser
    purchaserId: int
    # PurchaserName
    purchaserName: str
    # ETA Date
    etaDatetime: str
    # POST Date
    postDatetime: str
    # Note
    note: str
    # Products
    products: list[CreatePurchaseOrderProduct]
    # Shipping
    shipping: Shipping
    # Service Fee
    serviceFee: ServiceFee
    # PO ID
    id: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('warehouseId')
            if value not in (None,'null', 'none','None'):
                self.warehouseId = int(value)
            else:
                self.warehouseId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorId')
            if value not in (None,'null', 'none','None'):
                self.vendorId = int(value)
            else:
                self.vendorId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorNum')
            if value not in (None,'null', 'none','None'):
                self.vendorNum = str(value)
            else:
                self.vendorNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorInvNo')
            if value not in (None,'null', 'none','None'):
                self.vendorInvNo = str(value)
            else:
                self.vendorInvNo = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('purchaserId')
            if value not in (None,'null', 'none','None'):
                self.purchaserId = int(value)
            else:
                self.purchaserId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('purchaserName')
            if value not in (None,'null', 'none','None'):
                self.purchaserName = str(value)
            else:
                self.purchaserName = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('etaDatetime')
            if value not in (None,'null', 'none','None'):
                self.etaDatetime = str(value)
            else:
                self.etaDatetime = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('postDatetime')
            if value not in (None,'null', 'none','None'):
                self.postDatetime = str(value)
            else:
                self.postDatetime = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('note')
            if value not in (None,'null', 'none','None'):
                self.note = str(value)
            else:
                self.note = None
        except Exception as e:
            raise e
        
        self.products = list(map(lambda x: CreatePurchaseOrderProduct(x), data.get('products') if data.get('products') else []))
        self.shipping = Shipping(data.get('shipping')) if data.get('shipping') else None
        self.serviceFee = ServiceFee(data.get('serviceFee')) if data.get('serviceFee') else None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.companyId), [('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.warehouseId), [('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.vendorId), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.vendorNum), [('required', True),])
        if err is not None:
            return err
        
        _, err = verify(int(self.purchaserId), [('required', True),])
        if err is not None:
            return err
        
        
        
        
        # TODO valid list
        if False or self.shipping is not None:
            err = self.shipping.valid()
        else:
            err = None
        if err is not None:
            return err
        if False or self.serviceFee is not None:
            err = self.serviceFee.valid()
        else:
            err = None
        if err is not None:
            return err
        _, err = verify(int(self.id), [('gt', 0),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'companyId': self.companyId,
            'warehouseId': self.warehouseId,
            'vendorId': self.vendorId,
            'vendorNum': self.vendorNum,
            'vendorInvNo': self.vendorInvNo,
            'purchaserId': self.purchaserId,
            'purchaserName': self.purchaserName,
            'etaDatetime': self.etaDatetime,
            'postDatetime': self.postDatetime,
            'note': self.note,
            'products': _dump_value(self.products),
            'shipping': self.shipping.dump_(),
            'serviceFee': self.serviceFee.dump_(),
            'id': self.id,
        }

@dataclass(slots=True)
class ListPurchaseOrder:
    '''
    '''
    # Id
    id: str
    # OrderNum
    orderNum: str
    # Vendor ID
    vendorId: int
    # VendorNum
    vendorNum: str
    # VendorName
    vendorName: str
    # Purchaser
    purchaserId: int
    # PurchaserName
    purchaserName: str
    # ETA Date
    etaDatetime: str
    # POST Date
    postDatetime: str
    # Products
    products: int
    # ShippingAddress
    shippingAddress: str
    # ShippingMethod
    shippingMethod: str
    # TotalPrice
    totalPrice: str
    # FinalPrice
    finalPrice: str
    # ShippingPrice 
    shippingPrice: str
    # HandlingPrice 
    handlingPrice: str
    # MiscPrice
    miscPrice: str
    # AdjustmentPrice
    adjustmentPrice: str
    # Note
    note: str
    # CompanyId
    companyId: int
    # WarehouseId
    warehouseId: int
    # CreateUserName
    createUserName: str
    # CreateDatetime
    createDatetime: str
    # ModifyDatetime
    modifyDatetime: str
    # OrderStatus
    orderStatus: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = str(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('orderNum')
            if value not in (None,'null', 'none','None'):
                self.orderNum = str(value)
            else:
                self.orderNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorId')
            if value not in (None,'null', 'none','None'):
                self.vendorId = int(value)
            else:
                self.vendorId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorNum')
            if value not in (None,'null', 'none','None'):
                self.vendorNum = str(value)
            else:
                self.vendorNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorName')
            if value not in (None,'null', 'none','None'):
                self.vendorName = str(value)
            else:
                self.vendorName = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('purchaserId')
            if value not in (None,'null', 'none','None'):
                self.purchaserId = int(value)
            else:
                self.purchaserId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('purchaserName')
            if value not in (None,'null', 'none','None'):
                self.purchaserName = str(value)
            else:
                self.purchaserName = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('etaDatetime')
            if value not in (None,'null', 'none','None'):
                self.etaDatetime = str(value)
            else:
                self.etaDatetime = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('postDatetime')
            if value not in (None,'null', 'none','None'):
                self.postDatetime = str(value)
            else:
                self.postDatetime = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('products')
            if value not in (None,'null', 'none','None'):
                self.products = int(value)
            else:
                self.products = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('shippingAddress')
            if value not in (None,'null', 'none','None'):
                self.shippingAddress = str(value)
            else:
                self.shippingAddress = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('shippingMethod')
            if value not in (None,'null', 'none','None'):
                self.shippingMethod = str(value)
            else:
                self.shippingMethod = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('totalPrice')
            if value not in (None,'null', 'none','None'):
                self.totalPrice = str(value)
            else:
                self.totalPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('finalPrice')
            if value not in (None,'null', 'none','None'):
                self.finalPrice = str(value)
            else:
                self.finalPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('shippingPrice')
            if value not in (None,'null', 'none','None'):
                self.shippingPrice = str(value)
            else:
                self.shippingPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('handlingPrice')
            if value not in (None,'null', 'none','None'):
                self.handlingPrice = str(value)
            else:
                self.handlingPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('miscPrice')
            if value not in (None,'null', 'none','None'):
                self.miscPrice = str(value)
            else:
                self.miscPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('adjustmentPrice')
            if value not in (None,'null', 'none','None'):
                self.adjustmentPrice = str(value)
            else:
                self.adjustmentPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('note')
            if value not in (None,'null', 'none','None'):
                self.note = str(value)
            else:
                self.note = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('warehouseId')
            if value not in (None,'null', 'none','None'):
                self.warehouseId = int(value)
            else:
                self.warehouseId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('createUserName')
            if value not in (None,'null', 'none','None'):
                self.createUserName = str(value)
            else:
                self.createUserName = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('createDatetime')
            if value not in (None,'null', 'none','None'):
                self.createDatetime = str(value)
            else:
                self.createDatetime = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('modifyDatetime')
            if value not in (None,'null', 'none','None'):
                self.modifyDatetime = str(value)
            else:
                self.modifyDatetime = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('orderStatus')
            if value not in (None,'null', 'none','None'):
                self.orderStatus = str(value)
            else:
                self.orderStatus = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        _, err = verify(int(self.vendorId), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.vendorNum), [('required', True),])
        if err is not None:
            return err
        
        _, err = verify(int(self.purchaserId), [('required', True),])
        if err is not None:
            return err
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'orderNum': self.orderNum,
            'vendorId': self.vendorId,
            'vendorNum': self.vendorNum,
            'vendorName': self.vendorName,
            'purchaserId': self.purchaserId,
            'purchaserName': self.purchaserName,
            'etaDatetime': self.etaDatetime,
            'postDatetime': self.postDatetime,
            'products': self.products,
            'shippingAddress': self.shippingAddress,
            'shippingMethod': self.shippingMethod,
            'totalPrice': self.totalPrice,
            'finalPrice': self.finalPrice,
            'shippingPrice': self.shippingPrice,
            'handlingPrice': self.handlingPrice,
            'miscPrice': self.miscPrice,
            'adjustmentPrice': self.adjustmentPrice,
            'note': self.note,
            'companyId': self.companyId,
            'warehouseId': self.warehouseId,
            'createUserName': self.createUserName,
            'createDatetime': self.createDatetime,
            'modifyDatetime': self.modifyDatetime,
            'orderStatus': self.orderStatus,
        }

@dataclass(slots=True)
class PurchaseOrderListReq:
    '''
    '''
    # CompanyId
    companyId: int
    # WarehouseId
    warehouseId: int
    # OrderDateRange
    orderDateRange: TimeRange
    # EtaDateRange
    etaDateRange: TimeRange
    # filter by status
    status: PurchaseStatus
    # group by
    groupBy: PurchaseOrderListGroupBy
    # page size
    pageSize: int
    # 上一页最后一条记录的排序键，如果不是 id, 需要修改此字
    pageId: int
    # search keyword
    search: str
    # sort
    sort: PurchaseOrderListSortBy
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('warehouseId')
            if value not in (None,'null', 'none','None'):
                self.warehouseId = int(value)
            else:
                self.warehouseId = None
        except Exception as e:
            raise e
        
        self.orderDateRange = TimeRange(data.get('orderDateRange')) if data.get('orderDateRange') else None
        self.etaDateRange = TimeRange(data.get('etaDateRange')) if data.get('etaDateRange') else None
        self.status = PurchaseStatus(data.get('status'))
        self.groupBy = PurchaseOrderListGroupBy(data.get('groupBy'))
        try:
            value = data.get('pageSize')
            if value not in (None,'null', 'none','None'):
                self.pageSize = int(value)
            else:
                self.pageSize = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('pageId')
            if value not in (None,'null', 'none','None'):
                self.pageId = int(value)
            else:
                self.pageId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('search')
            if value not in (None,'null', 'none','None'):
                self.search = str(value)
            else:
                self.search = None
        except Exception as e:
            raise e
        
        self.sort = PurchaseOrderListSortBy(data.get('sort'))

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.companyId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.warehouseId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        if False or self.orderDateRange is not None:
            err = self.orderDateRange.valid()
        else:
            err = None
        if err is not None:
            return err
        if False or self.etaDateRange is not None:
            err = self.etaDateRange.valid()
        else:
            err = None
        if err is not None:
            return err
        err = self.status.valid()
        if err is not None:
            return err
        err = self.groupBy.valid()
        if err is not None:
            return err
        
        
        
        err = self.sort.valid()
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'companyId': self.companyId,
            'warehouseId': self.warehouseId,
            'orderDateRange': self.orderDateRange.dump_(),
            'etaDateRange': self.etaDateRange.dump_(),
            'status': self.status.value,
            'groupBy': self.groupBy.value,
            'pageSize': self.pageSize,
            'pageId': self.pageId,
            'search': self.search,
            'sort': self.sort.value,
        }

@dataclass(slots=True)
class SynPurchaseOrderReq:
    '''
    '''
    # PO ID
    id: int
    # CenterSalesOrderId 
    centerSalesOrderId: int
    # companyId
    companyId: int
    # CenterCompanyId
    centerCompanyId: int
    # orderStatus
    orderStatus: PurchaseStatus
    # totalPrice
    totalPrice: str
    # finalPrice
    finalPrice: str
    # grandPrice
    grandPrice: str
    # PostDatetime
    postDatetime: str
    # EtaDatetime
    etaDatetime: str
    # Note
    note: str
    # lines
    lines: list[SynProductLine]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('centerSalesOrderId')
            if value not in (None,'null', 'none','None'):
                self.centerSalesOrderId = int(value)
            else:
                self.centerSalesOrderId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('centerCompanyId')
            if value not in (None,'null', 'none','None'):
                self.centerCompanyId = int(value)
            else:
                self.centerCompanyId = None
        except Exception as e:
            raise e
        
        self.orderStatus = PurchaseStatus(data.get('orderStatus'))
        try:
            value = data.get('totalPrice')
            if value not in (None,'null', 'none','None'):
                self.totalPrice = str(value)
            else:
                self.totalPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('finalPrice')
            if value not in (None,'null', 'none','None'):
                self.finalPrice = str(value)
            else:
                self.finalPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('grandPrice')
            if value not in (None,'null', 'none','None'):
                self.grandPrice = str(value)
            else:
                self.grandPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('postDatetime')
            if value not in (None,'null', 'none','None'):
                self.postDatetime = str(value)
            else:
                self.postDatetime = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('etaDatetime')
            if value not in (None,'null', 'none','None'):
                self.etaDatetime = str(value)
            else:
                self.etaDatetime = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('note')
            if value not in (None,'null', 'none','None'):
                self.note = str(value)
            else:
                self.note = None
        except Exception as e:
            raise e
        
        self.lines = list(map(lambda x: SynProductLine(x), data.get('lines') if data.get('lines') else []))

    def valid(self):
        '''check object is valid'''
        
        _, err = verify(int(self.centerSalesOrderId), [('gt', 0),])
        if err is not None:
            return err
        _, err = verify(int(self.companyId), [('gt', 0),])
        if err is not None:
            return err
        _, err = verify(int(self.centerCompanyId), [('gt', 0),])
        if err is not None:
            return err
        err = self.orderStatus.valid()
        if err is not None:
            return err
        _, err = verify(str(self.totalPrice), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.finalPrice), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.grandPrice), [('required', True),])
        if err is not None:
            return err
        
        
        
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'centerSalesOrderId': self.centerSalesOrderId,
            'companyId': self.companyId,
            'centerCompanyId': self.centerCompanyId,
            'orderStatus': self.orderStatus.value,
            'totalPrice': self.totalPrice,
            'finalPrice': self.finalPrice,
            'grandPrice': self.grandPrice,
            'postDatetime': self.postDatetime,
            'etaDatetime': self.etaDatetime,
            'note': self.note,
            'lines': _dump_value(self.lines),
        }

@dataclass(slots=True)
class UpdatePurchaseOrderResp:
    '''
    '''
    # PurchaseOrderId
    purchaseOrderId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('purchaseOrderId')
            if value not in (None,'null', 'none','None'):
                self.purchaseOrderId = int(value)
            else:
                self.purchaseOrderId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'purchaseOrderId': self.purchaseOrderId,
        }

@dataclass(slots=True)
class PurchaseOrderListResp:
    '''
    '''
    # total
    total: float
    # page
    page: int
    # page_size
    page_size: int
    # pages
    pages: int
    # List of purchase orders
    data: list[ListPurchaseOrder]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('total')
            if value not in (None,'null', 'none','None'):
                self.total = float(value)
            else:
                self.total = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('page')
            if value not in (None,'null', 'none','None'):
                self.page = int(value)
            else:
                self.page = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('page_size')
            if value not in (None,'null', 'none','None'):
                self.page_size = int(value)
            else:
                self.page_size = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('pages')
            if value not in (None,'null', 'none','None'):
                self.pages = int(value)
            else:
                self.pages = None
        except Exception as e:
            raise e
        
        self.data = list(map(lambda x: ListPurchaseOrder(x), data.get('data') if data.get('data') else []))

    def valid(self):
        '''check object is valid'''
        
        
        
        
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'total': self.total,
            'page': self.page,
            'page_size': self.page_size,
            'pages': self.pages,
            'data': _dump_value(self.data),
        }

@dataclass(slots=True)
class PurchaseOrderLines:
    '''
    '''
    # Purchase Order Line
    id: int
    # PurchaseOrderId
    purchaseOrderId: int
    # Quantity
    quantity: float
    # Weight
    weight: float
    # UnitPrice
    unitPrice: str
    # Subtotal
    subtotal: str
    # Notation
    notation: str
    # ReceiveQuantity
    receiveQuantity: float
    # CenterProductId
    centerProductId: int
    # ProductId
    productId: int
    # Name
    name: str
    # Description
    description: str
    # RefNum
    refNum: str
    # VendorRefNum
    vendorRefNum: str
    # ProductNum
    productNum: str
    # NetWeight
    netWeight: float
    # packDate
    packDate: str
    # ProductType
    productType: str
    # PackageSize 
    packageSize: str
    # PackageType
    packageType: str
    # Thumbnail
    thumbnail: list[str]
    # Specification
    specification: list[str]
    # Dimension
    dimension: list[str]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('purchaseOrderId')
            if value not in (None,'null', 'none','None'):
                self.purchaseOrderId = int(value)
            else:
                self.purchaseOrderId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('quantity')
            if value not in (None,'null', 'none','None'):
                self.quantity = float(value)
            else:
                self.quantity = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('weight')
            if value not in (None,'null', 'none','None'):
                self.weight = float(value)
            else:
                self.weight = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('unitPrice')
            if value not in (None,'null', 'none','None'):
                self.unitPrice = str(value)
            else:
                self.unitPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('subtotal')
            if value not in (None,'null', 'none','None'):
                self.subtotal = str(value)
            else:
                self.subtotal = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('notation')
            if value not in (None,'null', 'none','None'):
                self.notation = str(value)
            else:
                self.notation = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('receiveQuantity')
            if value not in (None,'null', 'none','None'):
                self.receiveQuantity = float(value)
            else:
                self.receiveQuantity = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('centerProductId')
            if value not in (None,'null', 'none','None'):
                self.centerProductId = int(value)
            else:
                self.centerProductId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productId')
            if value not in (None,'null', 'none','None'):
                self.productId = int(value)
            else:
                self.productId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('description')
            if value not in (None,'null', 'none','None'):
                self.description = str(value)
            else:
                self.description = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('refNum')
            if value not in (None,'null', 'none','None'):
                self.refNum = str(value)
            else:
                self.refNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorRefNum')
            if value not in (None,'null', 'none','None'):
                self.vendorRefNum = str(value)
            else:
                self.vendorRefNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productNum')
            if value not in (None,'null', 'none','None'):
                self.productNum = str(value)
            else:
                self.productNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('netWeight')
            if value not in (None,'null', 'none','None'):
                self.netWeight = float(value)
            else:
                self.netWeight = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packDate')
            if value not in (None,'null', 'none','None'):
                self.packDate = str(value)
            else:
                self.packDate = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productType')
            if value not in (None,'null', 'none','None'):
                self.productType = str(value)
            else:
                self.productType = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packageSize')
            if value not in (None,'null', 'none','None'):
                self.packageSize = str(value)
            else:
                self.packageSize = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packageType')
            if value not in (None,'null', 'none','None'):
                self.packageType = str(value)
            else:
                self.packageType = None
        except Exception as e:
            raise e
        
        self.thumbnail = list(map(lambda x: str(x), data.get('thumbnail') if data.get('thumbnail') else []))
        self.specification = list(map(lambda x: str(x), data.get('specification') if data.get('specification') else []))
        self.dimension = list(map(lambda x: str(x), data.get('dimension') if data.get('dimension') else []))

    def valid(self):
        '''check object is valid'''
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        # TODO valid list
        # TODO valid list
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'purchaseOrderId': self.purchaseOrderId,
            'quantity': self.quantity,
            'weight': self.weight,
            'unitPrice': self.unitPrice,
            'subtotal': self.subtotal,
            'notation': self.notation,
            'receiveQuantity': self.receiveQuantity,
            'centerProductId': self.centerProductId,
            'productId': self.productId,
            'name': self.name,
            'description': self.description,
            'refNum': self.refNum,
            'vendorRefNum': self.vendorRefNum,
            'productNum': self.productNum,
            'netWeight': self.netWeight,
            'packDate': self.packDate,
            'productType': self.productType,
            'packageSize': self.packageSize,
            'packageType': self.packageType,
            'thumbnail': _dump_value(self.thumbnail),
            'specification': _dump_value(self.specification),
            'dimension': _dump_value(self.dimension),
        }

@dataclass(slots=True)
class GetPurchaseOrderByIdResp:
    '''
    '''
    # Id
    id: str
    # OrderNum
    orderNum: str
    # Vendor ID
    vendorId: int
    # VendorNum
    vendorNum: str
    # VendorName
    vendorName: str
    # Purchaser
    purchaserId: int
    # PurchaserName
    purchaserName: str
    # ETA Date
    etaDatetime: str
    # POST Date
    postDatetime: str
    # Prouducts
    products: list[PurchaseOrderLines]
    # ShippingAddress
    shippingAddress: str
    # ShippingMethod
    shippingMethod: str
    # TotalPrice
    totalPrice: str
    # FinalPrice
    finalPrice: str
    # ShippingPrice 
    shippingPrice: str
    # HandlingPrice 
    handlingPrice: str
    # MiscPrice
    miscPrice: str
    # AdjustmentPrice
    adjustmentPrice: str
    # Note
    note: str
    # CompanyId
    companyId: int
    # WarehouseId
    warehouseId: int
    # CreateUserName
    createUserName: str
    # CreateDatetime
    createDatetime: str
    # ModifyDatetime
    modifyDatetime: str
    # OrderStatus
    orderStatus: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = str(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('orderNum')
            if value not in (None,'null', 'none','None'):
                self.orderNum = str(value)
            else:
                self.orderNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorId')
            if value not in (None,'null', 'none','None'):
                self.vendorId = int(value)
            else:
                self.vendorId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorNum')
            if value not in (None,'null', 'none','None'):
                self.vendorNum = str(value)
            else:
                self.vendorNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorName')
            if value not in (None,'null', 'none','None'):
                self.vendorName = str(value)
            else:
                self.vendorName = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('purchaserId')
            if value not in (None,'null', 'none','None'):
                self.purchaserId = int(value)
            else:
                self.purchaserId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('purchaserName')
            if value not in (None,'null', 'none','None'):
                self.purchaserName = str(value)
            else:
                self.purchaserName = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('etaDatetime')
            if value not in (None,'null', 'none','None'):
                self.etaDatetime = str(value)
            else:
                self.etaDatetime = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('postDatetime')
            if value not in (None,'null', 'none','None'):
                self.postDatetime = str(value)
            else:
                self.postDatetime = None
        except Exception as e:
            raise e
        
        self.products = list(map(lambda x: PurchaseOrderLines(x), data.get('products') if data.get('products') else []))
        try:
            value = data.get('shippingAddress')
            if value not in (None,'null', 'none','None'):
                self.shippingAddress = str(value)
            else:
                self.shippingAddress = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('shippingMethod')
            if value not in (None,'null', 'none','None'):
                self.shippingMethod = str(value)
            else:
                self.shippingMethod = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('totalPrice')
            if value not in (None,'null', 'none','None'):
                self.totalPrice = str(value)
            else:
                self.totalPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('finalPrice')
            if value not in (None,'null', 'none','None'):
                self.finalPrice = str(value)
            else:
                self.finalPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('shippingPrice')
            if value not in (None,'null', 'none','None'):
                self.shippingPrice = str(value)
            else:
                self.shippingPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('handlingPrice')
            if value not in (None,'null', 'none','None'):
                self.handlingPrice = str(value)
            else:
                self.handlingPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('miscPrice')
            if value not in (None,'null', 'none','None'):
                self.miscPrice = str(value)
            else:
                self.miscPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('adjustmentPrice')
            if value not in (None,'null', 'none','None'):
                self.adjustmentPrice = str(value)
            else:
                self.adjustmentPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('note')
            if value not in (None,'null', 'none','None'):
                self.note = str(value)
            else:
                self.note = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('warehouseId')
            if value not in (None,'null', 'none','None'):
                self.warehouseId = int(value)
            else:
                self.warehouseId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('createUserName')
            if value not in (None,'null', 'none','None'):
                self.createUserName = str(value)
            else:
                self.createUserName = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('createDatetime')
            if value not in (None,'null', 'none','None'):
                self.createDatetime = str(value)
            else:
                self.createDatetime = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('modifyDatetime')
            if value not in (None,'null', 'none','None'):
                self.modifyDatetime = str(value)
            else:
                self.modifyDatetime = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('orderStatus')
            if value not in (None,'null', 'none','None'):
                self.orderStatus = str(value)
            else:
                self.orderStatus = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        _, err = verify(int(self.vendorId), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.vendorNum), [('required', True),])
        if err is not None:
            return err
        
        _, err = verify(int(self.purchaserId), [('required', True),])
        if err is not None:
            return err
        
        
        
        # TODO valid list
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'orderNum': self.orderNum,
            'vendorId': self.vendorId,
            'vendorNum': self.vendorNum,
            'vendorName': self.vendorName,
            'purchaserId': self.purchaserId,
            'purchaserName': self.purchaserName,
            'etaDatetime': self.etaDatetime,
            'postDatetime': self.postDatetime,
            'products': _dump_value(self.products),
            'shippingAddress': self.shippingAddress,
            'shippingMethod': self.shippingMethod,
            'totalPrice': self.totalPrice,
            'finalPrice': self.finalPrice,
            'shippingPrice': self.shippingPrice,
            'handlingPrice': self.handlingPrice,
            'miscPrice': self.miscPrice,
            'adjustmentPrice': self.adjustmentPrice,
            'note': self.note,
            'companyId': self.companyId,
            'warehouseId': self.warehouseId,
            'createUserName': self.createUserName,
            'createDatetime': self.createDatetime,
            'modifyDatetime': self.modifyDatetime,
            'orderStatus': self.orderStatus,
        }

@dataclass(slots=True)
class VoidPurchaseOrderReq:
    '''
    '''
    # PO ID
    id: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.id), [('gt', 0),('required', True),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
        }

@dataclass(slots=True)
class VoidPurchaseOrderResp:
    '''
    '''
    # success: true, fail: false
    ok: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ok')
            if value not in (None,'null', 'none','None'):
                self.ok = bool(value)
            else:
                self.ok = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ok': self.ok,
        }

@dataclass(slots=True)
class GetPurchaseOrderByIdReq:
    '''
    '''
    # PO ID
    id: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.id), [('gt', 0),('required', True),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
        }

@dataclass(slots=True)
class GetPurchaseOrderByOrderNumReq:
    '''
    '''
    # PO OrderNum
    orderNum: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('orderNum')
            if value not in (None,'null', 'none','None'):
                self.orderNum = str(value)
            else:
                self.orderNum = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(str(self.orderNum), [('required', True),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'orderNum': self.orderNum,
        }

@dataclass(slots=True)
class GetPurchasedForInventoryReq:
    '''
    '''
    # Product List
    productList: list[int]
    # Warehouse Id
    warehouseId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.productList = list(map(lambda x: int(x), data.get('productList') if data.get('productList') else []))
        try:
            value = data.get('warehouseId')
            if value not in (None,'null', 'none','None'):
                self.warehouseId = int(value)
            else:
                self.warehouseId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        # TODO valid list
        _, err = verify(int(self.warehouseId), [('required', True),('gt', 0),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'productList': _dump_value(self.productList),
            'warehouseId': self.warehouseId,
        }

@dataclass(slots=True)
class GetPurchasedForInventoryResp:
    '''
    '''
    # Product Map Purchased
    ProductMapPurchased: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ProductMapPurchased')
            if value not in (None,'null', 'none','None'):
                self.ProductMapPurchased = str(value)
            else:
                self.ProductMapPurchased = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ProductMapPurchased': self.ProductMapPurchased,
        }

@dataclass(slots=True)
class Batches:
    '''
    '''
    # ID
    id: int
    # Purchase_invoice_line_id
    purchaseInvoiceLineId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('purchaseInvoiceLineId')
            if value not in (None,'null', 'none','None'):
                self.purchaseInvoiceLineId = int(value)
            else:
                self.purchaseInvoiceLineId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.id), [('required', True),('gt', 0),])
        if err is not None:
            return err
        _, err = verify(int(self.purchaseInvoiceLineId), [('required', True),('gt', 0),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'purchaseInvoiceLineId': self.purchaseInvoiceLineId,
        }

@dataclass(slots=True)
class BindingBatchIdReq:
    '''
    '''
    # Batches
    batches: list[Batches]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.batches = list(map(lambda x: Batches(x), data.get('batches') if data.get('batches') else []))

    def valid(self):
        '''check object is valid'''
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'batches': _dump_value(self.batches),
        }

@dataclass(slots=True)
class BindingBatchIdResp:
    '''
    '''
    # success: true, fail: false
    ok: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ok')
            if value not in (None,'null', 'none','None'):
                self.ok = bool(value)
            else:
                self.ok = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ok': self.ok,
        }

@dataclass(slots=True)
class NewPurchaseReturnFromVendorOrder:
    '''
    '''
    # CompanyId
    companyId: int
    # WarehouseId
    warehouseId: int
    # Vendor ID
    vendorId: int
    # Return Type
    returnType: ReturnType
    # Return Date
    returnDate: str
    # Note
    note: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('warehouseId')
            if value not in (None,'null', 'none','None'):
                self.warehouseId = int(value)
            else:
                self.warehouseId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorId')
            if value not in (None,'null', 'none','None'):
                self.vendorId = int(value)
            else:
                self.vendorId = None
        except Exception as e:
            raise e
        
        self.returnType = ReturnType(data.get('returnType'))
        try:
            value = data.get('returnDate')
            if value not in (None,'null', 'none','None'):
                self.returnDate = str(value)
            else:
                self.returnDate = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('note')
            if value not in (None,'null', 'none','None'):
                self.note = str(value)
            else:
                self.note = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.companyId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.warehouseId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.vendorId), [('gt', 0),])
        if err is not None:
            return err
        err = self.returnType.valid()
        if err is not None:
            return err
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'companyId': self.companyId,
            'warehouseId': self.warehouseId,
            'vendorId': self.vendorId,
            'returnType': self.returnType.value,
            'returnDate': self.returnDate,
            'note': self.note,
        }

@dataclass(slots=True)
class NewPurchaseReturnProduct:
    '''
    '''
    # Product ID
    productId: int
    # PurchaseInvoiceLineId
    purchaseInvoiceLineId: int
    # Name
    name: str
    # Description
    description: str
    # NetWeight
    netWeight: str
    # RefNum
    refNum: str
    # ProductNum
    productNum: str
    # UnitPrice
    unitPrice: str
    # Return Quantity
    qty: int
    # Weight
    weight: float
    # Total WT
    totalWT: list[float]
    # Reason
    reason: ReturnReason
    # Note
    note: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('productId')
            if value not in (None,'null', 'none','None'):
                self.productId = int(value)
            else:
                self.productId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('purchaseInvoiceLineId')
            if value not in (None,'null', 'none','None'):
                self.purchaseInvoiceLineId = int(value)
            else:
                self.purchaseInvoiceLineId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('description')
            if value not in (None,'null', 'none','None'):
                self.description = str(value)
            else:
                self.description = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('netWeight')
            if value not in (None,'null', 'none','None'):
                self.netWeight = str(value)
            else:
                self.netWeight = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('refNum')
            if value not in (None,'null', 'none','None'):
                self.refNum = str(value)
            else:
                self.refNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productNum')
            if value not in (None,'null', 'none','None'):
                self.productNum = str(value)
            else:
                self.productNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('unitPrice')
            if value not in (None,'null', 'none','None'):
                self.unitPrice = str(value)
            else:
                self.unitPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('qty')
            if value not in (None,'null', 'none','None'):
                self.qty = int(value)
            else:
                self.qty = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('weight')
            if value not in (None,'null', 'none','None'):
                self.weight = float(value)
            else:
                self.weight = None
        except Exception as e:
            raise e
        
        self.totalWT = list(map(lambda x: float(x), data.get('totalWT') if data.get('totalWT') else []))
        self.reason = ReturnReason(data.get('reason'))
        try:
            value = data.get('note')
            if value not in (None,'null', 'none','None'):
                self.note = str(value)
            else:
                self.note = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.productId), [('gt', 0),])
        if err is not None:
            return err
        _, err = verify(int(self.purchaseInvoiceLineId), [('gt', 0),])
        if err is not None:
            return err
        
        
        
        
        
        
        _, err = verify(int(self.qty), [('gt', 0),])
        if err is not None:
            return err
        
        # TODO valid list
        err = self.reason.valid()
        if err is not None:
            return err
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'productId': self.productId,
            'purchaseInvoiceLineId': self.purchaseInvoiceLineId,
            'name': self.name,
            'description': self.description,
            'netWeight': self.netWeight,
            'refNum': self.refNum,
            'productNum': self.productNum,
            'unitPrice': self.unitPrice,
            'qty': self.qty,
            'weight': self.weight,
            'totalWT': _dump_value(self.totalWT),
            'reason': self.reason.value,
            'note': self.note,
        }

@dataclass(slots=True)
class NewPurchaseReturnShipping:
    '''
    '''
    # Shipping Method
    shippingMethod: ShippingMethod
    # Carry Type
    carryType: CarryType
    # Shipping Address
    shippingAddressId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.shippingMethod = ShippingMethod(data.get('shippingMethod'))
        self.carryType = CarryType(data.get('carryType'))
        try:
            value = data.get('shippingAddressId')
            if value not in (None,'null', 'none','None'):
                self.shippingAddressId = int(value)
            else:
                self.shippingAddressId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        err = self.shippingMethod.valid()
        if err is not None:
            return err
        err = self.carryType.valid()
        if err is not None:
            return err
        _, err = verify(int(self.shippingAddressId), [('gt', 0),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'shippingMethod': self.shippingMethod.value,
            'carryType': self.carryType.value,
            'shippingAddressId': self.shippingAddressId,
        }

@dataclass(slots=True)
class NewPurchaseReturnServiceFee:
    '''
    '''
    # Shipping $
    shippingFee: str
    # Handling $
    handlingFee: str
    # Misc $
    miscFee: str
    # Adjustment $
    adjustmentFee: str
    # Tax $
    taxFee: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('shippingFee')
            if value not in (None,'null', 'none','None'):
                self.shippingFee = str(value)
            else:
                self.shippingFee = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('handlingFee')
            if value not in (None,'null', 'none','None'):
                self.handlingFee = str(value)
            else:
                self.handlingFee = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('miscFee')
            if value not in (None,'null', 'none','None'):
                self.miscFee = str(value)
            else:
                self.miscFee = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('adjustmentFee')
            if value not in (None,'null', 'none','None'):
                self.adjustmentFee = str(value)
            else:
                self.adjustmentFee = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('taxFee')
            if value not in (None,'null', 'none','None'):
                self.taxFee = str(value)
            else:
                self.taxFee = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'shippingFee': self.shippingFee,
            'handlingFee': self.handlingFee,
            'miscFee': self.miscFee,
            'adjustmentFee': self.adjustmentFee,
            'taxFee': self.taxFee,
        }

@dataclass(slots=True)
class NewPurchaseReturnFromVendorReq:
    '''
    '''
    # Order
    order: NewPurchaseReturnFromVendorOrder
    # Products
    products: list[NewPurchaseReturnProduct]
    # Shipping
    shipping: NewPurchaseReturnShipping
    # Service Fee
    serviceFee: NewPurchaseReturnServiceFee
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.order = NewPurchaseReturnFromVendorOrder(data.get('order')) if data.get('order') else None
        self.products = list(map(lambda x: NewPurchaseReturnProduct(x), data.get('products') if data.get('products') else []))
        self.shipping = NewPurchaseReturnShipping(data.get('shipping')) if data.get('shipping') else None
        self.serviceFee = NewPurchaseReturnServiceFee(data.get('serviceFee')) if data.get('serviceFee') else None

    def valid(self):
        '''check object is valid'''
        if False or self.order is not None:
            err = self.order.valid()
        else:
            err = None
        if err is not None:
            return err
        # TODO valid list
        if False or self.shipping is not None:
            err = self.shipping.valid()
        else:
            err = None
        if err is not None:
            return err
        if False or self.serviceFee is not None:
            err = self.serviceFee.valid()
        else:
            err = None
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'order': self.order.dump_(),
            'products': _dump_value(self.products),
            'shipping': self.shipping.dump_(),
            'serviceFee': self.serviceFee.dump_(),
        }

@dataclass(slots=True)
class NewPurchaseReturnFromVendorResp:
    '''
    '''
    # Purchase Return ID List
    ids: list[str]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.ids = list(map(lambda x: str(x), data.get('ids') if data.get('ids') else []))

    def valid(self):
        '''check object is valid'''
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ids': _dump_value(self.ids),
        }

@dataclass(slots=True)
class NewPurchaseReturnFromPOOrder:
    '''
    '''
    # CompanyId
    companyId: int
    # WarehouseId
    warehouseId: int
    # PO No.
    poNo: str
    # Return Type
    returnType: ReturnType
    # Return Date
    returnDate: str
    # Note
    note: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('warehouseId')
            if value not in (None,'null', 'none','None'):
                self.warehouseId = int(value)
            else:
                self.warehouseId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('poNo')
            if value not in (None,'null', 'none','None'):
                self.poNo = str(value)
            else:
                self.poNo = None
        except Exception as e:
            raise e
        
        self.returnType = ReturnType(data.get('returnType'))
        try:
            value = data.get('returnDate')
            if value not in (None,'null', 'none','None'):
                self.returnDate = str(value)
            else:
                self.returnDate = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('note')
            if value not in (None,'null', 'none','None'):
                self.note = str(value)
            else:
                self.note = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.companyId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.warehouseId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.poNo), [('required', True),])
        if err is not None:
            return err
        err = self.returnType.valid()
        if err is not None:
            return err
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'companyId': self.companyId,
            'warehouseId': self.warehouseId,
            'poNo': self.poNo,
            'returnType': self.returnType.value,
            'returnDate': self.returnDate,
            'note': self.note,
        }

@dataclass(slots=True)
class NewPurchaseReturnFromPOReq:
    '''
    '''
    # Order
    order: NewPurchaseReturnFromPOOrder
    # Products
    products: list[NewPurchaseReturnProduct]
    # Shipping
    shipping: NewPurchaseReturnShipping
    # Service Fee
    serviceFee: NewPurchaseReturnServiceFee
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.order = NewPurchaseReturnFromPOOrder(data.get('order')) if data.get('order') else None
        self.products = list(map(lambda x: NewPurchaseReturnProduct(x), data.get('products') if data.get('products') else []))
        self.shipping = NewPurchaseReturnShipping(data.get('shipping')) if data.get('shipping') else None
        self.serviceFee = NewPurchaseReturnServiceFee(data.get('serviceFee')) if data.get('serviceFee') else None

    def valid(self):
        '''check object is valid'''
        if False or self.order is not None:
            err = self.order.valid()
        else:
            err = None
        if err is not None:
            return err
        # TODO valid list
        if False or self.shipping is not None:
            err = self.shipping.valid()
        else:
            err = None
        if err is not None:
            return err
        if False or self.serviceFee is not None:
            err = self.serviceFee.valid()
        else:
            err = None
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'order': self.order.dump_(),
            'products': _dump_value(self.products),
            'shipping': self.shipping.dump_(),
            'serviceFee': self.serviceFee.dump_(),
        }

@dataclass(slots=True)
class NewPurchaseReturnFromPOResp:
    '''
    '''
    # Purchase Return ID List
    ids: list[str]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.ids = list(map(lambda x: str(x), data.get('ids') if data.get('ids') else []))

    def valid(self):
        '''check object is valid'''
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ids': _dump_value(self.ids),
        }

@dataclass(slots=True)
class PurchaseReturnListReq:
    '''
    '''
    # CompanyId
    companyId: int
    # WarehouseId
    warehouseId: int
    # PageSize
    pageSize: int
    # PageId
    pageId: int
    # search keyword
    search: str
    # Order Date
    orderDate: TimeRange
    # Return Date
    returnDate: TimeRange
    # Status
    status: PurchaseReturnStatus
    # Group By
    groupBy: PurchaseReturnGroupBy
    # Sort By
    sortBy: PurchaseReturnSortBy
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('warehouseId')
            if value not in (None,'null', 'none','None'):
                self.warehouseId = int(value)
            else:
                self.warehouseId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('pageSize')
            if value not in (None,'null', 'none','None'):
                self.pageSize = int(value)
            else:
                self.pageSize = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('pageId')
            if value not in (None,'null', 'none','None'):
                self.pageId = int(value)
            else:
                self.pageId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('search')
            if value not in (None,'null', 'none','None'):
                self.search = str(value)
            else:
                self.search = None
        except Exception as e:
            raise e
        
        self.orderDate = TimeRange(data.get('orderDate')) if data.get('orderDate') else None
        self.returnDate = TimeRange(data.get('returnDate')) if data.get('returnDate') else None
        self.status = PurchaseReturnStatus(data.get('status'))
        self.groupBy = PurchaseReturnGroupBy(data.get('groupBy'))
        self.sortBy = PurchaseReturnSortBy(data.get('sortBy'))

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.companyId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.warehouseId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.pageSize), [('gt', 0),])
        if err is not None:
            return err
        _, err = verify(int(self.pageId), [('gt', 0),])
        if err is not None:
            return err
        
        if False or self.orderDate is not None:
            err = self.orderDate.valid()
        else:
            err = None
        if err is not None:
            return err
        if False or self.returnDate is not None:
            err = self.returnDate.valid()
        else:
            err = None
        if err is not None:
            return err
        err = self.status.valid()
        if err is not None:
            return err
        err = self.groupBy.valid()
        if err is not None:
            return err
        err = self.sortBy.valid()
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'companyId': self.companyId,
            'warehouseId': self.warehouseId,
            'pageSize': self.pageSize,
            'pageId': self.pageId,
            'search': self.search,
            'orderDate': self.orderDate.dump_(),
            'returnDate': self.returnDate.dump_(),
            'status': self.status.value,
            'groupBy': self.groupBy.value,
            'sortBy': self.sortBy.value,
        }

@dataclass(slots=True)
class PurchaseReturn:
    '''
    '''
    # Return No.
    prNum: str
    # Vendor
    vendorNum: str
    # Return $
    finalPrice: str
    # Return Type
    returnType: ReturnType
    # Service $
    unusedCredit: str
    # Return Date
    orderDate: datetime
    # Created
    createDatetime: datetime
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('prNum')
            if value not in (None,'null', 'none','None'):
                self.prNum = str(value)
            else:
                self.prNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorNum')
            if value not in (None,'null', 'none','None'):
                self.vendorNum = str(value)
            else:
                self.vendorNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('finalPrice')
            if value not in (None,'null', 'none','None'):
                self.finalPrice = str(value)
            else:
                self.finalPrice = None
        except Exception as e:
            raise e
        
        self.returnType = ReturnType(data.get('returnType'))
        try:
            value = data.get('unusedCredit')
            if value not in (None,'null', 'none','None'):
                self.unusedCredit = str(value)
            else:
                self.unusedCredit = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('orderDate')
            if value not in (None,'null', 'none','None'):
                self.orderDate = datetime(value)
            else:
                self.orderDate = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('createDatetime')
            if value not in (None,'null', 'none','None'):
                self.createDatetime = datetime(value)
            else:
                self.createDatetime = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        
        err = self.returnType.valid()
        if err is not None:
            return err
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'prNum': self.prNum,
            'vendorNum': self.vendorNum,
            'finalPrice': self.finalPrice,
            'returnType': self.returnType.value,
            'unusedCredit': self.unusedCredit,
            'orderDate': self.orderDate.strftime("%Y-%m-%d %H:%M:%S %Z %z"),
            'createDatetime': self.createDatetime.strftime("%Y-%m-%d %H:%M:%S %Z %z"),
        }

@dataclass(slots=True)
class PurchaseReturnGroup:
    '''
    '''
    # Name
    name: str
    # Returns
    returns: list[PurchaseReturn]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        self.returns = list(map(lambda x: PurchaseReturn(x), data.get('returns') if data.get('returns') else []))

    def valid(self):
        '''check object is valid'''
        
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'name': self.name,
            'returns': _dump_value(self.returns),
        }

@dataclass(slots=True)
class PurchaseReturnListResp:
    '''
    '''
    # total
    total: int
    # page 
    page: int
    # page_size 
    page_size: int
    # pages
    pages: int
    # groups
    groups: list[PurchaseReturnGroup]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('total')
            if value not in (None,'null', 'none','None'):
                self.total = int(value)
            else:
                self.total = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('page')
            if value not in (None,'null', 'none','None'):
                self.page = int(value)
            else:
                self.page = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('page_size')
            if value not in (None,'null', 'none','None'):
                self.page_size = int(value)
            else:
                self.page_size = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('pages')
            if value not in (None,'null', 'none','None'):
                self.pages = int(value)
            else:
                self.pages = None
        except Exception as e:
            raise e
        
        self.groups = list(map(lambda x: PurchaseReturnGroup(x), data.get('groups') if data.get('groups') else []))

    def valid(self):
        '''check object is valid'''
        
        
        
        
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'total': self.total,
            'page': self.page,
            'page_size': self.page_size,
            'pages': self.pages,
            'groups': _dump_value(self.groups),
        }

@dataclass(slots=True)
class UpdatePurchaseReturnOrder:
    '''
    '''
    # CompanyId
    companyId: int
    # WarehouseId
    warehouseId: int
    # PO No.
    poNo: str
    # Return Type
    returnType: ReturnType
    # Return Date
    returnDate: str
    # Note
    note: str
    # Vendor Id
    vendorId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('warehouseId')
            if value not in (None,'null', 'none','None'):
                self.warehouseId = int(value)
            else:
                self.warehouseId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('poNo')
            if value not in (None,'null', 'none','None'):
                self.poNo = str(value)
            else:
                self.poNo = None
        except Exception as e:
            raise e
        
        self.returnType = ReturnType(data.get('returnType'))
        try:
            value = data.get('returnDate')
            if value not in (None,'null', 'none','None'):
                self.returnDate = str(value)
            else:
                self.returnDate = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('note')
            if value not in (None,'null', 'none','None'):
                self.note = str(value)
            else:
                self.note = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorId')
            if value not in (None,'null', 'none','None'):
                self.vendorId = int(value)
            else:
                self.vendorId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.companyId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.warehouseId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.poNo), [('required', True),])
        if err is not None:
            return err
        err = self.returnType.valid()
        if err is not None:
            return err
        
        
        _, err = verify(int(self.vendorId), [('gt', 0),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'companyId': self.companyId,
            'warehouseId': self.warehouseId,
            'poNo': self.poNo,
            'returnType': self.returnType.value,
            'returnDate': self.returnDate,
            'note': self.note,
            'vendorId': self.vendorId,
        }

@dataclass(slots=True)
class UpdatePurchaseReturnReq:
    '''
    '''
    # Order
    order: NewPurchaseReturnFromPOOrder
    # Products
    products: list[NewPurchaseReturnProduct]
    # Shipping
    shipping: NewPurchaseReturnShipping
    # Service Fee
    serviceFee: NewPurchaseReturnServiceFee
    # Purchase Return ID
    id: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.order = NewPurchaseReturnFromPOOrder(data.get('order')) if data.get('order') else None
        self.products = list(map(lambda x: NewPurchaseReturnProduct(x), data.get('products') if data.get('products') else []))
        self.shipping = NewPurchaseReturnShipping(data.get('shipping')) if data.get('shipping') else None
        self.serviceFee = NewPurchaseReturnServiceFee(data.get('serviceFee')) if data.get('serviceFee') else None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        if False or self.order is not None:
            err = self.order.valid()
        else:
            err = None
        if err is not None:
            return err
        # TODO valid list
        if False or self.shipping is not None:
            err = self.shipping.valid()
        else:
            err = None
        if err is not None:
            return err
        if False or self.serviceFee is not None:
            err = self.serviceFee.valid()
        else:
            err = None
        if err is not None:
            return err
        _, err = verify(int(self.id), [('gt', 0),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'order': self.order.dump_(),
            'products': _dump_value(self.products),
            'shipping': self.shipping.dump_(),
            'serviceFee': self.serviceFee.dump_(),
            'id': self.id,
        }

@dataclass(slots=True)
class UpdatePurchaseReturnResp:
    '''
    '''
    # success: true, fail: false
    ok: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ok')
            if value not in (None,'null', 'none','None'):
                self.ok = bool(value)
            else:
                self.ok = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ok': self.ok,
        }

@dataclass(slots=True)
class PurchaseReturnByIdReq:
    '''
    '''
    # Purchase Return ID
    id: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.id), [('gt', 0),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
        }

@dataclass(slots=True)
class PurchaseReturnByIdResp:
    '''
    '''
    # Return No.
    prNum: str
    # Vendor
    vendorNum: str
    # Return $
    finalPrice: str
    # Return Type
    returnType: ReturnType
    # Service $
    unusedCredit: str
    # Return Date
    orderDate: datetime
    # Created
    createDatetime: datetime
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('prNum')
            if value not in (None,'null', 'none','None'):
                self.prNum = str(value)
            else:
                self.prNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorNum')
            if value not in (None,'null', 'none','None'):
                self.vendorNum = str(value)
            else:
                self.vendorNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('finalPrice')
            if value not in (None,'null', 'none','None'):
                self.finalPrice = str(value)
            else:
                self.finalPrice = None
        except Exception as e:
            raise e
        
        self.returnType = ReturnType(data.get('returnType'))
        try:
            value = data.get('unusedCredit')
            if value not in (None,'null', 'none','None'):
                self.unusedCredit = str(value)
            else:
                self.unusedCredit = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('orderDate')
            if value not in (None,'null', 'none','None'):
                self.orderDate = datetime(value)
            else:
                self.orderDate = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('createDatetime')
            if value not in (None,'null', 'none','None'):
                self.createDatetime = datetime(value)
            else:
                self.createDatetime = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        
        err = self.returnType.valid()
        if err is not None:
            return err
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'prNum': self.prNum,
            'vendorNum': self.vendorNum,
            'finalPrice': self.finalPrice,
            'returnType': self.returnType.value,
            'unusedCredit': self.unusedCredit,
            'orderDate': self.orderDate.strftime("%Y-%m-%d %H:%M:%S %Z %z"),
            'createDatetime': self.createDatetime.strftime("%Y-%m-%d %H:%M:%S %Z %z"),
        }

@dataclass(slots=True)
class VoidPurchaseReturnReq:
    '''
    '''
    # Purchase Return ID
    id: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.id), [('gt', 0),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
        }

@dataclass(slots=True)
class VoidPurchaseReturnResp:
    '''
    '''
    # success: true, fail: false
    ok: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ok')
            if value not in (None,'null', 'none','None'):
                self.ok = bool(value)
            else:
                self.ok = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ok': self.ok,
        }

@dataclass(slots=True)
class NewRecevingOrder:
    '''
    '''
    # Order ID
    orderId: int
    # Receive Date
    postDatetime: str
    # Note
    note: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('orderId')
            if value not in (None,'null', 'none','None'):
                self.orderId = int(value)
            else:
                self.orderId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('postDatetime')
            if value not in (None,'null', 'none','None'):
                self.postDatetime = str(value)
            else:
                self.postDatetime = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('note')
            if value not in (None,'null', 'none','None'):
                self.note = str(value)
            else:
                self.note = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.orderId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'orderId': self.orderId,
            'postDatetime': self.postDatetime,
            'note': self.note,
        }

@dataclass(slots=True)
class NewRecevingProduct:
    '''
    '''
    # CenterProduct ID
    centerProductId: int
    # AppproductId
    productId: int
    # Name
    name: str
    # Description
    description: str
    # RefNum
    refNum: str
    # ProductNum
    productNum: str
    # NetWeight
    netWeight: float
    # Quantity
    quantity: int
    # Unit Price
    unitPrice: str
    # Weight
    weight: float
    # Note
    notation: str
    # Location
    location: int
    # expireDate
    expireDate: str
    # packDate
    packDate: str
    # ProductType
    productType: str
    # PackageSize 
    packageSize: str
    # PackageType
    packageType: str
    # Thumbnail
    thumbnail: list[str]
    # Specification
    specification: list[str]
    # Dimension
    dimension: list[str]
    # OrdeLineId
    orderLineId: int
    # InvoiceLineId
    invoiceLineId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('centerProductId')
            if value not in (None,'null', 'none','None'):
                self.centerProductId = int(value)
            else:
                self.centerProductId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productId')
            if value not in (None,'null', 'none','None'):
                self.productId = int(value)
            else:
                self.productId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('description')
            if value not in (None,'null', 'none','None'):
                self.description = str(value)
            else:
                self.description = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('refNum')
            if value not in (None,'null', 'none','None'):
                self.refNum = str(value)
            else:
                self.refNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productNum')
            if value not in (None,'null', 'none','None'):
                self.productNum = str(value)
            else:
                self.productNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('netWeight')
            if value not in (None,'null', 'none','None'):
                self.netWeight = float(value)
            else:
                self.netWeight = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('quantity')
            if value not in (None,'null', 'none','None'):
                self.quantity = int(value)
            else:
                self.quantity = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('unitPrice')
            if value not in (None,'null', 'none','None'):
                self.unitPrice = str(value)
            else:
                self.unitPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('weight')
            if value not in (None,'null', 'none','None'):
                self.weight = float(value)
            else:
                self.weight = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('notation')
            if value not in (None,'null', 'none','None'):
                self.notation = str(value)
            else:
                self.notation = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('location')
            if value not in (None,'null', 'none','None'):
                self.location = int(value)
            else:
                self.location = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('expireDate')
            if value not in (None,'null', 'none','None'):
                self.expireDate = str(value)
            else:
                self.expireDate = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packDate')
            if value not in (None,'null', 'none','None'):
                self.packDate = str(value)
            else:
                self.packDate = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productType')
            if value not in (None,'null', 'none','None'):
                self.productType = str(value)
            else:
                self.productType = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packageSize')
            if value not in (None,'null', 'none','None'):
                self.packageSize = str(value)
            else:
                self.packageSize = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packageType')
            if value not in (None,'null', 'none','None'):
                self.packageType = str(value)
            else:
                self.packageType = None
        except Exception as e:
            raise e
        
        self.thumbnail = list(map(lambda x: str(x), data.get('thumbnail') if data.get('thumbnail') else []))
        self.specification = list(map(lambda x: str(x), data.get('specification') if data.get('specification') else []))
        self.dimension = list(map(lambda x: str(x), data.get('dimension') if data.get('dimension') else []))
        try:
            value = data.get('orderLineId')
            if value not in (None,'null', 'none','None'):
                self.orderLineId = int(value)
            else:
                self.orderLineId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('invoiceLineId')
            if value not in (None,'null', 'none','None'):
                self.invoiceLineId = int(value)
            else:
                self.invoiceLineId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        _, err = verify(str(self.name), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.description), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.refNum), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.productNum), [('required', True),])
        if err is not None:
            return err
        _, err = verify(float(self.netWeight), [('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.quantity), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.unitPrice), [('required', True),])
        if err is not None:
            return err
        
        
        
        
        
        
        
        
        # TODO valid list
        # TODO valid list
        # TODO valid list
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'centerProductId': self.centerProductId,
            'productId': self.productId,
            'name': self.name,
            'description': self.description,
            'refNum': self.refNum,
            'productNum': self.productNum,
            'netWeight': self.netWeight,
            'quantity': self.quantity,
            'unitPrice': self.unitPrice,
            'weight': self.weight,
            'notation': self.notation,
            'location': self.location,
            'expireDate': self.expireDate,
            'packDate': self.packDate,
            'productType': self.productType,
            'packageSize': self.packageSize,
            'packageType': self.packageType,
            'thumbnail': _dump_value(self.thumbnail),
            'specification': _dump_value(self.specification),
            'dimension': _dump_value(self.dimension),
            'orderLineId': self.orderLineId,
            'invoiceLineId': self.invoiceLineId,
        }

@dataclass(slots=True)
class NewRecevingServiceFee:
    '''
    '''
    # Shipping $
    shippingPrice: str
    # Handling $
    handlingPrice: str
    # Misc $
    miscPrice: str
    # Adjustment $
    adjustmentPrice: str
    # Cost Sharing Formula
    costSharingFormula: CostSharingFormula
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('shippingPrice')
            if value not in (None,'null', 'none','None'):
                self.shippingPrice = str(value)
            else:
                self.shippingPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('handlingPrice')
            if value not in (None,'null', 'none','None'):
                self.handlingPrice = str(value)
            else:
                self.handlingPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('miscPrice')
            if value not in (None,'null', 'none','None'):
                self.miscPrice = str(value)
            else:
                self.miscPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('adjustmentPrice')
            if value not in (None,'null', 'none','None'):
                self.adjustmentPrice = str(value)
            else:
                self.adjustmentPrice = None
        except Exception as e:
            raise e
        
        self.costSharingFormula = CostSharingFormula(data.get('costSharingFormula'))

    def valid(self):
        '''check object is valid'''
        
        
        
        
        err = self.costSharingFormula.valid()
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'shippingPrice': self.shippingPrice,
            'handlingPrice': self.handlingPrice,
            'miscPrice': self.miscPrice,
            'adjustmentPrice': self.adjustmentPrice,
            'costSharingFormula': self.costSharingFormula.value,
        }

@dataclass(slots=True)
class NewRecevingReq:
    '''
    '''
    # Order
    order: NewRecevingOrder
    # Products
    products: list[NewRecevingProduct]
    # Service Fee
    serviceFee: ServiceFee
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.order = NewRecevingOrder(data.get('order')) if data.get('order') else None
        self.products = list(map(lambda x: NewRecevingProduct(x), data.get('products') if data.get('products') else []))
        self.serviceFee = ServiceFee(data.get('serviceFee')) if data.get('serviceFee') else None

    def valid(self):
        '''check object is valid'''
        if False or self.order is not None:
            err = self.order.valid()
        else:
            err = None
        if err is not None:
            return err
        # TODO valid list
        if False or self.serviceFee is not None:
            err = self.serviceFee.valid()
        else:
            err = None
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'order': self.order.dump_(),
            'products': _dump_value(self.products),
            'serviceFee': self.serviceFee.dump_(),
        }

@dataclass(slots=True)
class NewRecevingResp:
    '''
    '''
    # Id
    id: int
    # InvoiceNum
    invoiceNum: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('invoiceNum')
            if value not in (None,'null', 'none','None'):
                self.invoiceNum = str(value)
            else:
                self.invoiceNum = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'invoiceNum': self.invoiceNum,
        }

@dataclass(slots=True)
class UpdateRecevingReq:
    '''
    '''
    # Order
    order: NewRecevingOrder
    # Products
    products: list[NewRecevingProduct]
    # Service Fee
    serviceFee: ServiceFee
    # Receive ID
    id: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.order = NewRecevingOrder(data.get('order')) if data.get('order') else None
        self.products = list(map(lambda x: NewRecevingProduct(x), data.get('products') if data.get('products') else []))
        self.serviceFee = ServiceFee(data.get('serviceFee')) if data.get('serviceFee') else None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        if False or self.order is not None:
            err = self.order.valid()
        else:
            err = None
        if err is not None:
            return err
        # TODO valid list
        if False or self.serviceFee is not None:
            err = self.serviceFee.valid()
        else:
            err = None
        if err is not None:
            return err
        _, err = verify(int(self.id), [('gt', 0),('required', True),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'order': self.order.dump_(),
            'products': _dump_value(self.products),
            'serviceFee': self.serviceFee.dump_(),
            'id': self.id,
        }

@dataclass(slots=True)
class UpdateRecevingResp:
    '''
    '''
    # Id
    id: int
    # InvoiceNum
    invoiceNum: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('invoiceNum')
            if value not in (None,'null', 'none','None'):
                self.invoiceNum = str(value)
            else:
                self.invoiceNum = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'invoiceNum': self.invoiceNum,
        }

@dataclass(slots=True)
class VoidRecevingReq:
    '''
    '''
    # Receive ID
    id: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.id), [('gt', 0),('required', True),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
        }

@dataclass(slots=True)
class VoidRecevingResp:
    '''
    '''
    # success: true, fail: false
    ok: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ok')
            if value not in (None,'null', 'none','None'):
                self.ok = bool(value)
            else:
                self.ok = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ok': self.ok,
        }

@dataclass(slots=True)
class FinalizeRecevingReq:
    '''
    '''
    # Receive ID
    id: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.id), [('gt', 0),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
        }

@dataclass(slots=True)
class FinalizeRecevingResp:
    '''
    '''
    # success: true, fail: false
    ok: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ok')
            if value not in (None,'null', 'none','None'):
                self.ok = bool(value)
            else:
                self.ok = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ok': self.ok,
        }

@dataclass(slots=True)
class ReceiveListReq:
    '''
    '''
    # CompanyId
    companyId: int
    # WarehouseId
    warehouseId: int
    # PageSize
    pageSize: int
    # PageId
    pageId: int
    # search
    search: str
    # Receive Date Range
    receiveDateRange: TimeRange
    # Status
    status: ReceiveStatus
    # Sort
    sort: ReceiveListSort
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('warehouseId')
            if value not in (None,'null', 'none','None'):
                self.warehouseId = int(value)
            else:
                self.warehouseId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('pageSize')
            if value not in (None,'null', 'none','None'):
                self.pageSize = int(value)
            else:
                self.pageSize = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('pageId')
            if value not in (None,'null', 'none','None'):
                self.pageId = int(value)
            else:
                self.pageId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('search')
            if value not in (None,'null', 'none','None'):
                self.search = str(value)
            else:
                self.search = None
        except Exception as e:
            raise e
        
        self.receiveDateRange = TimeRange(data.get('receiveDateRange')) if data.get('receiveDateRange') else None
        self.status = ReceiveStatus(data.get('status'))
        self.sort = ReceiveListSort(data.get('sort'))

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.companyId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.warehouseId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.pageSize), [('gt', 0),])
        if err is not None:
            return err
        _, err = verify(int(self.pageId), [('gt', 0),])
        if err is not None:
            return err
        
        if False or self.receiveDateRange is not None:
            err = self.receiveDateRange.valid()
        else:
            err = None
        if err is not None:
            return err
        err = self.status.valid()
        if err is not None:
            return err
        err = self.sort.valid()
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'companyId': self.companyId,
            'warehouseId': self.warehouseId,
            'pageSize': self.pageSize,
            'pageId': self.pageId,
            'search': self.search,
            'receiveDateRange': self.receiveDateRange.dump_(),
            'status': self.status.value,
            'sort': self.sort.value,
        }

@dataclass(slots=True)
class ReceiveInfo:
    '''
    '''
    # ID
    id: int
    # RCV No.
    invoiceNum: str
    # From
    fromPurchaseOrder: str
    # Total $
    totalPrice: str
    # ShippingPrice $
    shippingPrice: str
    # HandlingPrice $
    handlingPrice: str
    # MiscPrice $
    miscPrice: str
    # AdjustmentPrice $
    adjustmentPrice: str
    # Service $
    servicePrice: str
    # Vendor Invoice
    vendorNum: str
    # Vendor Name
    vendorName: str
    # InvoiceStatus
    invoiceStatus: str
    # Warehouse
    warehouse: str
    # Receive Date
    receiveDate: str
    # Operator
    operator: str
    # Note
    note: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('invoiceNum')
            if value not in (None,'null', 'none','None'):
                self.invoiceNum = str(value)
            else:
                self.invoiceNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('fromPurchaseOrder')
            if value not in (None,'null', 'none','None'):
                self.fromPurchaseOrder = str(value)
            else:
                self.fromPurchaseOrder = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('totalPrice')
            if value not in (None,'null', 'none','None'):
                self.totalPrice = str(value)
            else:
                self.totalPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('shippingPrice')
            if value not in (None,'null', 'none','None'):
                self.shippingPrice = str(value)
            else:
                self.shippingPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('handlingPrice')
            if value not in (None,'null', 'none','None'):
                self.handlingPrice = str(value)
            else:
                self.handlingPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('miscPrice')
            if value not in (None,'null', 'none','None'):
                self.miscPrice = str(value)
            else:
                self.miscPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('adjustmentPrice')
            if value not in (None,'null', 'none','None'):
                self.adjustmentPrice = str(value)
            else:
                self.adjustmentPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('servicePrice')
            if value not in (None,'null', 'none','None'):
                self.servicePrice = str(value)
            else:
                self.servicePrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorNum')
            if value not in (None,'null', 'none','None'):
                self.vendorNum = str(value)
            else:
                self.vendorNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorName')
            if value not in (None,'null', 'none','None'):
                self.vendorName = str(value)
            else:
                self.vendorName = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('invoiceStatus')
            if value not in (None,'null', 'none','None'):
                self.invoiceStatus = str(value)
            else:
                self.invoiceStatus = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('warehouse')
            if value not in (None,'null', 'none','None'):
                self.warehouse = str(value)
            else:
                self.warehouse = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('receiveDate')
            if value not in (None,'null', 'none','None'):
                self.receiveDate = str(value)
            else:
                self.receiveDate = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('operator')
            if value not in (None,'null', 'none','None'):
                self.operator = str(value)
            else:
                self.operator = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('note')
            if value not in (None,'null', 'none','None'):
                self.note = str(value)
            else:
                self.note = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'invoiceNum': self.invoiceNum,
            'fromPurchaseOrder': self.fromPurchaseOrder,
            'totalPrice': self.totalPrice,
            'shippingPrice': self.shippingPrice,
            'handlingPrice': self.handlingPrice,
            'miscPrice': self.miscPrice,
            'adjustmentPrice': self.adjustmentPrice,
            'servicePrice': self.servicePrice,
            'vendorNum': self.vendorNum,
            'vendorName': self.vendorName,
            'invoiceStatus': self.invoiceStatus,
            'warehouse': self.warehouse,
            'receiveDate': self.receiveDate,
            'operator': self.operator,
            'note': self.note,
        }

@dataclass(slots=True)
class ReceiveListResp:
    '''
    '''
    # total
    total: float
    # page
    page: int
    # page_size
    page_size: int
    # pages
    pages: int
    # Receive List
    list: list[ReceiveInfo]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('total')
            if value not in (None,'null', 'none','None'):
                self.total = float(value)
            else:
                self.total = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('page')
            if value not in (None,'null', 'none','None'):
                self.page = int(value)
            else:
                self.page = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('page_size')
            if value not in (None,'null', 'none','None'):
                self.page_size = int(value)
            else:
                self.page_size = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('pages')
            if value not in (None,'null', 'none','None'):
                self.pages = int(value)
            else:
                self.pages = None
        except Exception as e:
            raise e
        
        self.list = list(map(lambda x: ReceiveInfo(x), data.get('list') if data.get('list') else []))

    def valid(self):
        '''check object is valid'''
        
        
        
        
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'total': self.total,
            'page': self.page,
            'page_size': self.page_size,
            'pages': self.pages,
            'list': _dump_value(self.list),
        }

@dataclass(slots=True)
class GetReceiveHistoryByIdReq:
    '''
    '''
    # Receive ID
    id: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.id), [('gt', 0),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
        }

@dataclass(slots=True)
class GetReceiveHistoryByIdResp:
    '''
    '''
    # Order
    order: NewRecevingOrder
    # Products
    products: list[NewRecevingProduct]
    # Service Fee
    serviceFee: ServiceFee
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.order = NewRecevingOrder(data.get('order')) if data.get('order') else None
        self.products = list(map(lambda x: NewRecevingProduct(x), data.get('products') if data.get('products') else []))
        self.serviceFee = ServiceFee(data.get('serviceFee')) if data.get('serviceFee') else None

    def valid(self):
        '''check object is valid'''
        if False or self.order is not None:
            err = self.order.valid()
        else:
            err = None
        if err is not None:
            return err
        # TODO valid list
        if False or self.serviceFee is not None:
            err = self.serviceFee.valid()
        else:
            err = None
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'order': self.order.dump_(),
            'products': _dump_value(self.products),
            'serviceFee': self.serviceFee.dump_(),
        }

@dataclass(slots=True)
class RecevingLines:
    '''
    '''
    # Receving Order Line
    id: int
    # RecevingId
    purchaseInvoiceId: int
    # Quantity
    quantity: float
    # Weight
    weight: float
    # UnitPrice
    unitPrice: str
    # Subtotal
    subtotal: str
    # Notation
    notation: str
    # CenterProductId
    centerProductId: int
    # ProductId
    productId: int
    # Name
    name: str
    # Description
    description: str
    # RefNum
    refNum: str
    # VendorRefNum
    vendorRefNum: str
    # ProductNum
    productNum: str
    # NetWeight
    netWeight: float
    # packDate
    packDate: str
    # ProductType
    productType: str
    # PackageSize 
    packageSize: str
    # PackageType
    packageType: str
    # Thumbnail
    thumbnail: list[str]
    # Specification
    specification: list[str]
    # Dimension
    dimension: list[str]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('purchaseInvoiceId')
            if value not in (None,'null', 'none','None'):
                self.purchaseInvoiceId = int(value)
            else:
                self.purchaseInvoiceId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('quantity')
            if value not in (None,'null', 'none','None'):
                self.quantity = float(value)
            else:
                self.quantity = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('weight')
            if value not in (None,'null', 'none','None'):
                self.weight = float(value)
            else:
                self.weight = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('unitPrice')
            if value not in (None,'null', 'none','None'):
                self.unitPrice = str(value)
            else:
                self.unitPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('subtotal')
            if value not in (None,'null', 'none','None'):
                self.subtotal = str(value)
            else:
                self.subtotal = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('notation')
            if value not in (None,'null', 'none','None'):
                self.notation = str(value)
            else:
                self.notation = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('centerProductId')
            if value not in (None,'null', 'none','None'):
                self.centerProductId = int(value)
            else:
                self.centerProductId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productId')
            if value not in (None,'null', 'none','None'):
                self.productId = int(value)
            else:
                self.productId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('description')
            if value not in (None,'null', 'none','None'):
                self.description = str(value)
            else:
                self.description = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('refNum')
            if value not in (None,'null', 'none','None'):
                self.refNum = str(value)
            else:
                self.refNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorRefNum')
            if value not in (None,'null', 'none','None'):
                self.vendorRefNum = str(value)
            else:
                self.vendorRefNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productNum')
            if value not in (None,'null', 'none','None'):
                self.productNum = str(value)
            else:
                self.productNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('netWeight')
            if value not in (None,'null', 'none','None'):
                self.netWeight = float(value)
            else:
                self.netWeight = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packDate')
            if value not in (None,'null', 'none','None'):
                self.packDate = str(value)
            else:
                self.packDate = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productType')
            if value not in (None,'null', 'none','None'):
                self.productType = str(value)
            else:
                self.productType = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packageSize')
            if value not in (None,'null', 'none','None'):
                self.packageSize = str(value)
            else:
                self.packageSize = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packageType')
            if value not in (None,'null', 'none','None'):
                self.packageType = str(value)
            else:
                self.packageType = None
        except Exception as e:
            raise e
        
        self.thumbnail = list(map(lambda x: str(x), data.get('thumbnail') if data.get('thumbnail') else []))
        self.specification = list(map(lambda x: str(x), data.get('specification') if data.get('specification') else []))
        self.dimension = list(map(lambda x: str(x), data.get('dimension') if data.get('dimension') else []))

    def valid(self):
        '''check object is valid'''
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        # TODO valid list
        # TODO valid list
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'purchaseInvoiceId': self.purchaseInvoiceId,
            'quantity': self.quantity,
            'weight': self.weight,
            'unitPrice': self.unitPrice,
            'subtotal': self.subtotal,
            'notation': self.notation,
            'centerProductId': self.centerProductId,
            'productId': self.productId,
            'name': self.name,
            'description': self.description,
            'refNum': self.refNum,
            'vendorRefNum': self.vendorRefNum,
            'productNum': self.productNum,
            'netWeight': self.netWeight,
            'packDate': self.packDate,
            'productType': self.productType,
            'packageSize': self.packageSize,
            'packageType': self.packageType,
            'thumbnail': _dump_value(self.thumbnail),
            'specification': _dump_value(self.specification),
            'dimension': _dump_value(self.dimension),
        }

@dataclass(slots=True)
class GetRecevingByIdOrNumReq:
    '''
    '''
    # PI ID
    id: int
    # Num
    invoiceNum: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('invoiceNum')
            if value not in (None,'null', 'none','None'):
                self.invoiceNum = str(value)
            else:
                self.invoiceNum = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'invoiceNum': self.invoiceNum,
        }

@dataclass(slots=True)
class GetRecevingByIdOrNumResp:
    '''
    '''
    # ID
    id: int
    # RCV No.
    invoiceNum: str
    # From
    fromPurchaseOrder: str
    # Total $
    totalPrice: str
    # ShippingPrice $
    shippingPrice: str
    # HandlingPrice $
    handlingPrice: str
    # MiscPrice $
    miscPrice: str
    # AdjustmentPrice $
    adjustmentPrice: str
    # Service $
    servicePrice: str
    # Vendor Invoice
    vendorNum: str
    # Vendor Name
    vendorName: str
    # InvoiceStatus
    invoiceStatus: str
    # Warehouse
    warehouse: str
    # Receive Date
    receiveDate: str
    # Operator
    operator: str
    # Note
    note: str
    # Products
    products: list[RecevingLines]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('invoiceNum')
            if value not in (None,'null', 'none','None'):
                self.invoiceNum = str(value)
            else:
                self.invoiceNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('fromPurchaseOrder')
            if value not in (None,'null', 'none','None'):
                self.fromPurchaseOrder = str(value)
            else:
                self.fromPurchaseOrder = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('totalPrice')
            if value not in (None,'null', 'none','None'):
                self.totalPrice = str(value)
            else:
                self.totalPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('shippingPrice')
            if value not in (None,'null', 'none','None'):
                self.shippingPrice = str(value)
            else:
                self.shippingPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('handlingPrice')
            if value not in (None,'null', 'none','None'):
                self.handlingPrice = str(value)
            else:
                self.handlingPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('miscPrice')
            if value not in (None,'null', 'none','None'):
                self.miscPrice = str(value)
            else:
                self.miscPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('adjustmentPrice')
            if value not in (None,'null', 'none','None'):
                self.adjustmentPrice = str(value)
            else:
                self.adjustmentPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('servicePrice')
            if value not in (None,'null', 'none','None'):
                self.servicePrice = str(value)
            else:
                self.servicePrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorNum')
            if value not in (None,'null', 'none','None'):
                self.vendorNum = str(value)
            else:
                self.vendorNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorName')
            if value not in (None,'null', 'none','None'):
                self.vendorName = str(value)
            else:
                self.vendorName = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('invoiceStatus')
            if value not in (None,'null', 'none','None'):
                self.invoiceStatus = str(value)
            else:
                self.invoiceStatus = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('warehouse')
            if value not in (None,'null', 'none','None'):
                self.warehouse = str(value)
            else:
                self.warehouse = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('receiveDate')
            if value not in (None,'null', 'none','None'):
                self.receiveDate = str(value)
            else:
                self.receiveDate = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('operator')
            if value not in (None,'null', 'none','None'):
                self.operator = str(value)
            else:
                self.operator = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('note')
            if value not in (None,'null', 'none','None'):
                self.note = str(value)
            else:
                self.note = None
        except Exception as e:
            raise e
        
        self.products = list(map(lambda x: RecevingLines(x), data.get('products') if data.get('products') else []))

    def valid(self):
        '''check object is valid'''
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'invoiceNum': self.invoiceNum,
            'fromPurchaseOrder': self.fromPurchaseOrder,
            'totalPrice': self.totalPrice,
            'shippingPrice': self.shippingPrice,
            'handlingPrice': self.handlingPrice,
            'miscPrice': self.miscPrice,
            'adjustmentPrice': self.adjustmentPrice,
            'servicePrice': self.servicePrice,
            'vendorNum': self.vendorNum,
            'vendorName': self.vendorName,
            'invoiceStatus': self.invoiceStatus,
            'warehouse': self.warehouse,
            'receiveDate': self.receiveDate,
            'operator': self.operator,
            'note': self.note,
            'products': _dump_value(self.products),
        }

@dataclass(slots=True)
class VendorListReq:
    '''
    '''
    # Company_id
    company_id: int
    # Business
    businessType: list[Business]
    # search
    search: str
    # sort
    sort: VendorSortBy
    # order
    order: Order
    # PageId
    pageId: int
    # PageSize
    pageSize: int
    # PaymentTerms
    paymentTerms: PaymentTerm
    # Vendor Status
    isActive: VendorStatus
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('company_id')
            if value not in (None,'null', 'none','None'):
                self.company_id = int(value)
            else:
                self.company_id = None
        except Exception as e:
            raise e
        
        self.businessType = list(map(lambda x: Business(x), data.get('businessType') if data.get('businessType') else []))
        try:
            value = data.get('search')
            if value not in (None,'null', 'none','None'):
                self.search = str(value)
            else:
                self.search = None
        except Exception as e:
            raise e
        
        self.sort = VendorSortBy(data.get('sort'))
        self.order = Order(data.get('order'))
        try:
            value = data.get('pageId')
            if value not in (None,'null', 'none','None'):
                self.pageId = int(value)
            else:
                self.pageId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('pageSize')
            if value not in (None,'null', 'none','None'):
                self.pageSize = int(value)
            else:
                self.pageSize = None
        except Exception as e:
            raise e
        
        self.paymentTerms = PaymentTerm(data.get('paymentTerms'))
        self.isActive = VendorStatus(data.get('isActive'))

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.company_id), [('gt', 0),('required', True),])
        if err is not None:
            return err
        # TODO valid list
        
        err = self.sort.valid()
        if err is not None:
            return err
        err = self.order.valid()
        if err is not None:
            return err
        
        
        err = self.paymentTerms.valid()
        if err is not None:
            return err
        err = self.isActive.valid()
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'company_id': self.company_id,
            'businessType': _dump_value(self.businessType),
            'search': self.search,
            'sort': self.sort.value,
            'order': self.order.value,
            'pageId': self.pageId,
            'pageSize': self.pageSize,
            'paymentTerms': self.paymentTerms.value,
            'isActive': self.isActive.value,
        }

@dataclass(slots=True)
class Vendor:
    '''
    '''
    # Vendor ID
    id: int
    # Vendor Name
    name: str
    # Vendor No.
    vendorNum: str
    # Business
    businessType: Business
    # Payment Terms
    paymentTerms: PaymentTerm
    # IsActive
    isActive: VendorStatus
    # note
    note: str
    # PurchaserId
    purchaserId: int
    # PurchaserName
    purchaserName: str
    # Ascription_company_id
    ascription_company_id: int
    # levelGrade
    levelGrade: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorNum')
            if value not in (None,'null', 'none','None'):
                self.vendorNum = str(value)
            else:
                self.vendorNum = None
        except Exception as e:
            raise e
        
        self.businessType = Business(data.get('businessType'))
        self.paymentTerms = PaymentTerm(data.get('paymentTerms'))
        self.isActive = VendorStatus(data.get('isActive'))
        try:
            value = data.get('note')
            if value not in (None,'null', 'none','None'):
                self.note = str(value)
            else:
                self.note = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('purchaserId')
            if value not in (None,'null', 'none','None'):
                self.purchaserId = int(value)
            else:
                self.purchaserId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('purchaserName')
            if value not in (None,'null', 'none','None'):
                self.purchaserName = str(value)
            else:
                self.purchaserName = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('ascription_company_id')
            if value not in (None,'null', 'none','None'):
                self.ascription_company_id = int(value)
            else:
                self.ascription_company_id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('levelGrade')
            if value not in (None,'null', 'none','None'):
                self.levelGrade = int(value)
            else:
                self.levelGrade = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        
        err = self.businessType.valid()
        if err is not None:
            return err
        err = self.paymentTerms.valid()
        if err is not None:
            return err
        err = self.isActive.valid()
        if err is not None:
            return err
        
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'name': self.name,
            'vendorNum': self.vendorNum,
            'businessType': self.businessType.value,
            'paymentTerms': self.paymentTerms.value,
            'isActive': self.isActive.value,
            'note': self.note,
            'purchaserId': self.purchaserId,
            'purchaserName': self.purchaserName,
            'ascription_company_id': self.ascription_company_id,
            'levelGrade': self.levelGrade,
        }

@dataclass(slots=True)
class VendorListResp:
    '''
    '''
    # total
    total: float
    # page
    page: int
    # page_size
    page_size: int
    # pages
    pages: int
    # Vendor List
    data: list[Vendor]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('total')
            if value not in (None,'null', 'none','None'):
                self.total = float(value)
            else:
                self.total = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('page')
            if value not in (None,'null', 'none','None'):
                self.page = int(value)
            else:
                self.page = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('page_size')
            if value not in (None,'null', 'none','None'):
                self.page_size = int(value)
            else:
                self.page_size = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('pages')
            if value not in (None,'null', 'none','None'):
                self.pages = int(value)
            else:
                self.pages = None
        except Exception as e:
            raise e
        
        self.data = list(map(lambda x: Vendor(x), data.get('data') if data.get('data') else []))

    def valid(self):
        '''check object is valid'''
        
        
        
        
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'total': self.total,
            'page': self.page,
            'page_size': self.page_size,
            'pages': self.pages,
            'data': _dump_value(self.data),
        }

@dataclass(slots=True)
class CreateVendorReq:
    '''
    '''
    # Vendor Name
    name: str
    # Business Type
    businessType: Business
    # Payment Terms
    paymentTerms: PaymentTerm
    # CompanyId
    company_id: int
    # AscriptionCompanyId
    ascription_company_id: int
    # Email Address
    email: str
    # Phone Number
    phone: str
    # Note
    note: str
    # levelGrade
    levelGrade: int
    # Attachments
    attachments: list[str]
    # IsActive
    isActive: VendorStatus
    # PurchaserId
    purchaserId: int
    # PurchaserName
    purchaserName: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        self.businessType = Business(data.get('businessType'))
        self.paymentTerms = PaymentTerm(data.get('paymentTerms'))
        try:
            value = data.get('company_id')
            if value not in (None,'null', 'none','None'):
                self.company_id = int(value)
            else:
                self.company_id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('ascription_company_id')
            if value not in (None,'null', 'none','None'):
                self.ascription_company_id = int(value)
            else:
                self.ascription_company_id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('email')
            if value not in (None,'null', 'none','None'):
                self.email = str(value)
            else:
                self.email = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('phone')
            if value not in (None,'null', 'none','None'):
                self.phone = str(value)
            else:
                self.phone = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('note')
            if value not in (None,'null', 'none','None'):
                self.note = str(value)
            else:
                self.note = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('levelGrade')
            if value not in (None,'null', 'none','None'):
                self.levelGrade = int(value)
            else:
                self.levelGrade = None
        except Exception as e:
            raise e
        
        self.attachments = list(map(lambda x: str(x), data.get('attachments') if data.get('attachments') else []))
        self.isActive = VendorStatus(data.get('isActive'))
        try:
            value = data.get('purchaserId')
            if value not in (None,'null', 'none','None'):
                self.purchaserId = int(value)
            else:
                self.purchaserId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('purchaserName')
            if value not in (None,'null', 'none','None'):
                self.purchaserName = str(value)
            else:
                self.purchaserName = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(str(self.name), [('required', True),])
        if err is not None:
            return err
        err = self.businessType.valid()
        if err is not None:
            return err
        err = self.paymentTerms.valid()
        if err is not None:
            return err
        _, err = verify(int(self.company_id), [('gt', 0),('required', True),])
        if err is not None:
            return err
        
        _, err = verify(str(self.email), [('email', True),])
        if err is not None:
            return err
        _, err = verify(str(self.phone), [('phone', True),])
        if err is not None:
            return err
        
        
        # TODO valid list
        err = self.isActive.valid()
        if err is not None:
            return err
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'name': self.name,
            'businessType': self.businessType.value,
            'paymentTerms': self.paymentTerms.value,
            'company_id': self.company_id,
            'ascription_company_id': self.ascription_company_id,
            'email': self.email,
            'phone': self.phone,
            'note': self.note,
            'levelGrade': self.levelGrade,
            'attachments': _dump_value(self.attachments),
            'isActive': self.isActive.value,
            'purchaserId': self.purchaserId,
            'purchaserName': self.purchaserName,
        }

@dataclass(slots=True)
class CompanyInfo:
    '''
    '''
    # Name
    name: str
    # Contact
    contact: str
    # Street
    street: str
    # Street 2
    street2: str
    # Street 3
    street3: str
    # City
    city: str
    # State
    state: str
    # Zip Code
    zip: str
    # VendorId
    vendor_id: int
    # AddressType
    addressType: AddressType
    # Email
    email: str
    # Phone
    phone: str
    # IsShipping
    isShipping: bool
    # IsBilling
    isBilling: bool
    # IsDefaultShipping
    isDefaultShipping: bool
    # IsDefaultBilling
    isDefaultBilling: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('contact')
            if value not in (None,'null', 'none','None'):
                self.contact = str(value)
            else:
                self.contact = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('street')
            if value not in (None,'null', 'none','None'):
                self.street = str(value)
            else:
                self.street = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('street2')
            if value not in (None,'null', 'none','None'):
                self.street2 = str(value)
            else:
                self.street2 = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('street3')
            if value not in (None,'null', 'none','None'):
                self.street3 = str(value)
            else:
                self.street3 = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('city')
            if value not in (None,'null', 'none','None'):
                self.city = str(value)
            else:
                self.city = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('state')
            if value not in (None,'null', 'none','None'):
                self.state = str(value)
            else:
                self.state = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('zip')
            if value not in (None,'null', 'none','None'):
                self.zip = str(value)
            else:
                self.zip = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendor_id')
            if value not in (None,'null', 'none','None'):
                self.vendor_id = int(value)
            else:
                self.vendor_id = None
        except Exception as e:
            raise e
        
        self.addressType = AddressType(data.get('addressType'))
        try:
            value = data.get('email')
            if value not in (None,'null', 'none','None'):
                self.email = str(value)
            else:
                self.email = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('phone')
            if value not in (None,'null', 'none','None'):
                self.phone = str(value)
            else:
                self.phone = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isShipping')
            if value not in (None,'null', 'none','None'):
                self.isShipping = bool(value)
            else:
                self.isShipping = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isBilling')
            if value not in (None,'null', 'none','None'):
                self.isBilling = bool(value)
            else:
                self.isBilling = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isDefaultShipping')
            if value not in (None,'null', 'none','None'):
                self.isDefaultShipping = bool(value)
            else:
                self.isDefaultShipping = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isDefaultBilling')
            if value not in (None,'null', 'none','None'):
                self.isDefaultBilling = bool(value)
            else:
                self.isDefaultBilling = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(str(self.name), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.contact), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.street), [('required', True),])
        if err is not None:
            return err
        
        
        _, err = verify(str(self.city), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.state), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.zip), [('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.vendor_id), [('gt', 0),])
        if err is not None:
            return err
        err = self.addressType.valid()
        if err is not None:
            return err
        _, err = verify(str(self.email), [('email', True),])
        if err is not None:
            return err
        _, err = verify(str(self.phone), [('phone', True),])
        if err is not None:
            return err
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'name': self.name,
            'contact': self.contact,
            'street': self.street,
            'street2': self.street2,
            'street3': self.street3,
            'city': self.city,
            'state': self.state,
            'zip': self.zip,
            'vendor_id': self.vendor_id,
            'addressType': self.addressType.value,
            'email': self.email,
            'phone': self.phone,
            'isShipping': self.isShipping,
            'isBilling': self.isBilling,
            'isDefaultShipping': self.isDefaultShipping,
            'isDefaultBilling': self.isDefaultBilling,
        }

@dataclass(slots=True)
class AppCreateVendorReq:
    '''
    '''
    # Vendor Name
    name: str
    # Business Type
    businessType: Business
    # Payment Terms
    paymentTerms: PaymentTerm
    # CompanyId
    company_id: int
    # AscriptionCompanyId
    ascription_company_id: int
    # Email Address
    email: str
    # Phone Number
    phone: str
    # Note
    note: str
    # levelGrade
    levelGrade: int
    # Attachments
    attachments: list[str]
    # IsActive
    isActive: VendorStatus
    # PurchaserId
    purchaserId: int
    # PurchaserName
    purchaserName: str
    # Address
    addressList: list[CompanyInfo]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        self.businessType = Business(data.get('businessType'))
        self.paymentTerms = PaymentTerm(data.get('paymentTerms'))
        try:
            value = data.get('company_id')
            if value not in (None,'null', 'none','None'):
                self.company_id = int(value)
            else:
                self.company_id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('ascription_company_id')
            if value not in (None,'null', 'none','None'):
                self.ascription_company_id = int(value)
            else:
                self.ascription_company_id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('email')
            if value not in (None,'null', 'none','None'):
                self.email = str(value)
            else:
                self.email = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('phone')
            if value not in (None,'null', 'none','None'):
                self.phone = str(value)
            else:
                self.phone = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('note')
            if value not in (None,'null', 'none','None'):
                self.note = str(value)
            else:
                self.note = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('levelGrade')
            if value not in (None,'null', 'none','None'):
                self.levelGrade = int(value)
            else:
                self.levelGrade = None
        except Exception as e:
            raise e
        
        self.attachments = list(map(lambda x: str(x), data.get('attachments') if data.get('attachments') else []))
        self.isActive = VendorStatus(data.get('isActive'))
        try:
            value = data.get('purchaserId')
            if value not in (None,'null', 'none','None'):
                self.purchaserId = int(value)
            else:
                self.purchaserId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('purchaserName')
            if value not in (None,'null', 'none','None'):
                self.purchaserName = str(value)
            else:
                self.purchaserName = None
        except Exception as e:
            raise e
        
        self.addressList = list(map(lambda x: CompanyInfo(x), data.get('addressList') if data.get('addressList') else []))

    def valid(self):
        '''check object is valid'''
        _, err = verify(str(self.name), [('required', True),])
        if err is not None:
            return err
        err = self.businessType.valid()
        if err is not None:
            return err
        err = self.paymentTerms.valid()
        if err is not None:
            return err
        _, err = verify(int(self.company_id), [('gt', 0),('required', True),])
        if err is not None:
            return err
        
        _, err = verify(str(self.email), [('email', True),])
        if err is not None:
            return err
        _, err = verify(str(self.phone), [('phone', True),])
        if err is not None:
            return err
        
        
        # TODO valid list
        err = self.isActive.valid()
        if err is not None:
            return err
        
        
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'name': self.name,
            'businessType': self.businessType.value,
            'paymentTerms': self.paymentTerms.value,
            'company_id': self.company_id,
            'ascription_company_id': self.ascription_company_id,
            'email': self.email,
            'phone': self.phone,
            'note': self.note,
            'levelGrade': self.levelGrade,
            'attachments': _dump_value(self.attachments),
            'isActive': self.isActive.value,
            'purchaserId': self.purchaserId,
            'purchaserName': self.purchaserName,
            'addressList': _dump_value(self.addressList),
        }

@dataclass(slots=True)
class CreateVendorResp:
    '''
    '''
    # Vendor ID
    id: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
        }

@dataclass(slots=True)
class UpdateVendorReq:
    '''
    '''
    # Vendor Name
    name: str
    # Business Type
    businessType: Business
    # Payment Terms
    paymentTerms: PaymentTerm
    # CompanyId
    company_id: int
    # AscriptionCompanyId
    ascription_company_id: int
    # Email Address
    email: str
    # Phone Number
    phone: str
    # Note
    note: str
    # levelGrade
    levelGrade: int
    # Attachments
    attachments: list[str]
    # IsActive
    isActive: VendorStatus
    # PurchaserId
    purchaserId: int
    # PurchaserName
    purchaserName: str
    # Vendor ID
    id: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        self.businessType = Business(data.get('businessType'))
        self.paymentTerms = PaymentTerm(data.get('paymentTerms'))
        try:
            value = data.get('company_id')
            if value not in (None,'null', 'none','None'):
                self.company_id = int(value)
            else:
                self.company_id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('ascription_company_id')
            if value not in (None,'null', 'none','None'):
                self.ascription_company_id = int(value)
            else:
                self.ascription_company_id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('email')
            if value not in (None,'null', 'none','None'):
                self.email = str(value)
            else:
                self.email = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('phone')
            if value not in (None,'null', 'none','None'):
                self.phone = str(value)
            else:
                self.phone = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('note')
            if value not in (None,'null', 'none','None'):
                self.note = str(value)
            else:
                self.note = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('levelGrade')
            if value not in (None,'null', 'none','None'):
                self.levelGrade = int(value)
            else:
                self.levelGrade = None
        except Exception as e:
            raise e
        
        self.attachments = list(map(lambda x: str(x), data.get('attachments') if data.get('attachments') else []))
        self.isActive = VendorStatus(data.get('isActive'))
        try:
            value = data.get('purchaserId')
            if value not in (None,'null', 'none','None'):
                self.purchaserId = int(value)
            else:
                self.purchaserId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('purchaserName')
            if value not in (None,'null', 'none','None'):
                self.purchaserName = str(value)
            else:
                self.purchaserName = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(str(self.name), [('required', True),])
        if err is not None:
            return err
        err = self.businessType.valid()
        if err is not None:
            return err
        err = self.paymentTerms.valid()
        if err is not None:
            return err
        _, err = verify(int(self.company_id), [('gt', 0),('required', True),])
        if err is not None:
            return err
        
        _, err = verify(str(self.email), [('email', True),])
        if err is not None:
            return err
        _, err = verify(str(self.phone), [('phone', True),])
        if err is not None:
            return err
        
        
        # TODO valid list
        err = self.isActive.valid()
        if err is not None:
            return err
        
        
        _, err = verify(int(self.id), [('gt', 0),('required', True),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'name': self.name,
            'businessType': self.businessType.value,
            'paymentTerms': self.paymentTerms.value,
            'company_id': self.company_id,
            'ascription_company_id': self.ascription_company_id,
            'email': self.email,
            'phone': self.phone,
            'note': self.note,
            'levelGrade': self.levelGrade,
            'attachments': _dump_value(self.attachments),
            'isActive': self.isActive.value,
            'purchaserId': self.purchaserId,
            'purchaserName': self.purchaserName,
            'id': self.id,
        }

@dataclass(slots=True)
class UpdateVendorResp:
    '''
    '''
    # success: true, fail: false
    ok: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ok')
            if value not in (None,'null', 'none','None'):
                self.ok = bool(value)
            else:
                self.ok = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ok': self.ok,
        }

@dataclass(slots=True)
class DeleteVendorReq:
    '''
    '''
    # Vendor ID
    id: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.id), [('gt', 0),('required', True),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
        }

@dataclass(slots=True)
class DeleteVendorResp:
    '''
    '''
    # success: true, fail: false
    ok: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ok')
            if value not in (None,'null', 'none','None'):
                self.ok = bool(value)
            else:
                self.ok = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ok': self.ok,
        }

@dataclass(slots=True)
class GetVendorByCompanyIdReq:
    '''
    '''
    # CENTER
    center_company_id: int
    # APP
    app_company_id: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('center_company_id')
            if value not in (None,'null', 'none','None'):
                self.center_company_id = int(value)
            else:
                self.center_company_id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('app_company_id')
            if value not in (None,'null', 'none','None'):
                self.app_company_id = int(value)
            else:
                self.app_company_id = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'center_company_id': self.center_company_id,
            'app_company_id': self.app_company_id,
        }

@dataclass(slots=True)
class GetVendorByCompanyIdResp:
    '''
    '''
    # Vendor ID
    id: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
        }

@dataclass(slots=True)
class GetVendorByIdReq:
    '''
    '''
    # Vendor ID
    id: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
        }

@dataclass(slots=True)
class GetProductsByVendorReq:
    '''
    '''
    # VendorId
    vendorId: int
    # Ascription_company_id
    ascription_company_id: int
    # Level
    level: int
    # CategoryId
    categoryId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('vendorId')
            if value not in (None,'null', 'none','None'):
                self.vendorId = int(value)
            else:
                self.vendorId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('ascription_company_id')
            if value not in (None,'null', 'none','None'):
                self.ascription_company_id = int(value)
            else:
                self.ascription_company_id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('level')
            if value not in (None,'null', 'none','None'):
                self.level = int(value)
            else:
                self.level = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('categoryId')
            if value not in (None,'null', 'none','None'):
                self.categoryId = int(value)
            else:
                self.categoryId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'vendorId': self.vendorId,
            'ascription_company_id': self.ascription_company_id,
            'level': self.level,
            'categoryId': self.categoryId,
        }

@dataclass(slots=True)
class GetGroupsAndCategoriesByVendorReq:
    '''
    '''
    # Ascription_company_id
    ascription_company_id: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ascription_company_id')
            if value not in (None,'null', 'none','None'):
                self.ascription_company_id = int(value)
            else:
                self.ascription_company_id = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.ascription_company_id), [('gt', 0),('required', True),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ascription_company_id': self.ascription_company_id,
        }

@dataclass(slots=True)
class GetProductsByCenterReq:
    '''
    '''
    # VendorId
    vendorId: int
    # CenterProductIds
    centerProductIds: list[int]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('vendorId')
            if value not in (None,'null', 'none','None'):
                self.vendorId = int(value)
            else:
                self.vendorId = None
        except Exception as e:
            raise e
        
        self.centerProductIds = list(map(lambda x: int(x), data.get('centerProductIds') if data.get('centerProductIds') else []))

    def valid(self):
        '''check object is valid'''
        
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'vendorId': self.vendorId,
            'centerProductIds': _dump_value(self.centerProductIds),
        }

@dataclass(slots=True)
class GetVendorByIdResp:
    '''
    '''
    # Vendor Name
    name: str
    # Business Type
    businessType: Business
    # Payment Terms
    paymentTerms: PaymentTerm
    # CompanyId
    company_id: int
    # AscriptionCompanyId
    ascription_company_id: int
    # Email Address
    email: str
    # Phone Number
    phone: str
    # Note
    note: str
    # levelGrade
    levelGrade: int
    # Attachments
    attachments: list[str]
    # IsActive
    isActive: VendorStatus
    # PurchaserId
    purchaserId: int
    # PurchaserName
    purchaserName: str
    # Vendor ID
    id: int
    # vendorNum
    vendorNum: str
    # level
    level: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        self.businessType = Business(data.get('businessType'))
        self.paymentTerms = PaymentTerm(data.get('paymentTerms'))
        try:
            value = data.get('company_id')
            if value not in (None,'null', 'none','None'):
                self.company_id = int(value)
            else:
                self.company_id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('ascription_company_id')
            if value not in (None,'null', 'none','None'):
                self.ascription_company_id = int(value)
            else:
                self.ascription_company_id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('email')
            if value not in (None,'null', 'none','None'):
                self.email = str(value)
            else:
                self.email = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('phone')
            if value not in (None,'null', 'none','None'):
                self.phone = str(value)
            else:
                self.phone = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('note')
            if value not in (None,'null', 'none','None'):
                self.note = str(value)
            else:
                self.note = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('levelGrade')
            if value not in (None,'null', 'none','None'):
                self.levelGrade = int(value)
            else:
                self.levelGrade = None
        except Exception as e:
            raise e
        
        self.attachments = list(map(lambda x: str(x), data.get('attachments') if data.get('attachments') else []))
        self.isActive = VendorStatus(data.get('isActive'))
        try:
            value = data.get('purchaserId')
            if value not in (None,'null', 'none','None'):
                self.purchaserId = int(value)
            else:
                self.purchaserId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('purchaserName')
            if value not in (None,'null', 'none','None'):
                self.purchaserName = str(value)
            else:
                self.purchaserName = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorNum')
            if value not in (None,'null', 'none','None'):
                self.vendorNum = str(value)
            else:
                self.vendorNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('level')
            if value not in (None,'null', 'none','None'):
                self.level = str(value)
            else:
                self.level = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(str(self.name), [('required', True),])
        if err is not None:
            return err
        err = self.businessType.valid()
        if err is not None:
            return err
        err = self.paymentTerms.valid()
        if err is not None:
            return err
        _, err = verify(int(self.company_id), [('gt', 0),('required', True),])
        if err is not None:
            return err
        
        _, err = verify(str(self.email), [('email', True),])
        if err is not None:
            return err
        _, err = verify(str(self.phone), [('phone', True),])
        if err is not None:
            return err
        
        
        # TODO valid list
        err = self.isActive.valid()
        if err is not None:
            return err
        
        
        _, err = verify(int(self.id), [('gt', 0),('required', True),])
        if err is not None:
            return err
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'name': self.name,
            'businessType': self.businessType.value,
            'paymentTerms': self.paymentTerms.value,
            'company_id': self.company_id,
            'ascription_company_id': self.ascription_company_id,
            'email': self.email,
            'phone': self.phone,
            'note': self.note,
            'levelGrade': self.levelGrade,
            'attachments': _dump_value(self.attachments),
            'isActive': self.isActive.value,
            'purchaserId': self.purchaserId,
            'purchaserName': self.purchaserName,
            'id': self.id,
            'vendorNum': self.vendorNum,
            'level': self.level,
        }

@dataclass(slots=True)
class BalanceForwardReq:
    '''
    '''
    # Vendor ID
    id: int
    # Date Range
    dateRange: TimeRange
    # By Created Date or By Payment Date
    by: BalanceForwardBy
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        self.dateRange = TimeRange(data.get('dateRange')) if data.get('dateRange') else None
        self.by = BalanceForwardBy(data.get('by'))

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.id), [('gt', 0),])
        if err is not None:
            return err
        if False or self.dateRange is not None:
            err = self.dateRange.valid()
        else:
            err = None
        if err is not None:
            return err
        err = self.by.valid()
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'dateRange': self.dateRange.dump_(),
            'by': self.by.value,
        }

@dataclass(slots=True)
class BalanceForwardInfo:
    '''
    '''
    # Date
    date: str
    # Title
    title: str
    # Trans No.
    transNo: str
    # Trans No. status
    transNoStatus: TransNoStatus
    # Vendor Invoice No.
    vendorInvoiceNo: str
    # Charges
    charges: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('date')
            if value not in (None,'null', 'none','None'):
                self.date = str(value)
            else:
                self.date = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('title')
            if value not in (None,'null', 'none','None'):
                self.title = str(value)
            else:
                self.title = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('transNo')
            if value not in (None,'null', 'none','None'):
                self.transNo = str(value)
            else:
                self.transNo = None
        except Exception as e:
            raise e
        
        self.transNoStatus = TransNoStatus(data.get('transNoStatus'))
        try:
            value = data.get('vendorInvoiceNo')
            if value not in (None,'null', 'none','None'):
                self.vendorInvoiceNo = str(value)
            else:
                self.vendorInvoiceNo = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('charges')
            if value not in (None,'null', 'none','None'):
                self.charges = str(value)
            else:
                self.charges = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        
        err = self.transNoStatus.valid()
        if err is not None:
            return err
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'date': self.date,
            'title': self.title,
            'transNo': self.transNo,
            'transNoStatus': self.transNoStatus.value,
            'vendorInvoiceNo': self.vendorInvoiceNo,
            'charges': self.charges,
        }

@dataclass(slots=True)
class BalanceForwardResp:
    '''
    '''
    # Balance Forward
    balanceForward: str
    # Balance Forward List
    balanceForwardList: list[BalanceForwardInfo]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('balanceForward')
            if value not in (None,'null', 'none','None'):
                self.balanceForward = str(value)
            else:
                self.balanceForward = None
        except Exception as e:
            raise e
        
        self.balanceForwardList = list(map(lambda x: BalanceForwardInfo(x), data.get('balanceForwardList') if data.get('balanceForwardList') else []))

    def valid(self):
        '''check object is valid'''
        
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'balanceForward': self.balanceForward,
            'balanceForwardList': _dump_value(self.balanceForwardList),
        }

@dataclass(slots=True)
class TotalInvoiceReq:
    '''
    '''
    # Vendor ID
    id: int
    # Date Range
    dateRange: TimeRange
    # By Created Date or By Payment Date
    by: BalanceForwardBy
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        self.dateRange = TimeRange(data.get('dateRange')) if data.get('dateRange') else None
        self.by = BalanceForwardBy(data.get('by'))

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.id), [('gt', 0),])
        if err is not None:
            return err
        if False or self.dateRange is not None:
            err = self.dateRange.valid()
        else:
            err = None
        if err is not None:
            return err
        err = self.by.valid()
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'dateRange': self.dateRange.dump_(),
            'by': self.by.value,
        }

@dataclass(slots=True)
class TotalInvoiceInfo:
    '''
    '''
    # Date
    date: str
    # Title
    title: str
    # Trans No.
    transNo: str
    # Trans No. status
    transNoStatus: TransNoStatus
    # Vendor Invoice No.
    vendorInvoiceNo: str
    # Charges
    charges: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('date')
            if value not in (None,'null', 'none','None'):
                self.date = str(value)
            else:
                self.date = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('title')
            if value not in (None,'null', 'none','None'):
                self.title = str(value)
            else:
                self.title = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('transNo')
            if value not in (None,'null', 'none','None'):
                self.transNo = str(value)
            else:
                self.transNo = None
        except Exception as e:
            raise e
        
        self.transNoStatus = TransNoStatus(data.get('transNoStatus'))
        try:
            value = data.get('vendorInvoiceNo')
            if value not in (None,'null', 'none','None'):
                self.vendorInvoiceNo = str(value)
            else:
                self.vendorInvoiceNo = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('charges')
            if value not in (None,'null', 'none','None'):
                self.charges = str(value)
            else:
                self.charges = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        
        err = self.transNoStatus.valid()
        if err is not None:
            return err
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'date': self.date,
            'title': self.title,
            'transNo': self.transNo,
            'transNoStatus': self.transNoStatus.value,
            'vendorInvoiceNo': self.vendorInvoiceNo,
            'charges': self.charges,
        }

@dataclass(slots=True)
class TotalInvoiceResp:
    '''
    '''
    # Total Invoice
    totalInvoice: str
    # Total Invoice List
    totalInvoiceList: list[TotalInvoiceInfo]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('totalInvoice')
            if value not in (None,'null', 'none','None'):
                self.totalInvoice = str(value)
            else:
                self.totalInvoice = None
        except Exception as e:
            raise e
        
        self.totalInvoiceList = list(map(lambda x: TotalInvoiceInfo(x), data.get('totalInvoiceList') if data.get('totalInvoiceList') else []))

    def valid(self):
        '''check object is valid'''
        
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'totalInvoice': self.totalInvoice,
            'totalInvoiceList': _dump_value(self.totalInvoiceList),
        }

@dataclass(slots=True)
class TotalPaymentReq:
    '''
    '''
    # Vendor ID
    id: int
    # Date Range
    dateRange: TimeRange
    # By Created Date or By Payment Date
    by: BalanceForwardBy
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        self.dateRange = TimeRange(data.get('dateRange')) if data.get('dateRange') else None
        self.by = BalanceForwardBy(data.get('by'))

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.id), [('gt', 0),])
        if err is not None:
            return err
        if False or self.dateRange is not None:
            err = self.dateRange.valid()
        else:
            err = None
        if err is not None:
            return err
        err = self.by.valid()
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'dateRange': self.dateRange.dump_(),
            'by': self.by.value,
        }

@dataclass(slots=True)
class TotalPaymentInfo:
    '''
    '''
    # Date
    date: str
    # Title
    title: str
    # Trans No.
    transNo: str
    # Trans No. status
    transNoStatus: TransNoStatus
    # Credit
    credit: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('date')
            if value not in (None,'null', 'none','None'):
                self.date = str(value)
            else:
                self.date = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('title')
            if value not in (None,'null', 'none','None'):
                self.title = str(value)
            else:
                self.title = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('transNo')
            if value not in (None,'null', 'none','None'):
                self.transNo = str(value)
            else:
                self.transNo = None
        except Exception as e:
            raise e
        
        self.transNoStatus = TransNoStatus(data.get('transNoStatus'))
        try:
            value = data.get('credit')
            if value not in (None,'null', 'none','None'):
                self.credit = str(value)
            else:
                self.credit = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        
        err = self.transNoStatus.valid()
        if err is not None:
            return err
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'date': self.date,
            'title': self.title,
            'transNo': self.transNo,
            'transNoStatus': self.transNoStatus.value,
            'credit': self.credit,
        }

@dataclass(slots=True)
class TotalPaymentResp:
    '''
    '''
    # Total Payment
    totalPayment: str
    # Total Payment List
    totalPaymentList: list[TotalPaymentInfo]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('totalPayment')
            if value not in (None,'null', 'none','None'):
                self.totalPayment = str(value)
            else:
                self.totalPayment = None
        except Exception as e:
            raise e
        
        self.totalPaymentList = list(map(lambda x: TotalPaymentInfo(x), data.get('totalPaymentList') if data.get('totalPaymentList') else []))

    def valid(self):
        '''check object is valid'''
        
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'totalPayment': self.totalPayment,
            'totalPaymentList': _dump_value(self.totalPaymentList),
        }

@dataclass(slots=True)
class OutstandingBalanceReq:
    '''
    '''
    # Vendor ID
    id: int
    # Date Range
    dateRange: TimeRange
    # By Created Date or By Payment Date
    by: BalanceForwardBy
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        self.dateRange = TimeRange(data.get('dateRange')) if data.get('dateRange') else None
        self.by = BalanceForwardBy(data.get('by'))

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.id), [('gt', 0),])
        if err is not None:
            return err
        if False or self.dateRange is not None:
            err = self.dateRange.valid()
        else:
            err = None
        if err is not None:
            return err
        err = self.by.valid()
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'dateRange': self.dateRange.dump_(),
            'by': self.by.value,
        }

@dataclass(slots=True)
class OutstandingBalanceInfo:
    '''
    '''
    # Date
    date: str
    # Title
    title: str
    # Trans No.
    transNo: str
    # Vendor Invoice No.
    vendorInvoiceNo: str
    # Charges
    charges: str
    # Credit
    credit: str
    # Balance
    balance: str
    # Credit Used
    creditUsed: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('date')
            if value not in (None,'null', 'none','None'):
                self.date = str(value)
            else:
                self.date = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('title')
            if value not in (None,'null', 'none','None'):
                self.title = str(value)
            else:
                self.title = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('transNo')
            if value not in (None,'null', 'none','None'):
                self.transNo = str(value)
            else:
                self.transNo = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorInvoiceNo')
            if value not in (None,'null', 'none','None'):
                self.vendorInvoiceNo = str(value)
            else:
                self.vendorInvoiceNo = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('charges')
            if value not in (None,'null', 'none','None'):
                self.charges = str(value)
            else:
                self.charges = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('credit')
            if value not in (None,'null', 'none','None'):
                self.credit = str(value)
            else:
                self.credit = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('balance')
            if value not in (None,'null', 'none','None'):
                self.balance = str(value)
            else:
                self.balance = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('creditUsed')
            if value not in (None,'null', 'none','None'):
                self.creditUsed = str(value)
            else:
                self.creditUsed = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        
        
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'date': self.date,
            'title': self.title,
            'transNo': self.transNo,
            'vendorInvoiceNo': self.vendorInvoiceNo,
            'charges': self.charges,
            'credit': self.credit,
            'balance': self.balance,
            'creditUsed': self.creditUsed,
        }

@dataclass(slots=True)
class OutstandingBalanceResp:
    '''
    '''
    # Outstanding Balance
    outstandingBalance: str
    # Outstanding Balance List
    outstandingBalanceList: list[OutstandingBalanceInfo]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('outstandingBalance')
            if value not in (None,'null', 'none','None'):
                self.outstandingBalance = str(value)
            else:
                self.outstandingBalance = None
        except Exception as e:
            raise e
        
        self.outstandingBalanceList = list(map(lambda x: OutstandingBalanceInfo(x), data.get('outstandingBalanceList') if data.get('outstandingBalanceList') else []))

    def valid(self):
        '''check object is valid'''
        
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'outstandingBalance': self.outstandingBalance,
            'outstandingBalanceList': _dump_value(self.outstandingBalanceList),
        }

@dataclass(slots=True)
class RemainingBalanceReq:
    '''
    '''
    # Vendor ID
    id: int
    # Date Range
    dateRange: TimeRange
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        self.dateRange = TimeRange(data.get('dateRange')) if data.get('dateRange') else None

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.id), [('gt', 0),])
        if err is not None:
            return err
        if False or self.dateRange is not None:
            err = self.dateRange.valid()
        else:
            err = None
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'dateRange': self.dateRange.dump_(),
        }

@dataclass(slots=True)
class RemainingBalanceResp:
    '''
    '''
    # Remaining Balance
    remainingBalance: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('remainingBalance')
            if value not in (None,'null', 'none','None'):
                self.remainingBalance = str(value)
            else:
                self.remainingBalance = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'remainingBalance': self.remainingBalance,
        }

@dataclass(slots=True)
class VendorAgedReportReq:
    '''
    '''
    # Vendor ID
    id: int
    # Statement Date
    statementDate: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('statementDate')
            if value not in (None,'null', 'none','None'):
                self.statementDate = str(value)
            else:
                self.statementDate = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.id), [('gt', 0),])
        if err is not None:
            return err
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'statementDate': self.statementDate,
        }

@dataclass(slots=True)
class VendorAgedReportResp:
    '''
    '''
    # Total
    total: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('total')
            if value not in (None,'null', 'none','None'):
                self.total = str(value)
            else:
                self.total = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'total': self.total,
        }

@dataclass(slots=True)
class VendorAgedReportWithDateRangeReq:
    '''
    '''
    # Vendor ID
    id: int
    # Date Range
    dateRange: TimeRange
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        self.dateRange = TimeRange(data.get('dateRange')) if data.get('dateRange') else None

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.id), [('gt', 0),])
        if err is not None:
            return err
        if False or self.dateRange is not None:
            err = self.dateRange.valid()
        else:
            err = None
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'dateRange': self.dateRange.dump_(),
        }

@dataclass(slots=True)
class VendorAgedReportInfo:
    '''
    '''
    # Date
    date: str
    # Title
    title: str
    # Trans No.
    transNo: str
    # Trans No. status
    transNoStatus: TransNoStatus
    # Vendor Invoice No.
    vendorInvoiceNo: str
    # Charges
    charges: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('date')
            if value not in (None,'null', 'none','None'):
                self.date = str(value)
            else:
                self.date = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('title')
            if value not in (None,'null', 'none','None'):
                self.title = str(value)
            else:
                self.title = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('transNo')
            if value not in (None,'null', 'none','None'):
                self.transNo = str(value)
            else:
                self.transNo = None
        except Exception as e:
            raise e
        
        self.transNoStatus = TransNoStatus(data.get('transNoStatus'))
        try:
            value = data.get('vendorInvoiceNo')
            if value not in (None,'null', 'none','None'):
                self.vendorInvoiceNo = str(value)
            else:
                self.vendorInvoiceNo = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('charges')
            if value not in (None,'null', 'none','None'):
                self.charges = str(value)
            else:
                self.charges = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        
        err = self.transNoStatus.valid()
        if err is not None:
            return err
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'date': self.date,
            'title': self.title,
            'transNo': self.transNo,
            'transNoStatus': self.transNoStatus.value,
            'vendorInvoiceNo': self.vendorInvoiceNo,
            'charges': self.charges,
        }

@dataclass(slots=True)
class VendorAgedReportWithDateRangeResp:
    '''
    '''
    # Total
    total: str
    # List
    list: list[VendorAgedReportInfo]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('total')
            if value not in (None,'null', 'none','None'):
                self.total = str(value)
            else:
                self.total = None
        except Exception as e:
            raise e
        
        self.list = list(map(lambda x: VendorAgedReportInfo(x), data.get('list') if data.get('list') else []))

    def valid(self):
        '''check object is valid'''
        
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'total': self.total,
            'list': _dump_value(self.list),
        }

@dataclass(slots=True)
class AppProduct:
    '''
    '''
    # Id
    id: int
    # Name
    name: str
    # ProductNum
    productNum: str
    # RefNum
    refNum: str
    # GeneralNum
    generalNum: str
    # Product Price
    productPrice: float
    # NetWeight
    netWeight: float
    # PackageType
    packageType: str
    # PackageSize
    packageSize: str
    # ProductType
    productType: str
    # Instock 
    instock: float
    # thumbnail
    thumbnail: list[str]
    # Specification
    specification: list[str]
    # Dimension
    dimension: list[str]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productNum')
            if value not in (None,'null', 'none','None'):
                self.productNum = str(value)
            else:
                self.productNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('refNum')
            if value not in (None,'null', 'none','None'):
                self.refNum = str(value)
            else:
                self.refNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('generalNum')
            if value not in (None,'null', 'none','None'):
                self.generalNum = str(value)
            else:
                self.generalNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productPrice')
            if value not in (None,'null', 'none','None'):
                self.productPrice = float(value)
            else:
                self.productPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('netWeight')
            if value not in (None,'null', 'none','None'):
                self.netWeight = float(value)
            else:
                self.netWeight = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packageType')
            if value not in (None,'null', 'none','None'):
                self.packageType = str(value)
            else:
                self.packageType = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packageSize')
            if value not in (None,'null', 'none','None'):
                self.packageSize = str(value)
            else:
                self.packageSize = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productType')
            if value not in (None,'null', 'none','None'):
                self.productType = str(value)
            else:
                self.productType = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('instock')
            if value not in (None,'null', 'none','None'):
                self.instock = float(value)
            else:
                self.instock = None
        except Exception as e:
            raise e
        
        self.thumbnail = list(map(lambda x: str(x), data.get('thumbnail') if data.get('thumbnail') else []))
        self.specification = list(map(lambda x: str(x), data.get('specification') if data.get('specification') else []))
        self.dimension = list(map(lambda x: str(x), data.get('dimension') if data.get('dimension') else []))

    def valid(self):
        '''check object is valid'''
        
        
        
        
        
        
        
        
        
        
        
        # TODO valid list
        # TODO valid list
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'name': self.name,
            'productNum': self.productNum,
            'refNum': self.refNum,
            'generalNum': self.generalNum,
            'productPrice': self.productPrice,
            'netWeight': self.netWeight,
            'packageType': self.packageType,
            'packageSize': self.packageSize,
            'productType': self.productType,
            'instock': self.instock,
            'thumbnail': _dump_value(self.thumbnail),
            'specification': _dump_value(self.specification),
            'dimension': _dump_value(self.dimension),
        }

@dataclass(slots=True)
class Product:
    '''
    '''
    # Id
    id: int
    # Name
    name: str
    # ProductNum
    productNum: str
    # RefNum
    refNum: str
    # GeneralNum
    generalNum: str
    # Product Price
    productPrice: float
    # NetWeight
    netWeight: float
    # PackageType
    packageType: str
    # PackageSize
    packageSize: str
    # ProductType
    productType: str
    # Instock 
    instock: float
    # thumbnail
    thumbnail: list[str]
    # Specification
    specification: list[str]
    # Dimension
    dimension: list[str]
    # AppProduct
    appProduct: AppProduct
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productNum')
            if value not in (None,'null', 'none','None'):
                self.productNum = str(value)
            else:
                self.productNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('refNum')
            if value not in (None,'null', 'none','None'):
                self.refNum = str(value)
            else:
                self.refNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('generalNum')
            if value not in (None,'null', 'none','None'):
                self.generalNum = str(value)
            else:
                self.generalNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productPrice')
            if value not in (None,'null', 'none','None'):
                self.productPrice = float(value)
            else:
                self.productPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('netWeight')
            if value not in (None,'null', 'none','None'):
                self.netWeight = float(value)
            else:
                self.netWeight = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packageType')
            if value not in (None,'null', 'none','None'):
                self.packageType = str(value)
            else:
                self.packageType = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packageSize')
            if value not in (None,'null', 'none','None'):
                self.packageSize = str(value)
            else:
                self.packageSize = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productType')
            if value not in (None,'null', 'none','None'):
                self.productType = str(value)
            else:
                self.productType = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('instock')
            if value not in (None,'null', 'none','None'):
                self.instock = float(value)
            else:
                self.instock = None
        except Exception as e:
            raise e
        
        self.thumbnail = list(map(lambda x: str(x), data.get('thumbnail') if data.get('thumbnail') else []))
        self.specification = list(map(lambda x: str(x), data.get('specification') if data.get('specification') else []))
        self.dimension = list(map(lambda x: str(x), data.get('dimension') if data.get('dimension') else []))
        self.appProduct = AppProduct(data.get('appProduct')) if data.get('appProduct') else None

    def valid(self):
        '''check object is valid'''
        
        
        
        
        
        
        
        
        
        
        
        # TODO valid list
        # TODO valid list
        # TODO valid list
        if False or self.appProduct is not None:
            err = self.appProduct.valid()
        else:
            err = None
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'name': self.name,
            'productNum': self.productNum,
            'refNum': self.refNum,
            'generalNum': self.generalNum,
            'productPrice': self.productPrice,
            'netWeight': self.netWeight,
            'packageType': self.packageType,
            'packageSize': self.packageSize,
            'productType': self.productType,
            'instock': self.instock,
            'thumbnail': _dump_value(self.thumbnail),
            'specification': _dump_value(self.specification),
            'dimension': _dump_value(self.dimension),
            'appProduct': self.appProduct.dump_(),
        }

@dataclass(slots=True)
class GetProductByCenterResp:
    '''
    '''
    # Id
    id: int
    # CompanyId
    companyId: int
    # Name
    name: str
    # Description
    description: str
    # ProductNum
    productNum: str
    # GeneraNum
    generalNum: str
    # RefNum
    refNum: str
    # ProductType
    productType: str
    # PackageType
    packageType: str
    # NetWeight
    netWeight: float
    # PackageSize
    packageSize: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('description')
            if value not in (None,'null', 'none','None'):
                self.description = str(value)
            else:
                self.description = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productNum')
            if value not in (None,'null', 'none','None'):
                self.productNum = str(value)
            else:
                self.productNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('generalNum')
            if value not in (None,'null', 'none','None'):
                self.generalNum = str(value)
            else:
                self.generalNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('refNum')
            if value not in (None,'null', 'none','None'):
                self.refNum = str(value)
            else:
                self.refNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productType')
            if value not in (None,'null', 'none','None'):
                self.productType = str(value)
            else:
                self.productType = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packageType')
            if value not in (None,'null', 'none','None'):
                self.packageType = str(value)
            else:
                self.packageType = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('netWeight')
            if value not in (None,'null', 'none','None'):
                self.netWeight = float(value)
            else:
                self.netWeight = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packageSize')
            if value not in (None,'null', 'none','None'):
                self.packageSize = str(value)
            else:
                self.packageSize = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        
        
        
        
        
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'companyId': self.companyId,
            'name': self.name,
            'description': self.description,
            'productNum': self.productNum,
            'generalNum': self.generalNum,
            'refNum': self.refNum,
            'productType': self.productType,
            'packageType': self.packageType,
            'netWeight': self.netWeight,
            'packageSize': self.packageSize,
        }

@dataclass(slots=True)
class GetProductsByVendorResp:
    '''
    '''
    # Product List
    products: list[Product]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.products = list(map(lambda x: Product(x), data.get('products') if data.get('products') else []))

    def valid(self):
        '''check object is valid'''
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'products': _dump_value(self.products),
        }

@dataclass(slots=True)
class Categories:
    '''
    '''
    # Id
    id: int
    # CompanyId
    companyId: int
    # GroupId
    groupId: int
    # ScmCategoryId
    scm_categoryId: int
    # CategoryNum
    categoryNum: str
    # Name
    name: str
    # Description
    description: str
    # IsDeleted
    isDeleted: bool
    # Image
    image: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('groupId')
            if value not in (None,'null', 'none','None'):
                self.groupId = int(value)
            else:
                self.groupId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('scm_categoryId')
            if value not in (None,'null', 'none','None'):
                self.scm_categoryId = int(value)
            else:
                self.scm_categoryId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('categoryNum')
            if value not in (None,'null', 'none','None'):
                self.categoryNum = str(value)
            else:
                self.categoryNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('description')
            if value not in (None,'null', 'none','None'):
                self.description = str(value)
            else:
                self.description = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isDeleted')
            if value not in (None,'null', 'none','None'):
                self.isDeleted = bool(value)
            else:
                self.isDeleted = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('image')
            if value not in (None,'null', 'none','None'):
                self.image = str(value)
            else:
                self.image = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        
        
        
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'companyId': self.companyId,
            'groupId': self.groupId,
            'scm_categoryId': self.scm_categoryId,
            'categoryNum': self.categoryNum,
            'name': self.name,
            'description': self.description,
            'isDeleted': self.isDeleted,
            'image': self.image,
        }

@dataclass(slots=True)
class Groups:
    '''
    '''
    # Id
    id: int
    # CompanyId
    companyId: int
    # ScmGroupId
    scm_groupId: int
    # GroupNum
    groupNum: str
    # Name
    name: str
    # Description
    description: str
    # IsDeleted
    isDeleted: bool
    # Image
    image: str
    # categories
    categories: list[Categories]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('scm_groupId')
            if value not in (None,'null', 'none','None'):
                self.scm_groupId = int(value)
            else:
                self.scm_groupId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('groupNum')
            if value not in (None,'null', 'none','None'):
                self.groupNum = str(value)
            else:
                self.groupNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('description')
            if value not in (None,'null', 'none','None'):
                self.description = str(value)
            else:
                self.description = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isDeleted')
            if value not in (None,'null', 'none','None'):
                self.isDeleted = bool(value)
            else:
                self.isDeleted = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('image')
            if value not in (None,'null', 'none','None'):
                self.image = str(value)
            else:
                self.image = None
        except Exception as e:
            raise e
        
        self.categories = list(map(lambda x: Categories(x), data.get('categories') if data.get('categories') else []))

    def valid(self):
        '''check object is valid'''
        
        
        
        
        
        
        
        
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'companyId': self.companyId,
            'scm_groupId': self.scm_groupId,
            'groupNum': self.groupNum,
            'name': self.name,
            'description': self.description,
            'isDeleted': self.isDeleted,
            'image': self.image,
            'categories': _dump_value(self.categories),
        }

@dataclass(slots=True)
class GetGroupsAndCategoriesByVendorResp:
    '''
    '''
    # Groups List
    groups: list[Groups]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.groups = list(map(lambda x: Groups(x), data.get('groups') if data.get('groups') else []))

    def valid(self):
        '''check object is valid'''
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'groups': _dump_value(self.groups),
        }

@dataclass(slots=True)
class GetProductsByCenterResp:
    '''
    '''
    # Get App products By Center Products
    products: list[GetProductByCenterResp]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.products = list(map(lambda x: GetProductByCenterResp(x), data.get('products') if data.get('products') else []))

    def valid(self):
        '''check object is valid'''
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'products': _dump_value(self.products),
        }

@dataclass(slots=True)
class GetVendorsByIdsReq:
    '''
    '''
    # GetVendorsByProductIdReq
    vendorIds: list[int]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.vendorIds = list(map(lambda x: int(x), data.get('vendorIds') if data.get('vendorIds') else []))

    def valid(self):
        '''check object is valid'''
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'vendorIds': _dump_value(self.vendorIds),
        }

@dataclass(slots=True)
class GetVendorsByIdsResp:
    '''
    '''
    # GetVendorsByProductIdResp
    vendors: list[Vendor]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.vendors = list(map(lambda x: Vendor(x), data.get('vendors') if data.get('vendors') else []))

    def valid(self):
        '''check object is valid'''
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'vendors': _dump_value(self.vendors),
        }

@dataclass(slots=True)
class GetVendorAddressListReq:
    '''
    '''
    # Vendor ID
    vendorId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('vendorId')
            if value not in (None,'null', 'none','None'):
                self.vendorId = int(value)
            else:
                self.vendorId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.vendorId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'vendorId': self.vendorId,
        }

@dataclass(slots=True)
class CompanyInformation:
    '''
    '''
    # Name
    name: str
    # Contact
    contact: str
    # Street
    street: str
    # Street 2
    street2: str
    # Street 3
    street3: str
    # City
    city: str
    # State
    state: str
    # Zip Code
    zip: str
    # VendorId
    vendor_id: int
    # AddressType
    addressType: AddressType
    # Email
    email: str
    # Phone
    phone: str
    # IsShipping
    isShipping: bool
    # IsBilling
    isBilling: bool
    # IsDefaultShipping
    isDefaultShipping: bool
    # IsDefaultBilling
    isDefaultBilling: bool
    # Address ID
    id: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('contact')
            if value not in (None,'null', 'none','None'):
                self.contact = str(value)
            else:
                self.contact = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('street')
            if value not in (None,'null', 'none','None'):
                self.street = str(value)
            else:
                self.street = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('street2')
            if value not in (None,'null', 'none','None'):
                self.street2 = str(value)
            else:
                self.street2 = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('street3')
            if value not in (None,'null', 'none','None'):
                self.street3 = str(value)
            else:
                self.street3 = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('city')
            if value not in (None,'null', 'none','None'):
                self.city = str(value)
            else:
                self.city = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('state')
            if value not in (None,'null', 'none','None'):
                self.state = str(value)
            else:
                self.state = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('zip')
            if value not in (None,'null', 'none','None'):
                self.zip = str(value)
            else:
                self.zip = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendor_id')
            if value not in (None,'null', 'none','None'):
                self.vendor_id = int(value)
            else:
                self.vendor_id = None
        except Exception as e:
            raise e
        
        self.addressType = AddressType(data.get('addressType'))
        try:
            value = data.get('email')
            if value not in (None,'null', 'none','None'):
                self.email = str(value)
            else:
                self.email = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('phone')
            if value not in (None,'null', 'none','None'):
                self.phone = str(value)
            else:
                self.phone = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isShipping')
            if value not in (None,'null', 'none','None'):
                self.isShipping = bool(value)
            else:
                self.isShipping = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isBilling')
            if value not in (None,'null', 'none','None'):
                self.isBilling = bool(value)
            else:
                self.isBilling = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isDefaultShipping')
            if value not in (None,'null', 'none','None'):
                self.isDefaultShipping = bool(value)
            else:
                self.isDefaultShipping = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isDefaultBilling')
            if value not in (None,'null', 'none','None'):
                self.isDefaultBilling = bool(value)
            else:
                self.isDefaultBilling = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(str(self.name), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.contact), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.street), [('required', True),])
        if err is not None:
            return err
        
        
        _, err = verify(str(self.city), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.state), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.zip), [('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.vendor_id), [('gt', 0),])
        if err is not None:
            return err
        err = self.addressType.valid()
        if err is not None:
            return err
        _, err = verify(str(self.email), [('email', True),])
        if err is not None:
            return err
        _, err = verify(str(self.phone), [('phone', True),])
        if err is not None:
            return err
        
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'name': self.name,
            'contact': self.contact,
            'street': self.street,
            'street2': self.street2,
            'street3': self.street3,
            'city': self.city,
            'state': self.state,
            'zip': self.zip,
            'vendor_id': self.vendor_id,
            'addressType': self.addressType.value,
            'email': self.email,
            'phone': self.phone,
            'isShipping': self.isShipping,
            'isBilling': self.isBilling,
            'isDefaultShipping': self.isDefaultShipping,
            'isDefaultBilling': self.isDefaultBilling,
            'id': self.id,
        }

@dataclass(slots=True)
class GetVendorAddressListResp:
    '''
    '''
    # Vendor Address List
    addresses: list[CompanyInformation]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.addresses = list(map(lambda x: CompanyInformation(x), data.get('addresses') if data.get('addresses') else []))

    def valid(self):
        '''check object is valid'''
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'addresses': _dump_value(self.addresses),
        }

@dataclass(slots=True)
class CreateVendorAddressReq:
    '''
    '''
    # Name
    name: str
    # Contact
    contact: str
    # Street
    street: str
    # Street 2
    street2: str
    # Street 3
    street3: str
    # City
    city: str
    # State
    state: str
    # Zip Code
    zip: str
    # VendorId
    vendor_id: int
    # AddressType
    addressType: AddressType
    # Email
    email: str
    # Phone
    phone: str
    # IsShipping
    isShipping: bool
    # IsBilling
    isBilling: bool
    # IsDefaultShipping
    isDefaultShipping: bool
    # IsDefaultBilling
    isDefaultBilling: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('contact')
            if value not in (None,'null', 'none','None'):
                self.contact = str(value)
            else:
                self.contact = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('street')
            if value not in (None,'null', 'none','None'):
                self.street = str(value)
            else:
                self.street = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('street2')
            if value not in (None,'null', 'none','None'):
                self.street2 = str(value)
            else:
                self.street2 = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('street3')
            if value not in (None,'null', 'none','None'):
                self.street3 = str(value)
            else:
                self.street3 = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('city')
            if value not in (None,'null', 'none','None'):
                self.city = str(value)
            else:
                self.city = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('state')
            if value not in (None,'null', 'none','None'):
                self.state = str(value)
            else:
                self.state = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('zip')
            if value not in (None,'null', 'none','None'):
                self.zip = str(value)
            else:
                self.zip = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendor_id')
            if value not in (None,'null', 'none','None'):
                self.vendor_id = int(value)
            else:
                self.vendor_id = None
        except Exception as e:
            raise e
        
        self.addressType = AddressType(data.get('addressType'))
        try:
            value = data.get('email')
            if value not in (None,'null', 'none','None'):
                self.email = str(value)
            else:
                self.email = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('phone')
            if value not in (None,'null', 'none','None'):
                self.phone = str(value)
            else:
                self.phone = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isShipping')
            if value not in (None,'null', 'none','None'):
                self.isShipping = bool(value)
            else:
                self.isShipping = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isBilling')
            if value not in (None,'null', 'none','None'):
                self.isBilling = bool(value)
            else:
                self.isBilling = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isDefaultShipping')
            if value not in (None,'null', 'none','None'):
                self.isDefaultShipping = bool(value)
            else:
                self.isDefaultShipping = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isDefaultBilling')
            if value not in (None,'null', 'none','None'):
                self.isDefaultBilling = bool(value)
            else:
                self.isDefaultBilling = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(str(self.name), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.contact), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.street), [('required', True),])
        if err is not None:
            return err
        
        
        _, err = verify(str(self.city), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.state), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.zip), [('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.vendor_id), [('gt', 0),])
        if err is not None:
            return err
        err = self.addressType.valid()
        if err is not None:
            return err
        _, err = verify(str(self.email), [('email', True),])
        if err is not None:
            return err
        _, err = verify(str(self.phone), [('phone', True),])
        if err is not None:
            return err
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'name': self.name,
            'contact': self.contact,
            'street': self.street,
            'street2': self.street2,
            'street3': self.street3,
            'city': self.city,
            'state': self.state,
            'zip': self.zip,
            'vendor_id': self.vendor_id,
            'addressType': self.addressType.value,
            'email': self.email,
            'phone': self.phone,
            'isShipping': self.isShipping,
            'isBilling': self.isBilling,
            'isDefaultShipping': self.isDefaultShipping,
            'isDefaultBilling': self.isDefaultBilling,
        }

@dataclass(slots=True)
class CreateVendorAddressResp:
    '''
    '''
    # success: true, fail: false
    ok: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ok')
            if value not in (None,'null', 'none','None'):
                self.ok = bool(value)
            else:
                self.ok = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ok': self.ok,
        }

@dataclass(slots=True)
class UpdateVendorAddressReq:
    '''
    '''
    # Name
    name: str
    # Contact
    contact: str
    # Street
    street: str
    # Street 2
    street2: str
    # Street 3
    street3: str
    # City
    city: str
    # State
    state: str
    # Zip Code
    zip: str
    # VendorId
    vendor_id: int
    # AddressType
    addressType: AddressType
    # Email
    email: str
    # Phone
    phone: str
    # IsShipping
    isShipping: bool
    # IsBilling
    isBilling: bool
    # IsDefaultShipping
    isDefaultShipping: bool
    # IsDefaultBilling
    isDefaultBilling: bool
    # Address ID
    id: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('contact')
            if value not in (None,'null', 'none','None'):
                self.contact = str(value)
            else:
                self.contact = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('street')
            if value not in (None,'null', 'none','None'):
                self.street = str(value)
            else:
                self.street = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('street2')
            if value not in (None,'null', 'none','None'):
                self.street2 = str(value)
            else:
                self.street2 = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('street3')
            if value not in (None,'null', 'none','None'):
                self.street3 = str(value)
            else:
                self.street3 = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('city')
            if value not in (None,'null', 'none','None'):
                self.city = str(value)
            else:
                self.city = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('state')
            if value not in (None,'null', 'none','None'):
                self.state = str(value)
            else:
                self.state = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('zip')
            if value not in (None,'null', 'none','None'):
                self.zip = str(value)
            else:
                self.zip = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendor_id')
            if value not in (None,'null', 'none','None'):
                self.vendor_id = int(value)
            else:
                self.vendor_id = None
        except Exception as e:
            raise e
        
        self.addressType = AddressType(data.get('addressType'))
        try:
            value = data.get('email')
            if value not in (None,'null', 'none','None'):
                self.email = str(value)
            else:
                self.email = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('phone')
            if value not in (None,'null', 'none','None'):
                self.phone = str(value)
            else:
                self.phone = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isShipping')
            if value not in (None,'null', 'none','None'):
                self.isShipping = bool(value)
            else:
                self.isShipping = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isBilling')
            if value not in (None,'null', 'none','None'):
                self.isBilling = bool(value)
            else:
                self.isBilling = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isDefaultShipping')
            if value not in (None,'null', 'none','None'):
                self.isDefaultShipping = bool(value)
            else:
                self.isDefaultShipping = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isDefaultBilling')
            if value not in (None,'null', 'none','None'):
                self.isDefaultBilling = bool(value)
            else:
                self.isDefaultBilling = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(str(self.name), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.contact), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.street), [('required', True),])
        if err is not None:
            return err
        
        
        _, err = verify(str(self.city), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.state), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.zip), [('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.vendor_id), [('gt', 0),])
        if err is not None:
            return err
        err = self.addressType.valid()
        if err is not None:
            return err
        _, err = verify(str(self.email), [('email', True),])
        if err is not None:
            return err
        _, err = verify(str(self.phone), [('phone', True),])
        if err is not None:
            return err
        
        
        
        
        _, err = verify(int(self.id), [('gt', 0),('required', True),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'name': self.name,
            'contact': self.contact,
            'street': self.street,
            'street2': self.street2,
            'street3': self.street3,
            'city': self.city,
            'state': self.state,
            'zip': self.zip,
            'vendor_id': self.vendor_id,
            'addressType': self.addressType.value,
            'email': self.email,
            'phone': self.phone,
            'isShipping': self.isShipping,
            'isBilling': self.isBilling,
            'isDefaultShipping': self.isDefaultShipping,
            'isDefaultBilling': self.isDefaultBilling,
            'id': self.id,
        }

@dataclass(slots=True)
class UpdateVendorAddressResp:
    '''
    '''
    # success: true, fail: false
    ok: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ok')
            if value not in (None,'null', 'none','None'):
                self.ok = bool(value)
            else:
                self.ok = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ok': self.ok,
        }

@dataclass(slots=True)
class DeleteVendorAddressReq:
    '''
    '''
    # Address ID
    id: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.id), [('gt', 0),('required', True),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
        }

@dataclass(slots=True)
class DeleteVendorAddressResp:
    '''
    '''
    # success: true, fail: false
    ok: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ok')
            if value not in (None,'null', 'none','None'):
                self.ok = bool(value)
            else:
                self.ok = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ok': self.ok,
        }

@dataclass(slots=True)
class GetVendorAddressByIdReq:
    '''
    '''
    # Address ID
    id: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.id), [('gt', 0),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
        }

@dataclass(slots=True)
class GetVendorAddressByIdResp:
    '''
    '''
    # Name
    name: str
    # Contact
    contact: str
    # Street
    street: str
    # Street 2
    street2: str
    # Street 3
    street3: str
    # City
    city: str
    # State
    state: str
    # Zip Code
    zip: str
    # VendorId
    vendor_id: int
    # AddressType
    addressType: AddressType
    # Email
    email: str
    # Phone
    phone: str
    # IsShipping
    isShipping: bool
    # IsBilling
    isBilling: bool
    # IsDefaultShipping
    isDefaultShipping: bool
    # IsDefaultBilling
    isDefaultBilling: bool
    # Address ID
    id: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('contact')
            if value not in (None,'null', 'none','None'):
                self.contact = str(value)
            else:
                self.contact = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('street')
            if value not in (None,'null', 'none','None'):
                self.street = str(value)
            else:
                self.street = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('street2')
            if value not in (None,'null', 'none','None'):
                self.street2 = str(value)
            else:
                self.street2 = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('street3')
            if value not in (None,'null', 'none','None'):
                self.street3 = str(value)
            else:
                self.street3 = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('city')
            if value not in (None,'null', 'none','None'):
                self.city = str(value)
            else:
                self.city = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('state')
            if value not in (None,'null', 'none','None'):
                self.state = str(value)
            else:
                self.state = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('zip')
            if value not in (None,'null', 'none','None'):
                self.zip = str(value)
            else:
                self.zip = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendor_id')
            if value not in (None,'null', 'none','None'):
                self.vendor_id = int(value)
            else:
                self.vendor_id = None
        except Exception as e:
            raise e
        
        self.addressType = AddressType(data.get('addressType'))
        try:
            value = data.get('email')
            if value not in (None,'null', 'none','None'):
                self.email = str(value)
            else:
                self.email = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('phone')
            if value not in (None,'null', 'none','None'):
                self.phone = str(value)
            else:
                self.phone = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isShipping')
            if value not in (None,'null', 'none','None'):
                self.isShipping = bool(value)
            else:
                self.isShipping = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isBilling')
            if value not in (None,'null', 'none','None'):
                self.isBilling = bool(value)
            else:
                self.isBilling = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isDefaultShipping')
            if value not in (None,'null', 'none','None'):
                self.isDefaultShipping = bool(value)
            else:
                self.isDefaultShipping = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isDefaultBilling')
            if value not in (None,'null', 'none','None'):
                self.isDefaultBilling = bool(value)
            else:
                self.isDefaultBilling = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(str(self.name), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.contact), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.street), [('required', True),])
        if err is not None:
            return err
        
        
        _, err = verify(str(self.city), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.state), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.zip), [('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.vendor_id), [('gt', 0),])
        if err is not None:
            return err
        err = self.addressType.valid()
        if err is not None:
            return err
        _, err = verify(str(self.email), [('email', True),])
        if err is not None:
            return err
        _, err = verify(str(self.phone), [('phone', True),])
        if err is not None:
            return err
        
        
        
        
        _, err = verify(int(self.id), [('gt', 0),('required', True),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'name': self.name,
            'contact': self.contact,
            'street': self.street,
            'street2': self.street2,
            'street3': self.street3,
            'city': self.city,
            'state': self.state,
            'zip': self.zip,
            'vendor_id': self.vendor_id,
            'addressType': self.addressType.value,
            'email': self.email,
            'phone': self.phone,
            'isShipping': self.isShipping,
            'isBilling': self.isBilling,
            'isDefaultShipping': self.isDefaultShipping,
            'isDefaultBilling': self.isDefaultBilling,
            'id': self.id,
        }

@dataclass(slots=True)
class VendorCreditBalanceReq:
    '''
    '''
    # Vendor ID
    vendorId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('vendorId')
            if value not in (None,'null', 'none','None'):
                self.vendorId = int(value)
            else:
                self.vendorId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.vendorId), [('gt', 0),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'vendorId': self.vendorId,
        }

@dataclass(slots=True)
class VendorCreditBalanceResp:
    '''
    '''
    # Balance
    balance: str
    # As of
    asOf: str
    # Credit
    credit: str
    # Total Credit Limit
    creditLimit: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('balance')
            if value not in (None,'null', 'none','None'):
                self.balance = str(value)
            else:
                self.balance = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('asOf')
            if value not in (None,'null', 'none','None'):
                self.asOf = str(value)
            else:
                self.asOf = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('credit')
            if value not in (None,'null', 'none','None'):
                self.credit = str(value)
            else:
                self.credit = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('creditLimit')
            if value not in (None,'null', 'none','None'):
                self.creditLimit = str(value)
            else:
                self.creditLimit = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'balance': self.balance,
            'asOf': self.asOf,
            'credit': self.credit,
            'creditLimit': self.creditLimit,
        }

@dataclass(slots=True)
class SetVendorCreditBalanceReq:
    '''
    '''
    # Vendor ID
    vendorId: int
    # As of Date
    asOfDate: str
    # Amount $
    amount: str
    # Credit Limit $
    creditLimit: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('vendorId')
            if value not in (None,'null', 'none','None'):
                self.vendorId = int(value)
            else:
                self.vendorId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('asOfDate')
            if value not in (None,'null', 'none','None'):
                self.asOfDate = str(value)
            else:
                self.asOfDate = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('amount')
            if value not in (None,'null', 'none','None'):
                self.amount = str(value)
            else:
                self.amount = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('creditLimit')
            if value not in (None,'null', 'none','None'):
                self.creditLimit = str(value)
            else:
                self.creditLimit = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.vendorId), [('gt', 0),])
        if err is not None:
            return err
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'vendorId': self.vendorId,
            'asOfDate': self.asOfDate,
            'amount': self.amount,
            'creditLimit': self.creditLimit,
        }

@dataclass(slots=True)
class SetVendorCreditBalanceResp:
    '''
    '''
    # success: true, fail: false
    ok: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ok')
            if value not in (None,'null', 'none','None'):
                self.ok = bool(value)
            else:
                self.ok = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ok': self.ok,
        }

@dataclass(slots=True)
class APPO:
    '''
    '''
    # PO ID
    poId: int
    # Penalty
    penalty: str
    # Payment $
    payment: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('poId')
            if value not in (None,'null', 'none','None'):
                self.poId = int(value)
            else:
                self.poId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('penalty')
            if value not in (None,'null', 'none','None'):
                self.penalty = str(value)
            else:
                self.penalty = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('payment')
            if value not in (None,'null', 'none','None'):
                self.payment = str(value)
            else:
                self.payment = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.poId), [('gt', 0),])
        if err is not None:
            return err
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'poId': self.poId,
            'penalty': self.penalty,
            'payment': self.payment,
        }

@dataclass(slots=True)
class NewAPFromVendorReq:
    '''
    '''
    # Vendor ID
    vendorId: str
    # PO list
    poList: list[APPO]
    # Credit
    credit: str
    # Payment Date
    paymentDate: str
    # Payment Method
    paymentMethod: str
    # Payment Account
    paymentAccount: str
    # Check No.
    checkNo: str
    # Note
    note: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('vendorId')
            if value not in (None,'null', 'none','None'):
                self.vendorId = str(value)
            else:
                self.vendorId = None
        except Exception as e:
            raise e
        
        self.poList = list(map(lambda x: APPO(x), data.get('poList') if data.get('poList') else []))
        try:
            value = data.get('credit')
            if value not in (None,'null', 'none','None'):
                self.credit = str(value)
            else:
                self.credit = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('paymentDate')
            if value not in (None,'null', 'none','None'):
                self.paymentDate = str(value)
            else:
                self.paymentDate = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('paymentMethod')
            if value not in (None,'null', 'none','None'):
                self.paymentMethod = str(value)
            else:
                self.paymentMethod = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('paymentAccount')
            if value not in (None,'null', 'none','None'):
                self.paymentAccount = str(value)
            else:
                self.paymentAccount = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('checkNo')
            if value not in (None,'null', 'none','None'):
                self.checkNo = str(value)
            else:
                self.checkNo = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('note')
            if value not in (None,'null', 'none','None'):
                self.note = str(value)
            else:
                self.note = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        # TODO valid list
        
        
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'vendorId': self.vendorId,
            'poList': _dump_value(self.poList),
            'credit': self.credit,
            'paymentDate': self.paymentDate,
            'paymentMethod': self.paymentMethod,
            'paymentAccount': self.paymentAccount,
            'checkNo': self.checkNo,
            'note': self.note,
        }

@dataclass(slots=True)
class NewAPFromVendorResp:
    '''
    '''
    # success: true, fail: false
    ok: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ok')
            if value not in (None,'null', 'none','None'):
                self.ok = bool(value)
            else:
                self.ok = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ok': self.ok,
        }

@dataclass(slots=True)
class APReceiveInfo:
    '''
    '''
    # Receive ID
    receiveId: int
    # Payment $
    payment: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('receiveId')
            if value not in (None,'null', 'none','None'):
                self.receiveId = int(value)
            else:
                self.receiveId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('payment')
            if value not in (None,'null', 'none','None'):
                self.payment = str(value)
            else:
                self.payment = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.receiveId), [('gt', 0),])
        if err is not None:
            return err
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'receiveId': self.receiveId,
            'payment': self.payment,
        }

@dataclass(slots=True)
class APCreditInfo:
    '''
    '''
    # Credit ID
    creditId: int
    # UseAmount $
    useAmount: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('creditId')
            if value not in (None,'null', 'none','None'):
                self.creditId = int(value)
            else:
                self.creditId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('useAmount')
            if value not in (None,'null', 'none','None'):
                self.useAmount = str(value)
            else:
                self.useAmount = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.creditId), [('gt', 0),])
        if err is not None:
            return err
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'creditId': self.creditId,
            'useAmount': self.useAmount,
        }

@dataclass(slots=True)
class NewAPFromPOReq:
    '''
    '''
    # PO ID
    poId: int
    # Receive list
    receiveList: list[APReceiveInfo]
    # credit list
    creditList: list[APCreditInfo]
    # Paid
    paid: str
    # Penalty
    penalty: str
    # Payment Date
    postDatetime: str
    # Payment Method
    paymentMethod: PaymentMethod
    # Payment Account
    bankAccount: PaymentAccount
    # Check No.
    checkNum: str
    # Note
    note: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('poId')
            if value not in (None,'null', 'none','None'):
                self.poId = int(value)
            else:
                self.poId = None
        except Exception as e:
            raise e
        
        self.receiveList = list(map(lambda x: APReceiveInfo(x), data.get('receiveList') if data.get('receiveList') else []))
        self.creditList = list(map(lambda x: APCreditInfo(x), data.get('creditList') if data.get('creditList') else []))
        try:
            value = data.get('paid')
            if value not in (None,'null', 'none','None'):
                self.paid = str(value)
            else:
                self.paid = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('penalty')
            if value not in (None,'null', 'none','None'):
                self.penalty = str(value)
            else:
                self.penalty = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('postDatetime')
            if value not in (None,'null', 'none','None'):
                self.postDatetime = str(value)
            else:
                self.postDatetime = None
        except Exception as e:
            raise e
        
        self.paymentMethod = PaymentMethod(data.get('paymentMethod'))
        self.bankAccount = PaymentAccount(data.get('bankAccount'))
        try:
            value = data.get('checkNum')
            if value not in (None,'null', 'none','None'):
                self.checkNum = str(value)
            else:
                self.checkNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('note')
            if value not in (None,'null', 'none','None'):
                self.note = str(value)
            else:
                self.note = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.poId), [('gt', 0),])
        if err is not None:
            return err
        # TODO valid list
        # TODO valid list
        
        
        
        err = self.paymentMethod.valid()
        if err is not None:
            return err
        err = self.bankAccount.valid()
        if err is not None:
            return err
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'poId': self.poId,
            'receiveList': _dump_value(self.receiveList),
            'creditList': _dump_value(self.creditList),
            'paid': self.paid,
            'penalty': self.penalty,
            'postDatetime': self.postDatetime,
            'paymentMethod': self.paymentMethod.value,
            'bankAccount': self.bankAccount.value,
            'checkNum': self.checkNum,
            'note': self.note,
        }

@dataclass(slots=True)
class NewAPFromPOResp:
    '''
    '''
    # success: true, fail: false
    ok: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ok')
            if value not in (None,'null', 'none','None'):
                self.ok = bool(value)
            else:
                self.ok = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ok': self.ok,
        }

@dataclass(slots=True)
class APListReq:
    '''
    '''
    # CompanyId
    companyId: int
    # VendorId
    vendorId: int
    # Search keyword
    search: str
    # Size of page
    pageSize: int
    # Page number
    pageId: int
    # Sort
    sortBy: str
    # Order Date
    orderDate: TimeRange
    # Payment Date
    paymentDate: TimeRange
    # PaymentStatus
    paymentStatus: APStatus
    # Group By
    groupBy: APListGroupBy
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorId')
            if value not in (None,'null', 'none','None'):
                self.vendorId = int(value)
            else:
                self.vendorId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('search')
            if value not in (None,'null', 'none','None'):
                self.search = str(value)
            else:
                self.search = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('pageSize')
            if value not in (None,'null', 'none','None'):
                self.pageSize = int(value)
            else:
                self.pageSize = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('pageId')
            if value not in (None,'null', 'none','None'):
                self.pageId = int(value)
            else:
                self.pageId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('sortBy')
            if value not in (None,'null', 'none','None'):
                self.sortBy = str(value)
            else:
                self.sortBy = None
        except Exception as e:
            raise e
        
        self.orderDate = TimeRange(data.get('orderDate')) if data.get('orderDate') else None
        self.paymentDate = TimeRange(data.get('paymentDate')) if data.get('paymentDate') else None
        self.paymentStatus = APStatus(data.get('paymentStatus'))
        self.groupBy = APListGroupBy(data.get('groupBy'))

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.companyId), [('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.vendorId), [('required', True),])
        if err is not None:
            return err
        
        
        
        
        if False or self.orderDate is not None:
            err = self.orderDate.valid()
        else:
            err = None
        if err is not None:
            return err
        if False or self.paymentDate is not None:
            err = self.paymentDate.valid()
        else:
            err = None
        if err is not None:
            return err
        err = self.paymentStatus.valid()
        if err is not None:
            return err
        err = self.groupBy.valid()
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'companyId': self.companyId,
            'vendorId': self.vendorId,
            'search': self.search,
            'pageSize': self.pageSize,
            'pageId': self.pageId,
            'sortBy': self.sortBy,
            'orderDate': self.orderDate.dump_(),
            'paymentDate': self.paymentDate.dump_(),
            'paymentStatus': self.paymentStatus.value,
            'groupBy': self.groupBy.value,
        }

@dataclass(slots=True)
class APInfo:
    '''
    '''
    # AP ID
    id: int
    # AP No.
    paymentNum: str
    # PaymentStatus
    paymentStatus: str
    # PMT Date
    postDatetime: datetime
    # Payment $
    paymentAmount: str
    # Method
    paymentMethod: PaymentMethod
    # Vendor
    vendorId: int
    # Created
    createDatetime: datetime
    # Note
    note: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('paymentNum')
            if value not in (None,'null', 'none','None'):
                self.paymentNum = str(value)
            else:
                self.paymentNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('paymentStatus')
            if value not in (None,'null', 'none','None'):
                self.paymentStatus = str(value)
            else:
                self.paymentStatus = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('postDatetime')
            if value not in (None,'null', 'none','None'):
                self.postDatetime = datetime(value)
            else:
                self.postDatetime = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('paymentAmount')
            if value not in (None,'null', 'none','None'):
                self.paymentAmount = str(value)
            else:
                self.paymentAmount = None
        except Exception as e:
            raise e
        
        self.paymentMethod = PaymentMethod(data.get('paymentMethod'))
        try:
            value = data.get('vendorId')
            if value not in (None,'null', 'none','None'):
                self.vendorId = int(value)
            else:
                self.vendorId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('createDatetime')
            if value not in (None,'null', 'none','None'):
                self.createDatetime = datetime(value)
            else:
                self.createDatetime = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('note')
            if value not in (None,'null', 'none','None'):
                self.note = str(value)
            else:
                self.note = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        
        
        
        err = self.paymentMethod.valid()
        if err is not None:
            return err
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'paymentNum': self.paymentNum,
            'paymentStatus': self.paymentStatus,
            'postDatetime': self.postDatetime.strftime("%Y-%m-%d %H:%M:%S %Z %z"),
            'paymentAmount': self.paymentAmount,
            'paymentMethod': self.paymentMethod.value,
            'vendorId': self.vendorId,
            'createDatetime': self.createDatetime.strftime("%Y-%m-%d %H:%M:%S %Z %z"),
            'note': self.note,
        }

@dataclass(slots=True)
class APListGroup:
    '''
    '''
    # Group name
    groupName: str
    # AP list
    list: list[APInfo]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('groupName')
            if value not in (None,'null', 'none','None'):
                self.groupName = str(value)
            else:
                self.groupName = None
        except Exception as e:
            raise e
        
        self.list = list(map(lambda x: APInfo(x), data.get('list') if data.get('list') else []))

    def valid(self):
        '''check object is valid'''
        
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'groupName': self.groupName,
            'list': _dump_value(self.list),
        }

@dataclass(slots=True)
class APListResp:
    '''
    '''
    # total
    total: int
    # page
    page: int
    # page_size
    page_size: int
    # data
    data: list[APInfo]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('total')
            if value not in (None,'null', 'none','None'):
                self.total = int(value)
            else:
                self.total = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('page')
            if value not in (None,'null', 'none','None'):
                self.page = int(value)
            else:
                self.page = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('page_size')
            if value not in (None,'null', 'none','None'):
                self.page_size = int(value)
            else:
                self.page_size = None
        except Exception as e:
            raise e
        
        self.data = list(map(lambda x: APInfo(x), data.get('data') if data.get('data') else []))

    def valid(self):
        '''check object is valid'''
        
        
        
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'total': self.total,
            'page': self.page,
            'page_size': self.page_size,
            'data': _dump_value(self.data),
        }

@dataclass(slots=True)
class APAgedReportReq:
    '''
    '''
    # CompanyId
    companyId: int
    # Search keyword
    search: str
    # Date
    orderDate: str
    # Status
    status: APAgedReportStatus
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('search')
            if value not in (None,'null', 'none','None'):
                self.search = str(value)
            else:
                self.search = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('orderDate')
            if value not in (None,'null', 'none','None'):
                self.orderDate = str(value)
            else:
                self.orderDate = None
        except Exception as e:
            raise e
        
        self.status = APAgedReportStatus(data.get('status'))

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.companyId), [('required', True),])
        if err is not None:
            return err
        
        
        err = self.status.valid()
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'companyId': self.companyId,
            'search': self.search,
            'orderDate': self.orderDate,
            'status': self.status.value,
        }

@dataclass(slots=True)
class APAgedReport:
    '''
    '''
    # Vendor Name
    vendorName: str
    # Vendor No.
    vendorNo: str
    # Total $
    total: str
    # 1-30 Days
    oneToThirtyDays: str
    # 31-60 Days
    thirtyOneToSixtyDays: str
    # 61-90 Days
    sixtyOneToNinetyDays: str
    # 91+ Days
    ninetyOneDaysPlus: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('vendorName')
            if value not in (None,'null', 'none','None'):
                self.vendorName = str(value)
            else:
                self.vendorName = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorNo')
            if value not in (None,'null', 'none','None'):
                self.vendorNo = str(value)
            else:
                self.vendorNo = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('total')
            if value not in (None,'null', 'none','None'):
                self.total = str(value)
            else:
                self.total = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('oneToThirtyDays')
            if value not in (None,'null', 'none','None'):
                self.oneToThirtyDays = str(value)
            else:
                self.oneToThirtyDays = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('thirtyOneToSixtyDays')
            if value not in (None,'null', 'none','None'):
                self.thirtyOneToSixtyDays = str(value)
            else:
                self.thirtyOneToSixtyDays = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('sixtyOneToNinetyDays')
            if value not in (None,'null', 'none','None'):
                self.sixtyOneToNinetyDays = str(value)
            else:
                self.sixtyOneToNinetyDays = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('ninetyOneDaysPlus')
            if value not in (None,'null', 'none','None'):
                self.ninetyOneDaysPlus = str(value)
            else:
                self.ninetyOneDaysPlus = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'vendorName': self.vendorName,
            'vendorNo': self.vendorNo,
            'total': self.total,
            'oneToThirtyDays': self.oneToThirtyDays,
            'thirtyOneToSixtyDays': self.thirtyOneToSixtyDays,
            'sixtyOneToNinetyDays': self.sixtyOneToNinetyDays,
            'ninetyOneDaysPlus': self.ninetyOneDaysPlus,
        }

@dataclass(slots=True)
class APAgedReportResp:
    '''
    '''
    # Report List
    list: list[APAgedReport]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.list = list(map(lambda x: APAgedReport(x), data.get('list') if data.get('list') else []))

    def valid(self):
        '''check object is valid'''
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'list': _dump_value(self.list),
        }

@dataclass(slots=True)
class UnpaidPurchaseOrder:
    '''
    '''
    # Po Num
    poNum: str
    # Invoice Num
    invoiceNum: str
    # Po Final
    poFinal: str
    # Pi Finale
    piFinal: str
    # Invoice Payment
    invoicePayment: str
    # Invoice UnPayment
    invoiceUnPayment: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('poNum')
            if value not in (None,'null', 'none','None'):
                self.poNum = str(value)
            else:
                self.poNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('invoiceNum')
            if value not in (None,'null', 'none','None'):
                self.invoiceNum = str(value)
            else:
                self.invoiceNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('poFinal')
            if value not in (None,'null', 'none','None'):
                self.poFinal = str(value)
            else:
                self.poFinal = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('piFinal')
            if value not in (None,'null', 'none','None'):
                self.piFinal = str(value)
            else:
                self.piFinal = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('invoicePayment')
            if value not in (None,'null', 'none','None'):
                self.invoicePayment = str(value)
            else:
                self.invoicePayment = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('invoiceUnPayment')
            if value not in (None,'null', 'none','None'):
                self.invoiceUnPayment = str(value)
            else:
                self.invoiceUnPayment = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'poNum': self.poNum,
            'invoiceNum': self.invoiceNum,
            'poFinal': self.poFinal,
            'piFinal': self.piFinal,
            'invoicePayment': self.invoicePayment,
            'invoiceUnPayment': self.invoiceUnPayment,
        }

@dataclass(slots=True)
class UnusedCredit:
    '''
    '''
    # Credit Num
    creditNum: str
    # Credit Final
    creditFinal: str
    # Used
    usedPrice: str
    # Unused
    unUsedPrice: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('creditNum')
            if value not in (None,'null', 'none','None'):
                self.creditNum = str(value)
            else:
                self.creditNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('creditFinal')
            if value not in (None,'null', 'none','None'):
                self.creditFinal = str(value)
            else:
                self.creditFinal = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('usedPrice')
            if value not in (None,'null', 'none','None'):
                self.usedPrice = str(value)
            else:
                self.usedPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('unUsedPrice')
            if value not in (None,'null', 'none','None'):
                self.unUsedPrice = str(value)
            else:
                self.unUsedPrice = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'creditNum': self.creditNum,
            'creditFinal': self.creditFinal,
            'usedPrice': self.usedPrice,
            'unUsedPrice': self.unUsedPrice,
        }

@dataclass(slots=True)
class UnpaidPurchaseOrderReq:
    '''
    '''
    # Vendor
    vendorId: int
    # Company
    companyId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('vendorId')
            if value not in (None,'null', 'none','None'):
                self.vendorId = int(value)
            else:
                self.vendorId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.vendorId), [('required', True),('gt', 0),])
        if err is not None:
            return err
        _, err = verify(int(self.companyId), [('required', True),('gt', 0),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'vendorId': self.vendorId,
            'companyId': self.companyId,
        }

@dataclass(slots=True)
class UnpaidPoIdReq:
    '''
    '''
    # Po Id
    purchaseOrderId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('purchaseOrderId')
            if value not in (None,'null', 'none','None'):
                self.purchaseOrderId = int(value)
            else:
                self.purchaseOrderId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.purchaseOrderId), [('required', True),('gt', 0),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'purchaseOrderId': self.purchaseOrderId,
        }

@dataclass(slots=True)
class UnpaidPurchaseOrderResp:
    '''
    '''
    # Vendor No
    vendorNum: str
    # Address
    vendorAddress: str
    # Amount
    amountTotal: str
    # Credit
    creditTotal: str
    # Payment
    paymentTotal: str
    # Balance
    balanceTotal: str
    # Unpaid Po List
    poList: list[UnpaidPurchaseOrder]
    # Unused Credit
    creditList: list[UnusedCredit]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('vendorNum')
            if value not in (None,'null', 'none','None'):
                self.vendorNum = str(value)
            else:
                self.vendorNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorAddress')
            if value not in (None,'null', 'none','None'):
                self.vendorAddress = str(value)
            else:
                self.vendorAddress = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('amountTotal')
            if value not in (None,'null', 'none','None'):
                self.amountTotal = str(value)
            else:
                self.amountTotal = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('creditTotal')
            if value not in (None,'null', 'none','None'):
                self.creditTotal = str(value)
            else:
                self.creditTotal = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('paymentTotal')
            if value not in (None,'null', 'none','None'):
                self.paymentTotal = str(value)
            else:
                self.paymentTotal = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('balanceTotal')
            if value not in (None,'null', 'none','None'):
                self.balanceTotal = str(value)
            else:
                self.balanceTotal = None
        except Exception as e:
            raise e
        
        self.poList = list(map(lambda x: UnpaidPurchaseOrder(x), data.get('poList') if data.get('poList') else []))
        self.creditList = list(map(lambda x: UnusedCredit(x), data.get('creditList') if data.get('creditList') else []))

    def valid(self):
        '''check object is valid'''
        
        
        
        
        
        
        # TODO valid list
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'vendorNum': self.vendorNum,
            'vendorAddress': self.vendorAddress,
            'amountTotal': self.amountTotal,
            'creditTotal': self.creditTotal,
            'paymentTotal': self.paymentTotal,
            'balanceTotal': self.balanceTotal,
            'poList': _dump_value(self.poList),
            'creditList': _dump_value(self.creditList),
        }

@dataclass(slots=True)
class UnpaidPiData:
    '''
    '''
    # InvoiceNum
    invoiceNum: str
    # FinalPrice
    finalPrice: str
    # PaymentAmount
    paymentAmount: str
    # PostDatetime
    postDatetime: datetime
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('invoiceNum')
            if value not in (None,'null', 'none','None'):
                self.invoiceNum = str(value)
            else:
                self.invoiceNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('finalPrice')
            if value not in (None,'null', 'none','None'):
                self.finalPrice = str(value)
            else:
                self.finalPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('paymentAmount')
            if value not in (None,'null', 'none','None'):
                self.paymentAmount = str(value)
            else:
                self.paymentAmount = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('postDatetime')
            if value not in (None,'null', 'none','None'):
                self.postDatetime = datetime(value)
            else:
                self.postDatetime = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'invoiceNum': self.invoiceNum,
            'finalPrice': self.finalPrice,
            'paymentAmount': self.paymentAmount,
            'postDatetime': self.postDatetime.strftime("%Y-%m-%d %H:%M:%S %Z %z"),
        }

@dataclass(slots=True)
class UnpaidPiListResp:
    '''
    '''
    # Purchase Invoices
    invoices: list[UnpaidPiData]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.invoices = list(map(lambda x: UnpaidPiData(x), data.get('invoices') if data.get('invoices') else []))

    def valid(self):
        '''check object is valid'''
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'invoices': _dump_value(self.invoices),
        }

@dataclass(slots=True)
class CreateCreditMemoReq:
    '''
    '''
    # CompanyId
    companyId: int
    # WarehouseId
    warehouseId: int
    # Vendor ID
    vendorId: int
    # Vendor Num
    vendorNum: str
    # Total $
    total: str
    # Note
    note: str
    # OrderDate
    orderDate: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('warehouseId')
            if value not in (None,'null', 'none','None'):
                self.warehouseId = int(value)
            else:
                self.warehouseId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorId')
            if value not in (None,'null', 'none','None'):
                self.vendorId = int(value)
            else:
                self.vendorId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorNum')
            if value not in (None,'null', 'none','None'):
                self.vendorNum = str(value)
            else:
                self.vendorNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('total')
            if value not in (None,'null', 'none','None'):
                self.total = str(value)
            else:
                self.total = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('note')
            if value not in (None,'null', 'none','None'):
                self.note = str(value)
            else:
                self.note = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('orderDate')
            if value not in (None,'null', 'none','None'):
                self.orderDate = str(value)
            else:
                self.orderDate = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.companyId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.warehouseId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.vendorId), [('requied', True),('gt', 0),])
        if err is not None:
            return err
        
        _, err = verify(str(self.total), [('requied', True),])
        if err is not None:
            return err
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'companyId': self.companyId,
            'warehouseId': self.warehouseId,
            'vendorId': self.vendorId,
            'vendorNum': self.vendorNum,
            'total': self.total,
            'note': self.note,
            'orderDate': self.orderDate,
        }

@dataclass(slots=True)
class CreateCreditMemoResp:
    '''
    '''
    # success: true, fail: false
    ok: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ok')
            if value not in (None,'null', 'none','None'):
                self.ok = bool(value)
            else:
                self.ok = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ok': self.ok,
        }

@dataclass(slots=True)
class UpdateCreditMemoReq:
    '''
    '''
    # CompanyId
    companyId: int
    # WarehouseId
    warehouseId: int
    # Vendor ID
    vendorId: int
    # Vendor Num
    vendorNum: str
    # Total $
    total: str
    # Note
    note: str
    # OrderDate
    orderDate: str
    # Credit memo ID
    id: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('warehouseId')
            if value not in (None,'null', 'none','None'):
                self.warehouseId = int(value)
            else:
                self.warehouseId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorId')
            if value not in (None,'null', 'none','None'):
                self.vendorId = int(value)
            else:
                self.vendorId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorNum')
            if value not in (None,'null', 'none','None'):
                self.vendorNum = str(value)
            else:
                self.vendorNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('total')
            if value not in (None,'null', 'none','None'):
                self.total = str(value)
            else:
                self.total = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('note')
            if value not in (None,'null', 'none','None'):
                self.note = str(value)
            else:
                self.note = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('orderDate')
            if value not in (None,'null', 'none','None'):
                self.orderDate = str(value)
            else:
                self.orderDate = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.companyId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.warehouseId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.vendorId), [('requied', True),('gt', 0),])
        if err is not None:
            return err
        
        _, err = verify(str(self.total), [('requied', True),])
        if err is not None:
            return err
        
        
        _, err = verify(int(self.id), [('gt', 0),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'companyId': self.companyId,
            'warehouseId': self.warehouseId,
            'vendorId': self.vendorId,
            'vendorNum': self.vendorNum,
            'total': self.total,
            'note': self.note,
            'orderDate': self.orderDate,
            'id': self.id,
        }

@dataclass(slots=True)
class UpdateCreditMemoResp:
    '''
    '''
    # success: true, fail: false
    ok: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ok')
            if value not in (None,'null', 'none','None'):
                self.ok = bool(value)
            else:
                self.ok = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ok': self.ok,
        }

@dataclass(slots=True)
class GetCreditMemoByIdReq:
    '''
    '''
    # Credit memo ID
    id: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.id), [('gt', 0),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
        }

@dataclass(slots=True)
class GetCreditMemoByIdResp:
    '''
    '''
    # CompanyId
    companyId: int
    # WarehouseId
    warehouseId: int
    # Vendor ID
    vendorId: int
    # Vendor Num
    vendorNum: str
    # Total $
    total: str
    # Note
    note: str
    # OrderDate
    orderDate: str
    # Credit memo ID
    id: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('warehouseId')
            if value not in (None,'null', 'none','None'):
                self.warehouseId = int(value)
            else:
                self.warehouseId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorId')
            if value not in (None,'null', 'none','None'):
                self.vendorId = int(value)
            else:
                self.vendorId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorNum')
            if value not in (None,'null', 'none','None'):
                self.vendorNum = str(value)
            else:
                self.vendorNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('total')
            if value not in (None,'null', 'none','None'):
                self.total = str(value)
            else:
                self.total = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('note')
            if value not in (None,'null', 'none','None'):
                self.note = str(value)
            else:
                self.note = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('orderDate')
            if value not in (None,'null', 'none','None'):
                self.orderDate = str(value)
            else:
                self.orderDate = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.companyId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.warehouseId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.vendorId), [('requied', True),('gt', 0),])
        if err is not None:
            return err
        
        _, err = verify(str(self.total), [('requied', True),])
        if err is not None:
            return err
        
        
        _, err = verify(int(self.id), [('gt', 0),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'companyId': self.companyId,
            'warehouseId': self.warehouseId,
            'vendorId': self.vendorId,
            'vendorNum': self.vendorNum,
            'total': self.total,
            'note': self.note,
            'orderDate': self.orderDate,
            'id': self.id,
        }

@dataclass(slots=True)
class ListCreditMemosReq:
    '''
    '''
    # CompanyId
    companyId: int
    # WarehouseId
    warehouseId: int
    # PageSize
    pageSize: int
    # PageId
    pageId: int
    # search keyword
    search: str
    # Order Date
    orderDate: TimeRange
    # Status
    status: CreditMemoStatus
    # Sort By
    sortBy: ListCreditMemoSort
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('warehouseId')
            if value not in (None,'null', 'none','None'):
                self.warehouseId = int(value)
            else:
                self.warehouseId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('pageSize')
            if value not in (None,'null', 'none','None'):
                self.pageSize = int(value)
            else:
                self.pageSize = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('pageId')
            if value not in (None,'null', 'none','None'):
                self.pageId = int(value)
            else:
                self.pageId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('search')
            if value not in (None,'null', 'none','None'):
                self.search = str(value)
            else:
                self.search = None
        except Exception as e:
            raise e
        
        self.orderDate = TimeRange(data.get('orderDate')) if data.get('orderDate') else None
        self.status = CreditMemoStatus(data.get('status'))
        self.sortBy = ListCreditMemoSort(data.get('sortBy'))

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.companyId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.warehouseId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.pageSize), [('gt', 0),])
        if err is not None:
            return err
        _, err = verify(int(self.pageId), [('gt', 0),])
        if err is not None:
            return err
        
        if False or self.orderDate is not None:
            err = self.orderDate.valid()
        else:
            err = None
        if err is not None:
            return err
        err = self.status.valid()
        if err is not None:
            return err
        err = self.sortBy.valid()
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'companyId': self.companyId,
            'warehouseId': self.warehouseId,
            'pageSize': self.pageSize,
            'pageId': self.pageId,
            'search': self.search,
            'orderDate': self.orderDate.dump_(),
            'status': self.status.value,
            'sortBy': self.sortBy.value,
        }

@dataclass(slots=True)
class CreditMemoItem:
    '''
    '''
    # Credit Memo ID
    id: int
    # Credit Memo No.
    cdNum: str
    # Credit Memo Status
    creditStatus: int
    # unusedCredit $
    unusedCredit: str
    # Total $
    finalPrice: str
    # Vendor
    vendorNum: str
    # Note
    miscNote: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('cdNum')
            if value not in (None,'null', 'none','None'):
                self.cdNum = str(value)
            else:
                self.cdNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('creditStatus')
            if value not in (None,'null', 'none','None'):
                self.creditStatus = int(value)
            else:
                self.creditStatus = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('unusedCredit')
            if value not in (None,'null', 'none','None'):
                self.unusedCredit = str(value)
            else:
                self.unusedCredit = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('finalPrice')
            if value not in (None,'null', 'none','None'):
                self.finalPrice = str(value)
            else:
                self.finalPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorNum')
            if value not in (None,'null', 'none','None'):
                self.vendorNum = str(value)
            else:
                self.vendorNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('miscNote')
            if value not in (None,'null', 'none','None'):
                self.miscNote = str(value)
            else:
                self.miscNote = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'cdNum': self.cdNum,
            'creditStatus': self.creditStatus,
            'unusedCredit': self.unusedCredit,
            'finalPrice': self.finalPrice,
            'vendorNum': self.vendorNum,
            'miscNote': self.miscNote,
        }

@dataclass(slots=True)
class ListCreditMemosResp:
    '''
    '''
    # Credit Memo list
    creditMemos: list[CreditMemoItem]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.creditMemos = list(map(lambda x: CreditMemoItem(x), data.get('creditMemos') if data.get('creditMemos') else []))

    def valid(self):
        '''check object is valid'''
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'creditMemos': _dump_value(self.creditMemos),
        }

@dataclass(slots=True)
class DeleteCreditMemoReq:
    '''
    '''
    # Credit memo ID
    id: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.id), [('gt', 0),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
        }

@dataclass(slots=True)
class DeleteCreditMemoResp:
    '''
    '''
    # success: true, fail: false
    ok: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ok')
            if value not in (None,'null', 'none','None'):
                self.ok = bool(value)
            else:
                self.ok = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ok': self.ok,
        }
