# coding=utf-8
# DO NOT EDIT! This code is generated by truckxi-api.

import httpx
import json

from .proto import *

class scm_inventory(object):

    def __init__(self, appname: str, addr: str, timeout: float = 0.5, token: str = ''):
        """
        :param appname: 发起请求方的微服务的名称, 将被写入到Header中发送给被请求的服务方
        :param addr: 被请求的服务地址, 格式为 "http://{ip}:{port}", 也可以是服务域名
        :param timeout: 超时时间, float型, 单位为秒
        :param token: 认证token
        """
        self.timeout = timeout
        self.appname = appname
        self.addr = addr
        self.token = token
        self.headers = {"X-SRC-APP": appname}
        
        limits = httpx.Limits(max_keepalive_connections=20, max_connections=100, keepalive_expiry=5)  # 一些附加限制
        self.client = httpx.AsyncClient(limits=limits, base_url=addr, timeout=timeout)  # 内网服务, 超时时间为0.1秒

    async def _check_alive(self):
        """
        通过API来检测服务可用性
        
        :param client: httpx.AsyncClient实例
        :return: 服务是否可用
        """
        api = '/api/server/api_keepalive'
        resp = await self.client.get(api)
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return True
            else:
                return False
        return False

    async def get_batch_by_inventory(self, req: ListBatchReq, headerOpts: dict = {}) -> ListBatchResp:
        """
         List Batch
        """
        api = "/api/scm/inventory/batch/list"
        headers = self.headers.copy()
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.get(api, params=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def create_batch(self, req: CreateBatchReq, headerOpts: dict = {}) -> CreateBatchResp:
        """
         Create Batch
        """
        api = "/api/scm/inventory/batch/create"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def update_batch(self, req: UpdateBatchReq, headerOpts: dict = {}) -> UpdateBatchResp:
        """
         Update Batch
        """
        api = "/api/scm/inventory/batch/update"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.put(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def get_batch_info_by_id(self, req: GetBatchInfoByIdReq, headerOpts: dict = {}) -> GetBatchInfoByIdResp:
        """
         Get Batch Info
        """
        api = "/api/scm/inventory/batch/by_id"
        headers = self.headers.copy()
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.get(api, params=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def relocate_batch(self, req: RelocateBatchReq, headerOpts: dict = {}) -> RelocateBatchResp:
        """
         Relocate
        """
        api = "/api/scm/inventory/batch/relocate"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def create_measure_unit(self, req: CreateMeasureUnitReq, headerOpts: dict = {}) -> CreateMeasureUnitResp:
        """
         Create measure unit
        """
        api = "/api/scm/measure_unit/create"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def update_measure_unit(self, req: UpdateMeasureUnitReq, headerOpts: dict = {}) -> UpdateMeasureUnitResp:
        """
         Update measure unit
        """
        api = "/api/scm/measure_unit/update"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.put(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def delete_measure_unit(self, req: DeleteMeasureUnitReq, headerOpts: dict = {}) -> DeleteMeasureUnitResp:
        """
         Delete measure unit
        """
        api = "/api/scm/measure_unit/delete"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.delete(api, content=json.dumps(req.dump_()), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def get_measure_unit_list(self, req: GetMeasureUnitListReq, headerOpts: dict = {}) -> GetMeasureUnitListResp:
        """
         Get measure unit
        """
        api = "/api/scm/measure_unit/get"
        headers = self.headers.copy()
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.get(api, params=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def get_spu(self, req: GetSpuByProductIdReq, headerOpts: dict = {}) -> GetSpuByProductIdResp:
        """
         Get SPU by Product Id
        """
        api = "/api/scm/inventory/product/spu_get"
        headers = self.headers.copy()
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.get(api, params=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def update_spu(self, req: UpdateSpuReq, headerOpts: dict = {}) -> UpdateSpuResp:
        """
         Update SPU
        """
        api = "/api/scm/inventory/product/spu_update"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.put(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def create_product(self, req: CreateProductReq, headerOpts: dict = {}) -> CreateProductResp:
        """
         Create Product
        """
        api = "/api/scm/inventory/product/create"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def update_product(self, req: UpdateProductReq, headerOpts: dict = {}) -> UpdateProductResp:
        """
         Update Product
        """
        api = "/api/scm/inventory/product/update"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.put(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def auto_create_product(self, req: AutoCreateProductReq, headerOpts: dict = {}) -> AutoCreateProductResp:
        """
         Auto Create Product Center Product Map
        """
        api = "/api/scm/inventory/product/auto_create"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def delete_product(self, req: DeleteProductReq, headerOpts: dict = {}) -> DeleteProductResp:
        """
         Delete Product
        """
        api = "/api/scm/inventory/product/delete"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.delete(api, content=json.dumps(req.dump_()), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def get_product(self, req: GetProductByIdReq, headerOpts: dict = {}) -> GetProductByIdResp:
        """
         Get Product by ID
        """
        api = "/api/scm/inventory/product/get"
        headers = self.headers.copy()
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.get(api, params=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def by_spu_get_products(self, req: GetProductByIdReq, headerOpts: dict = {}) -> GetProductBySpuResp:
        """
         Get Products by Spu
        """
        api = "/api/scm/inventory/product/by_spu"
        headers = self.headers.copy()
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.get(api, params=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def get_product_list(self, req: GetProductListReq, headerOpts: dict = {}) -> GetProductListResp:
        """
         Get Product List
        """
        api = "/api/scm/inventory/product/list"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def get_vendors_by_product_id(self, req: GetVendorsByProductIdReq, headerOpts: dict = {}) -> GetVendorsByProductIdResp:
        """
         Get Vendor By Product Id
        """
        api = "/api/scm/inventory/product/get_vendors_by_product_id"
        headers = self.headers.copy()
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.get(api, params=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def put_vendors_by_product_id(self, req: UpdateVendorsByProductIdReq, headerOpts: dict = {}) -> UpdateVendorsByProductIdResp:
        """
         Put Vendor By Product Id
        """
        api = "/api/scm/inventory/product/put_vendors_by_product_id"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.put(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def get_convert(self, req: GetConvertByProductIdReq, headerOpts: dict = {}) -> GetConvertByProductIdResp:
        """
         Get Product Convert
        """
        api = "/api/scm/inventory/product/get_convert"
        headers = self.headers.copy()
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.get(api, params=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def update_convert(self, req: UpdateConvertByProductIdReq, headerOpts: dict = {}) -> UpdateConvertByProductIdResp:
        """
         Put Product Convert
        """
        api = "/api/scm/inventory/product/update_convert"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.put(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def get_app_products_by_center_products(self, req: GetProductsByVendorReq, headerOpts: dict = {}) -> GetProductsByVendorResp:
        """
         Center Products Map APP Products
        """
        api = "/api/scm/inventory/product/get_app_products_by_center_products"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def get_app_product_list_related_center_product(self, req: GetProductListRelatedCenterProductReq, headerOpts: dict = {}) -> GetProductListRelatedCenterProductResp:
        """
         Get App Product List Related Center Product
        """
        api = "/api/scm/inventory/product/get_app_product_list_related_center_product"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def connect_center_porducts_and_app_porducts(self, req: GetConnectReq, headerOpts: dict = {}) -> GetConnectResp:
        """
         Connect Center Porducts and App Porducts
        """
        api = "/api/scm/inventory/product/connect_center_porducts_and_app_porducts"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def get_center_product_by_product(self, req: GetCenterProductByProductReq, headerOpts: dict = {}) -> GetCenterProductByProductResp:
        """
         APP Product Map Center
        """
        api = "/api/scm/inventory/product/get_center_product_by_product"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def get_app_product_by_product(self, req: GetAppProductByProductReq, headerOpts: dict = {}) -> GetAppProductByProductResp:
        """
         Center Map APP Products
        """
        api = "/api/scm/inventory/product/get_app_product_by_product"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def create_category(self, req: CreateCategoryReq, headerOpts: dict = {}) -> CreateCategoryResp:
        """
         Create Category
        """
        api = "/api/scm/inventory/category/create"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def get_category(self, req: GetCategoryReq, headerOpts: dict = {}) -> GetCategoryResp:
        """
         Get Category
        """
        api = "/api/scm/inventory/category/list"
        headers = self.headers.copy()
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.get(api, params=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def update_category(self, req: UpdateCategoryReq, headerOpts: dict = {}) -> CreateCategoryResp:
        """
         Put Category
        """
        api = "/api/scm/inventory/category/update"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.put(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def delete_category(self, req: DeleteCategoryReq, headerOpts: dict = {}) -> CreateCategoryResp:
        """
         Delete Category
        """
        api = "/api/scm/inventory/category/delete"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.delete(api, content=json.dumps(req.dump_()), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def inventory_list(self, req: InventoryListReq, headerOpts: dict = {}) -> InventoryListResp:
        """
         获取库存列表
        """
        api = "/api/scm/inventory/list"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def statistics(self, req: InventoryStatisticsReq, headerOpts: dict = {}) -> InventoryStatisticsResp:
        """
         获取库存统计
        """
        api = "/api/scm/inventory/statistics"
        headers = self.headers.copy()
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.get(api, params=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def check_expired(self, req: CheckExpiredReq, headerOpts: dict = {}) -> CheckExpiredResp:
        """
         Check Expired
        """
        api = "/api/scm/inventory/check/expired"
        headers = self.headers.copy()
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.get(api, params=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def get_instock_list(self, req: GetInstockReq, headerOpts: dict = {}) -> GetInstockResp:
        """
         Get Instock List
        """
        api = "/api/scm/inventory/instock/list"
        headers = self.headers.copy()
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.get(api, params=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def get_presale_list(self, req: GetPresalesReq, headerOpts: dict = {}) -> GetPresalesResp:
        """
         Get Presale
        """
        api = "/api/scm/inventory/presale/list"
        headers = self.headers.copy()
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.get(api, params=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def update_inventory(self, req: UpdateInventoryReq, headerOpts: dict = {}) -> UpdateInventoryResp:
        """
         purchase ##########################
         增减库存分布式锁purchase
        """
        api = "/api/scm/inventory/update_inventory"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def update_purchased(self, req: UpdatePurchasedReq, headerOpts: dict = {}) -> UpdateInventoryResp:
        """
         更新purchased
        """
        api = "/api/scm/inventory/update_purchased"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def get_batch(self, req: GetBatchReq, headerOpts: dict = {}) -> GetBatchResp:
        """
         获取purchase_invoice_line对应的batch_id
        """
        api = "/api/scm/inventory/get_batch_id_for_purchase_invoice_line"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def update_inventory2(self, req: UpdateInventory2Req, headerOpts: dict = {}) -> UpdateInventory2Resp:
        """
         sales ##########################
         增减库存分布式锁sales
        """
        api = "/api/scm/inventory/update_inventory2"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        headers['Authorization'] = 'Bearer ' + self.token
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def update_presale(self, req: UpdatePresaleReq, headerOpts: dict = {}) -> UpdateInventoryResp:
        """
         更新presale
        """
        api = "/api/scm/inventory/update_presale"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}
