from __future__ import annotations
# DO NOT EDIT! This code is generated by truckxi-api.

from dataclasses import dataclass
from .verify import verify
from datetime import datetime

def _dump_value(v):
    if isinstance(v, (list, tuple)):
        return list(map(_dump_value, v))
    if isinstance(v, dict):
        return {k:_dump_value(v) for k, v in v.items()}
    if isinstance(v, Enum):
        return v.value
    if hasattr(v, 'dump_'):
        return v.dump_()
    if isinstance(v, datetime):
        return v.isoformat()
    return v

class Enum:
    def __init__(self, value):
        self.value = value
    def __str__(self):
        return str(self.value)
    def __repr__(self):
        return str(self.value)


class PricingType(Enum):
    '''
    Pricing Type
    '''
    # Test
    Test = "Test"
    # UNIT
    UNIT = "unit"
    # WEIGHT
    WEIGHT = "weight"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "Test": True,
            "unit": True,
            "weight": True,
            
        }
        if d.get(self.value) is None:
            self.value = PricingType.Test
        return None

class ProductSort(Enum):
    '''
    RequestStatus
    '''
    # Test
    Test = "Test"
    # Id asc
    IdAsc = "id"
    # Id desc
    IdDesc = "-id"
    # RefNum asc
    RefNumAsc = "refNum"
    # RefNum desc
    RefNumDesc = "-refNum"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "Test": True,
            "id": True,
            "-id": True,
            "refNum": True,
            "-refNum": True,
            
        }
        if d.get(self.value) is None:
            self.value = ProductSort.Test
        return None

class InventoryListSort(Enum):
    '''
    库存列表排序
    '''
    # IdDesc
    IdDesc = "-id"
    # In Stock ASC
    InStockAsc = "inStockPrice"
    # In Stock DESC
    InStockDesc = "-inStockPrice"
    # On hand ASC
    OnHandAsc = "onHand"
    # On hand DESC
    OnHandDesc = "-onHand"
    # Presale ASC
    Presale = "presale"
    # Presale DESC
    PresaleDesc = "-presale"
    # Purchased ASC
    PurchasedAsc = "purchased"
    # Purchased DESC
    PurchasedDesc = "-purchased"
    # Cost ASC
    CostAsc = "productCost"
    # Cost DESC
    CostDesc = "-productCost"
    # Sale $ ASC
    SaleAsc = "refPrice"
    # Sale $ DESC
    SaleDesc = "-refPrice"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "-id": True,
            "inStockPrice": True,
            "-inStockPrice": True,
            "onHand": True,
            "-onHand": True,
            "presale": True,
            "-presale": True,
            "purchased": True,
            "-purchased": True,
            "productCost": True,
            "-productCost": True,
            "refPrice": True,
            "-refPrice": True,
            
        }
        if d.get(self.value) is None:
            self.value = InventoryListSort.IdDesc
        return None

class ProductStatus(Enum):
    '''
    Product Status
    '''
    # Test
    Test = "Test"
    # Active
    Active = "Active"
    # Stop Sale
    StopSales = "StopSale"
    # Stop Purchase
    StopPurchase = "StopPurchase"
    # Inactive
    Inactive = "Inactive"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "Test": True,
            "Active": True,
            "StopSale": True,
            "StopPurchase": True,
            "Inactive": True,
            
        }
        if d.get(self.value) is None:
            self.value = ProductStatus.Test
        return None

class StockLevel(Enum):
    '''
    StockLevel
    '''
    # Test
    Test = "Test"
    # Safety Stock
    SafetyStock = "SafetyStock"
    # Out of Stock
    OutOfStock = "OutOfStock"
    # Low Stock
    LowStock = "LowStock"
    # Over Stock
    OverStock = "OverStock"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "Test": True,
            "SafetyStock": True,
            "OutOfStock": True,
            "LowStock": True,
            "OverStock": True,
            
        }
        if d.get(self.value) is None:
            self.value = StockLevel.Test
        return None

class InventoryListGroupBy(Enum):
    '''
    Inventory List Group By
    '''
    # Test
    Test = "Test"
    # SPU
    SPU = "spu"
    # Vendor
    Vendor = "vendor"
    # Stock level
    StockLevel = "stockLevel"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "Test": True,
            "spu": True,
            "vendor": True,
            "stockLevel": True,
            
        }
        if d.get(self.value) is None:
            self.value = InventoryListGroupBy.Test
        return None

class MethodStatus(Enum):
    '''
    Increase or Reduce
    '''
    # Increase
    Increase = "Increase"
    # Reduce
    Reduce = "Reduce"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "Increase": True,
            "Reduce": True,
            
        }
        if d.get(self.value) is None:
            self.value = MethodStatus.Reduce
        return None

class RequestStatus(Enum):
    '''
    RequestStatus
    '''
    # Create
    Create = "Create"
    # Update
    Update = "Update"
    # Void
    Void = "Void"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "Create": True,
            "Update": True,
            "Void": True,
            
        }
        if d.get(self.value) is None:
            self.value = RequestStatus.Create
        return None

class ModuleStatus(Enum):
    '''
    ModuleStatus
    '''
    # 销售发票
    SalesInvoice = "Sales Invoice"
    # 销售退货
    SalesReturn = "Sales Return"
    # 销售退货加回库存
    RESTOCK = "Restock"
    # 采购收货
    WarehouseReceive = "Warehouse Receive"
    # 采购退货
    PurchaseReturn = "Purchase Return"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "Sales Invoice": True,
            "Sales Return": True,
            "Restock": True,
            "Warehouse Receive": True,
            "Purchase Return": True,
            
        }
        if d.get(self.value) is None:
            self.value = ModuleStatus.WarehouseReceive
        return None

@dataclass(slots=True)
class Ok:
    '''
    '''
    # success: true, fail: false
    ok: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ok')
            if value not in (None,'null', 'none','None'):
                self.ok = bool(value)
            else:
                self.ok = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ok': self.ok,
        }

@dataclass(slots=True)
class CreateBatchReq:
    '''
    '''
    # Inventory ID
    inventoryId: int
    # Qty
    quantity: int
    # Unit $
    unitPrice: str
    # Arrival Cost
    arrivalCost: str
    # Expire Date
    expireDate: str
    # Pack Date
    packDate: str
    # Note
    note: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('inventoryId')
            if value not in (None,'null', 'none','None'):
                self.inventoryId = int(value)
            else:
                self.inventoryId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('quantity')
            if value not in (None,'null', 'none','None'):
                self.quantity = int(value)
            else:
                self.quantity = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('unitPrice')
            if value not in (None,'null', 'none','None'):
                self.unitPrice = str(value)
            else:
                self.unitPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('arrivalCost')
            if value not in (None,'null', 'none','None'):
                self.arrivalCost = str(value)
            else:
                self.arrivalCost = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('expireDate')
            if value not in (None,'null', 'none','None'):
                self.expireDate = str(value)
            else:
                self.expireDate = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packDate')
            if value not in (None,'null', 'none','None'):
                self.packDate = str(value)
            else:
                self.packDate = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('note')
            if value not in (None,'null', 'none','None'):
                self.note = str(value)
            else:
                self.note = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.inventoryId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.quantity), [('required', True),])
        if err is not None:
            return err
        
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'inventoryId': self.inventoryId,
            'quantity': self.quantity,
            'unitPrice': self.unitPrice,
            'arrivalCost': self.arrivalCost,
            'expireDate': self.expireDate,
            'packDate': self.packDate,
            'note': self.note,
        }

@dataclass(slots=True)
class CreateBatchResp:
    '''
    '''
    # Batch ID
    batchId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('batchId')
            if value not in (None,'null', 'none','None'):
                self.batchId = int(value)
            else:
                self.batchId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'batchId': self.batchId,
        }

@dataclass(slots=True)
class UpdateBatchReq:
    '''
    '''
    # Inventory ID
    inventoryId: int
    # Qty
    quantity: int
    # Unit $
    unitPrice: str
    # Arrival Cost
    arrivalCost: str
    # Expire Date
    expireDate: str
    # Pack Date
    packDate: str
    # Note
    note: str
    # Batch ID
    batchId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('inventoryId')
            if value not in (None,'null', 'none','None'):
                self.inventoryId = int(value)
            else:
                self.inventoryId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('quantity')
            if value not in (None,'null', 'none','None'):
                self.quantity = int(value)
            else:
                self.quantity = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('unitPrice')
            if value not in (None,'null', 'none','None'):
                self.unitPrice = str(value)
            else:
                self.unitPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('arrivalCost')
            if value not in (None,'null', 'none','None'):
                self.arrivalCost = str(value)
            else:
                self.arrivalCost = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('expireDate')
            if value not in (None,'null', 'none','None'):
                self.expireDate = str(value)
            else:
                self.expireDate = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packDate')
            if value not in (None,'null', 'none','None'):
                self.packDate = str(value)
            else:
                self.packDate = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('note')
            if value not in (None,'null', 'none','None'):
                self.note = str(value)
            else:
                self.note = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('batchId')
            if value not in (None,'null', 'none','None'):
                self.batchId = int(value)
            else:
                self.batchId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.inventoryId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.quantity), [('required', True),])
        if err is not None:
            return err
        
        
        
        
        
        _, err = verify(int(self.batchId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'inventoryId': self.inventoryId,
            'quantity': self.quantity,
            'unitPrice': self.unitPrice,
            'arrivalCost': self.arrivalCost,
            'expireDate': self.expireDate,
            'packDate': self.packDate,
            'note': self.note,
            'batchId': self.batchId,
        }

@dataclass(slots=True)
class ListBatchReq:
    '''
    '''
    # Inventory ID
    inventoryId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('inventoryId')
            if value not in (None,'null', 'none','None'):
                self.inventoryId = int(value)
            else:
                self.inventoryId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.inventoryId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'inventoryId': self.inventoryId,
        }

@dataclass(slots=True)
class UpdateBatchResp:
    '''
    '''
    # Batch ID
    batchId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('batchId')
            if value not in (None,'null', 'none','None'):
                self.batchId = int(value)
            else:
                self.batchId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'batchId': self.batchId,
        }

@dataclass(slots=True)
class BatchInfo:
    '''
    '''
    # Inventory ID
    inventoryId: int
    # Qty
    quantity: int
    # Unit $
    unitPrice: str
    # Arrival Cost
    arrivalCost: str
    # Expire Date
    expireDate: datetime
    # Pack Date
    packDate: datetime
    # Note
    note: str
    # Batch ID
    batchId: int
    # Id
    id: int
    # Batch No.
    batchNum: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('inventoryId')
            if value not in (None,'null', 'none','None'):
                self.inventoryId = int(value)
            else:
                self.inventoryId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('quantity')
            if value not in (None,'null', 'none','None'):
                self.quantity = int(value)
            else:
                self.quantity = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('unitPrice')
            if value not in (None,'null', 'none','None'):
                self.unitPrice = str(value)
            else:
                self.unitPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('arrivalCost')
            if value not in (None,'null', 'none','None'):
                self.arrivalCost = str(value)
            else:
                self.arrivalCost = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('expireDate')
            if value not in (None,'null', 'none','None'):
                self.expireDate = datetime(value)
            else:
                self.expireDate = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packDate')
            if value not in (None,'null', 'none','None'):
                self.packDate = datetime(value)
            else:
                self.packDate = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('note')
            if value not in (None,'null', 'none','None'):
                self.note = str(value)
            else:
                self.note = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('batchId')
            if value not in (None,'null', 'none','None'):
                self.batchId = int(value)
            else:
                self.batchId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('batchNum')
            if value not in (None,'null', 'none','None'):
                self.batchNum = str(value)
            else:
                self.batchNum = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.inventoryId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.quantity), [('required', True),])
        if err is not None:
            return err
        
        
        
        
        
        _, err = verify(int(self.batchId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'inventoryId': self.inventoryId,
            'quantity': self.quantity,
            'unitPrice': self.unitPrice,
            'arrivalCost': self.arrivalCost,
            'expireDate': self.expireDate.strftime("%Y-%m-%d %H:%M:%S %Z %z"),
            'packDate': self.packDate.strftime("%Y-%m-%d %H:%M:%S %Z %z"),
            'note': self.note,
            'batchId': self.batchId,
            'id': self.id,
            'batchNum': self.batchNum,
        }

@dataclass(slots=True)
class ListBatchResp:
    '''
    '''
    # List
    list: list[BatchInfo]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.list = list(map(lambda x: BatchInfo(x), data.get('list') if data.get('list') else []))

    def valid(self):
        '''check object is valid'''
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'list': _dump_value(self.list),
        }

@dataclass(slots=True)
class GetBatchInfoByIdReq:
    '''
    '''
    # Batch ID
    batchId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('batchId')
            if value not in (None,'null', 'none','None'):
                self.batchId = int(value)
            else:
                self.batchId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'batchId': self.batchId,
        }

@dataclass(slots=True)
class GetBatchInfoByIdResp:
    '''
    '''
    # Inventory ID
    inventoryId: int
    # Qty
    quantity: int
    # Unit $
    unitPrice: str
    # Arrival Cost
    arrivalCost: str
    # Expire Date
    expireDate: datetime
    # Pack Date
    packDate: datetime
    # Note
    note: str
    # Batch ID
    batchId: int
    # Id
    id: int
    # Batch No.
    batchNum: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('inventoryId')
            if value not in (None,'null', 'none','None'):
                self.inventoryId = int(value)
            else:
                self.inventoryId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('quantity')
            if value not in (None,'null', 'none','None'):
                self.quantity = int(value)
            else:
                self.quantity = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('unitPrice')
            if value not in (None,'null', 'none','None'):
                self.unitPrice = str(value)
            else:
                self.unitPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('arrivalCost')
            if value not in (None,'null', 'none','None'):
                self.arrivalCost = str(value)
            else:
                self.arrivalCost = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('expireDate')
            if value not in (None,'null', 'none','None'):
                self.expireDate = datetime(value)
            else:
                self.expireDate = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packDate')
            if value not in (None,'null', 'none','None'):
                self.packDate = datetime(value)
            else:
                self.packDate = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('note')
            if value not in (None,'null', 'none','None'):
                self.note = str(value)
            else:
                self.note = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('batchId')
            if value not in (None,'null', 'none','None'):
                self.batchId = int(value)
            else:
                self.batchId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('batchNum')
            if value not in (None,'null', 'none','None'):
                self.batchNum = str(value)
            else:
                self.batchNum = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.inventoryId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.quantity), [('required', True),])
        if err is not None:
            return err
        
        
        
        
        
        _, err = verify(int(self.batchId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'inventoryId': self.inventoryId,
            'quantity': self.quantity,
            'unitPrice': self.unitPrice,
            'arrivalCost': self.arrivalCost,
            'expireDate': self.expireDate.strftime("%Y-%m-%d %H:%M:%S %Z %z"),
            'packDate': self.packDate.strftime("%Y-%m-%d %H:%M:%S %Z %z"),
            'note': self.note,
            'batchId': self.batchId,
            'id': self.id,
            'batchNum': self.batchNum,
        }

@dataclass(slots=True)
class RelocateBatchReq:
    '''
    '''
    # Batch ID
    batchId: int
    # To Warehouse ID
    toWarehouseId: int
    # Qty
    qty: int
    # Weight
    weight: str
    # Convert To
    convertTo: str
    # Pack Date
    packDate: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('batchId')
            if value not in (None,'null', 'none','None'):
                self.batchId = int(value)
            else:
                self.batchId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('toWarehouseId')
            if value not in (None,'null', 'none','None'):
                self.toWarehouseId = int(value)
            else:
                self.toWarehouseId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('qty')
            if value not in (None,'null', 'none','None'):
                self.qty = int(value)
            else:
                self.qty = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('weight')
            if value not in (None,'null', 'none','None'):
                self.weight = str(value)
            else:
                self.weight = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('convertTo')
            if value not in (None,'null', 'none','None'):
                self.convertTo = str(value)
            else:
                self.convertTo = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packDate')
            if value not in (None,'null', 'none','None'):
                self.packDate = str(value)
            else:
                self.packDate = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'batchId': self.batchId,
            'toWarehouseId': self.toWarehouseId,
            'qty': self.qty,
            'weight': self.weight,
            'convertTo': self.convertTo,
            'packDate': self.packDate,
        }

@dataclass(slots=True)
class RelocateBatchResp:
    '''
    '''
    # success: true, fail: false
    ok: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ok')
            if value not in (None,'null', 'none','None'):
                self.ok = bool(value)
            else:
                self.ok = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ok': self.ok,
        }

@dataclass(slots=True)
class CreateMeasureUnitReq:
    '''
    '''
    # Name
    name: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'name': self.name,
        }

@dataclass(slots=True)
class CreateMeasureUnitResp:
    '''
    '''
    # success: true, fail: false
    ok: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ok')
            if value not in (None,'null', 'none','None'):
                self.ok = bool(value)
            else:
                self.ok = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ok': self.ok,
        }

@dataclass(slots=True)
class UpdateMeasureUnitReq:
    '''
    '''
    # Name
    name: str
    # ID
    id: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        _, err = verify(int(self.id), [('gt', 0),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'name': self.name,
            'id': self.id,
        }

@dataclass(slots=True)
class UpdateMeasureUnitResp:
    '''
    '''
    # success: true, fail: false
    ok: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ok')
            if value not in (None,'null', 'none','None'):
                self.ok = bool(value)
            else:
                self.ok = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ok': self.ok,
        }

@dataclass(slots=True)
class DeleteMeasureUnitReq:
    '''
    '''
    # ID
    id: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.id), [('gt', 0),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
        }

@dataclass(slots=True)
class DeleteMeasureUnitResp:
    '''
    '''
    # success: true, fail: false
    ok: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ok')
            if value not in (None,'null', 'none','None'):
                self.ok = bool(value)
            else:
                self.ok = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ok': self.ok,
        }

@dataclass(slots=True)
class GetMeasureUnitListReq:
    '''
    '''
    
    def __init__(self, data: dict):
        if data == None:
            return None

    def valid(self):
        '''check object is valid'''
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
        }

@dataclass(slots=True)
class GetMeasureUnitListResp:
    '''
    '''
    # Measure units
    list: list[UpdateMeasureUnitReq]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.list = list(map(lambda x: UpdateMeasureUnitReq(x), data.get('list') if data.get('list') else []))

    def valid(self):
        '''check object is valid'''
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'list': _dump_value(self.list),
        }

@dataclass(slots=True)
class ProductBasicInfo:
    '''
    '''
    # CompanyId
    companyId: int
    # Product Name
    name: str
    # SPU Number
    spu: str
    # Category
    categoryId: str
    # Brand
    brand: str
    # Origin
    origin: str
    # Images
    images: list[str]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('spu')
            if value not in (None,'null', 'none','None'):
                self.spu = str(value)
            else:
                self.spu = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('categoryId')
            if value not in (None,'null', 'none','None'):
                self.categoryId = str(value)
            else:
                self.categoryId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('brand')
            if value not in (None,'null', 'none','None'):
                self.brand = str(value)
            else:
                self.brand = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('origin')
            if value not in (None,'null', 'none','None'):
                self.origin = str(value)
            else:
                self.origin = None
        except Exception as e:
            raise e
        
        self.images = list(map(lambda x: str(x), data.get('images') if data.get('images') else []))

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.companyId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.name), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.spu), [('required', True),])
        if err is not None:
            return err
        
        
        
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'companyId': self.companyId,
            'name': self.name,
            'spu': self.spu,
            'categoryId': self.categoryId,
            'brand': self.brand,
            'origin': self.origin,
            'images': _dump_value(self.images),
        }

@dataclass(slots=True)
class ProductPackageAndPrice:
    '''
    '''
    # Description
    description: str
    # Package Type
    packageType: str
    # Measure Unit
    measureUnit: str
    # Net WT
    netWeight: float
    # Ship WT
    shippingWeight: float
    # Specification
    specification: list[str]
    # Dimension
    dimension: list[str]
    # Dimension Unit
    dimensionUnit: str
    # ProductType
    productType: PricingType
    # Image
    thumbnail: list[str]
    # Color
    color: str
    # Shelf Life (Days)
    shelfLife: int
    # Buffer (Days)
    buffer: int
    # Daily Sales
    dailySales: int
    # RefPrice
    refPrice: float
    # LowestSalePrice
    lowestSalePrice: float
    # InStockPrice
    inStockPrice: float
    # Stop Sale
    isStopSale: bool
    # Over Sellable
    isOverSaleable: bool
    # Stop Purchased
    isStopPurchase: bool
    # Taxable
    isTaxable: bool
    # IsMobile
    isMobile: bool
    # Inventory Stock Range (Min-Max)
    inventoryStockMin: int
    # Inventory Stock Range (Min-Max)
    inventoryStockMax: int
    # Apply To Sales
    applyToSales: bool
    # Apply To Purchase
    applyToPurchase: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('description')
            if value not in (None,'null', 'none','None'):
                self.description = str(value)
            else:
                self.description = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packageType')
            if value not in (None,'null', 'none','None'):
                self.packageType = str(value)
            else:
                self.packageType = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('measureUnit')
            if value not in (None,'null', 'none','None'):
                self.measureUnit = str(value)
            else:
                self.measureUnit = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('netWeight')
            if value not in (None,'null', 'none','None'):
                self.netWeight = float(value)
            else:
                self.netWeight = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('shippingWeight')
            if value not in (None,'null', 'none','None'):
                self.shippingWeight = float(value)
            else:
                self.shippingWeight = None
        except Exception as e:
            raise e
        
        self.specification = list(map(lambda x: str(x), data.get('specification') if data.get('specification') else []))
        self.dimension = list(map(lambda x: str(x), data.get('dimension') if data.get('dimension') else []))
        try:
            value = data.get('dimensionUnit')
            if value not in (None,'null', 'none','None'):
                self.dimensionUnit = str(value)
            else:
                self.dimensionUnit = None
        except Exception as e:
            raise e
        
        self.productType = PricingType(data.get('productType'))
        self.thumbnail = list(map(lambda x: str(x), data.get('thumbnail') if data.get('thumbnail') else []))
        try:
            value = data.get('color')
            if value not in (None,'null', 'none','None'):
                self.color = str(value)
            else:
                self.color = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('shelfLife')
            if value not in (None,'null', 'none','None'):
                self.shelfLife = int(value)
            else:
                self.shelfLife = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('buffer')
            if value not in (None,'null', 'none','None'):
                self.buffer = int(value)
            else:
                self.buffer = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('dailySales')
            if value not in (None,'null', 'none','None'):
                self.dailySales = int(value)
            else:
                self.dailySales = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('refPrice')
            if value not in (None,'null', 'none','None'):
                self.refPrice = float(value)
            else:
                self.refPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('lowestSalePrice')
            if value not in (None,'null', 'none','None'):
                self.lowestSalePrice = float(value)
            else:
                self.lowestSalePrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('inStockPrice')
            if value not in (None,'null', 'none','None'):
                self.inStockPrice = float(value)
            else:
                self.inStockPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isStopSale')
            if value not in (None,'null', 'none','None'):
                self.isStopSale = bool(value)
            else:
                self.isStopSale = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isOverSaleable')
            if value not in (None,'null', 'none','None'):
                self.isOverSaleable = bool(value)
            else:
                self.isOverSaleable = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isStopPurchase')
            if value not in (None,'null', 'none','None'):
                self.isStopPurchase = bool(value)
            else:
                self.isStopPurchase = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isTaxable')
            if value not in (None,'null', 'none','None'):
                self.isTaxable = bool(value)
            else:
                self.isTaxable = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isMobile')
            if value not in (None,'null', 'none','None'):
                self.isMobile = bool(value)
            else:
                self.isMobile = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('inventoryStockMin')
            if value not in (None,'null', 'none','None'):
                self.inventoryStockMin = int(value)
            else:
                self.inventoryStockMin = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('inventoryStockMax')
            if value not in (None,'null', 'none','None'):
                self.inventoryStockMax = int(value)
            else:
                self.inventoryStockMax = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('applyToSales')
            if value not in (None,'null', 'none','None'):
                self.applyToSales = bool(value)
            else:
                self.applyToSales = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('applyToPurchase')
            if value not in (None,'null', 'none','None'):
                self.applyToPurchase = bool(value)
            else:
                self.applyToPurchase = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        _, err = verify(str(self.packageType), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.measureUnit), [('required', True),])
        if err is not None:
            return err
        
        
        # TODO valid list
        # TODO valid list
        
        err = self.productType.valid()
        if err is not None:
            return err
        # TODO valid list
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'description': self.description,
            'packageType': self.packageType,
            'measureUnit': self.measureUnit,
            'netWeight': self.netWeight,
            'shippingWeight': self.shippingWeight,
            'specification': _dump_value(self.specification),
            'dimension': _dump_value(self.dimension),
            'dimensionUnit': self.dimensionUnit,
            'productType': self.productType.value,
            'thumbnail': _dump_value(self.thumbnail),
            'color': self.color,
            'shelfLife': self.shelfLife,
            'buffer': self.buffer,
            'dailySales': self.dailySales,
            'refPrice': self.refPrice,
            'lowestSalePrice': self.lowestSalePrice,
            'inStockPrice': self.inStockPrice,
            'isStopSale': self.isStopSale,
            'isOverSaleable': self.isOverSaleable,
            'isStopPurchase': self.isStopPurchase,
            'isTaxable': self.isTaxable,
            'isMobile': self.isMobile,
            'inventoryStockMin': self.inventoryStockMin,
            'inventoryStockMax': self.inventoryStockMax,
            'applyToSales': self.applyToSales,
            'applyToPurchase': self.applyToPurchase,
        }

@dataclass(slots=True)
class ProductVendor:
    '''
    '''
    # Vendor ID
    vendorId: int
    # centerProductId
    centerId: int
    # Vendor Barcode
    barcode: str
    # Vendor SKU
    vendorSku: int
    # AscriptionCompanyId
    ascriptionCompanyId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('vendorId')
            if value not in (None,'null', 'none','None'):
                self.vendorId = int(value)
            else:
                self.vendorId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('centerId')
            if value not in (None,'null', 'none','None'):
                self.centerId = int(value)
            else:
                self.centerId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('barcode')
            if value not in (None,'null', 'none','None'):
                self.barcode = str(value)
            else:
                self.barcode = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorSku')
            if value not in (None,'null', 'none','None'):
                self.vendorSku = int(value)
            else:
                self.vendorSku = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('ascriptionCompanyId')
            if value not in (None,'null', 'none','None'):
                self.ascriptionCompanyId = int(value)
            else:
                self.ascriptionCompanyId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'vendorId': self.vendorId,
            'centerId': self.centerId,
            'barcode': self.barcode,
            'vendorSku': self.vendorSku,
            'ascriptionCompanyId': self.ascriptionCompanyId,
        }

@dataclass(slots=True)
class ProductConvert:
    '''
    '''
    # From SKU
    fromSKU: str
    # To SKU
    toSKU: str
    # Convert Num
    convertNum: int
    # Auto Convert
    autoConvert: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('fromSKU')
            if value not in (None,'null', 'none','None'):
                self.fromSKU = str(value)
            else:
                self.fromSKU = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('toSKU')
            if value not in (None,'null', 'none','None'):
                self.toSKU = str(value)
            else:
                self.toSKU = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('convertNum')
            if value not in (None,'null', 'none','None'):
                self.convertNum = int(value)
            else:
                self.convertNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('autoConvert')
            if value not in (None,'null', 'none','None'):
                self.autoConvert = bool(value)
            else:
                self.autoConvert = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'fromSKU': self.fromSKU,
            'toSKU': self.toSKU,
            'convertNum': self.convertNum,
            'autoConvert': self.autoConvert,
        }

@dataclass(slots=True)
class CreateProductReq:
    '''
    '''
    # Basic Info
    basicInfo: ProductBasicInfo
    # ProductPackages
    productPackages: list[ProductPackageAndPrice]
    # Vendors
    vendors: list[ProductVendor]
    # Convert
    converts: list[ProductConvert]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.basicInfo = ProductBasicInfo(data.get('basicInfo')) if data.get('basicInfo') else None
        self.productPackages = list(map(lambda x: ProductPackageAndPrice(x), data.get('productPackages') if data.get('productPackages') else []))
        self.vendors = list(map(lambda x: ProductVendor(x), data.get('vendors') if data.get('vendors') else []))
        self.converts = list(map(lambda x: ProductConvert(x), data.get('converts') if data.get('converts') else []))

    def valid(self):
        '''check object is valid'''
        if False or self.basicInfo is not None:
            err = self.basicInfo.valid()
        else:
            err = None
        if err is not None:
            return err
        # TODO valid list
        # TODO valid list
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'basicInfo': self.basicInfo.dump_(),
            'productPackages': _dump_value(self.productPackages),
            'vendors': _dump_value(self.vendors),
            'converts': _dump_value(self.converts),
        }

@dataclass(slots=True)
class AutoCreateProductReq:
    '''
    '''
    # CompanyId
    companyId: int
    # CenterProductId
    centerProductId: int
    # VendorId
    vendorId: int
    # Product Name
    name: str
    # SPU Number
    spu: str
    # SpuName
    spuName: str
    # Description
    description: str
    # NetWeight
    netWeight: float
    # RefNum
    refNum: str
    # ProductNum
    productNum: str
    # ProductType
    packageSize: str
    # PackageType
    packageType: str
    # ProductType
    productType: str
    # Thumbnail
    thumbnail: str
    # Specification
    specification: str
    # Dimension 
    dimension: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('centerProductId')
            if value not in (None,'null', 'none','None'):
                self.centerProductId = int(value)
            else:
                self.centerProductId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorId')
            if value not in (None,'null', 'none','None'):
                self.vendorId = int(value)
            else:
                self.vendorId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('spu')
            if value not in (None,'null', 'none','None'):
                self.spu = str(value)
            else:
                self.spu = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('spuName')
            if value not in (None,'null', 'none','None'):
                self.spuName = str(value)
            else:
                self.spuName = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('description')
            if value not in (None,'null', 'none','None'):
                self.description = str(value)
            else:
                self.description = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('netWeight')
            if value not in (None,'null', 'none','None'):
                self.netWeight = float(value)
            else:
                self.netWeight = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('refNum')
            if value not in (None,'null', 'none','None'):
                self.refNum = str(value)
            else:
                self.refNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productNum')
            if value not in (None,'null', 'none','None'):
                self.productNum = str(value)
            else:
                self.productNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packageSize')
            if value not in (None,'null', 'none','None'):
                self.packageSize = str(value)
            else:
                self.packageSize = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packageType')
            if value not in (None,'null', 'none','None'):
                self.packageType = str(value)
            else:
                self.packageType = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productType')
            if value not in (None,'null', 'none','None'):
                self.productType = str(value)
            else:
                self.productType = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('thumbnail')
            if value not in (None,'null', 'none','None'):
                self.thumbnail = str(value)
            else:
                self.thumbnail = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('specification')
            if value not in (None,'null', 'none','None'):
                self.specification = str(value)
            else:
                self.specification = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('dimension')
            if value not in (None,'null', 'none','None'):
                self.dimension = str(value)
            else:
                self.dimension = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.companyId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.centerProductId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.vendorId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.name), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.spu), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.spuName), [('required', True),])
        if err is not None:
            return err
        
        
        _, err = verify(str(self.refNum), [('required', True),])
        if err is not None:
            return err
        
        
        
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'companyId': self.companyId,
            'centerProductId': self.centerProductId,
            'vendorId': self.vendorId,
            'name': self.name,
            'spu': self.spu,
            'spuName': self.spuName,
            'description': self.description,
            'netWeight': self.netWeight,
            'refNum': self.refNum,
            'productNum': self.productNum,
            'packageSize': self.packageSize,
            'packageType': self.packageType,
            'productType': self.productType,
            'thumbnail': self.thumbnail,
            'specification': self.specification,
            'dimension': self.dimension,
        }

@dataclass(slots=True)
class AutoCreateProductResp:
    '''
    '''
    # ProductId
    productId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('productId')
            if value not in (None,'null', 'none','None'):
                self.productId = int(value)
            else:
                self.productId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'productId': self.productId,
        }

@dataclass(slots=True)
class CreateProductResp:
    '''
    '''
    # success: true, fail: false
    ok: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ok')
            if value not in (None,'null', 'none','None'):
                self.ok = bool(value)
            else:
                self.ok = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ok': self.ok,
        }

@dataclass(slots=True)
class UpdateProductReq:
    '''
    '''
    # Description
    description: str
    # Package Type
    packageType: str
    # Measure Unit
    measureUnit: str
    # Net WT
    netWeight: float
    # Ship WT
    shippingWeight: float
    # Specification
    specification: list[str]
    # Dimension
    dimension: list[str]
    # Dimension Unit
    dimensionUnit: str
    # ProductType
    productType: PricingType
    # Image
    thumbnail: list[str]
    # Color
    color: str
    # Shelf Life (Days)
    shelfLife: int
    # Buffer (Days)
    buffer: int
    # Daily Sales
    dailySales: int
    # RefPrice
    refPrice: float
    # LowestSalePrice
    lowestSalePrice: float
    # InStockPrice
    inStockPrice: float
    # Stop Sale
    isStopSale: bool
    # Over Sellable
    isOverSaleable: bool
    # Stop Purchased
    isStopPurchase: bool
    # Taxable
    isTaxable: bool
    # IsMobile
    isMobile: bool
    # Inventory Stock Range (Min-Max)
    inventoryStockMin: int
    # Inventory Stock Range (Min-Max)
    inventoryStockMax: int
    # Apply To Sales
    applyToSales: bool
    # Apply To Purchase
    applyToPurchase: bool
    # Product ID
    productId: int
    # WarehouseId
    warehouseId: int
    # CompanyId
    companyId: int
    # Sku
    sku: str
    # ProductCost
    productCost: str
    # ArrivalPrice
    arrivalPrice: str
    # ProductName
    name: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('description')
            if value not in (None,'null', 'none','None'):
                self.description = str(value)
            else:
                self.description = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packageType')
            if value not in (None,'null', 'none','None'):
                self.packageType = str(value)
            else:
                self.packageType = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('measureUnit')
            if value not in (None,'null', 'none','None'):
                self.measureUnit = str(value)
            else:
                self.measureUnit = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('netWeight')
            if value not in (None,'null', 'none','None'):
                self.netWeight = float(value)
            else:
                self.netWeight = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('shippingWeight')
            if value not in (None,'null', 'none','None'):
                self.shippingWeight = float(value)
            else:
                self.shippingWeight = None
        except Exception as e:
            raise e
        
        self.specification = list(map(lambda x: str(x), data.get('specification') if data.get('specification') else []))
        self.dimension = list(map(lambda x: str(x), data.get('dimension') if data.get('dimension') else []))
        try:
            value = data.get('dimensionUnit')
            if value not in (None,'null', 'none','None'):
                self.dimensionUnit = str(value)
            else:
                self.dimensionUnit = None
        except Exception as e:
            raise e
        
        self.productType = PricingType(data.get('productType'))
        self.thumbnail = list(map(lambda x: str(x), data.get('thumbnail') if data.get('thumbnail') else []))
        try:
            value = data.get('color')
            if value not in (None,'null', 'none','None'):
                self.color = str(value)
            else:
                self.color = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('shelfLife')
            if value not in (None,'null', 'none','None'):
                self.shelfLife = int(value)
            else:
                self.shelfLife = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('buffer')
            if value not in (None,'null', 'none','None'):
                self.buffer = int(value)
            else:
                self.buffer = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('dailySales')
            if value not in (None,'null', 'none','None'):
                self.dailySales = int(value)
            else:
                self.dailySales = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('refPrice')
            if value not in (None,'null', 'none','None'):
                self.refPrice = float(value)
            else:
                self.refPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('lowestSalePrice')
            if value not in (None,'null', 'none','None'):
                self.lowestSalePrice = float(value)
            else:
                self.lowestSalePrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('inStockPrice')
            if value not in (None,'null', 'none','None'):
                self.inStockPrice = float(value)
            else:
                self.inStockPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isStopSale')
            if value not in (None,'null', 'none','None'):
                self.isStopSale = bool(value)
            else:
                self.isStopSale = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isOverSaleable')
            if value not in (None,'null', 'none','None'):
                self.isOverSaleable = bool(value)
            else:
                self.isOverSaleable = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isStopPurchase')
            if value not in (None,'null', 'none','None'):
                self.isStopPurchase = bool(value)
            else:
                self.isStopPurchase = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isTaxable')
            if value not in (None,'null', 'none','None'):
                self.isTaxable = bool(value)
            else:
                self.isTaxable = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isMobile')
            if value not in (None,'null', 'none','None'):
                self.isMobile = bool(value)
            else:
                self.isMobile = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('inventoryStockMin')
            if value not in (None,'null', 'none','None'):
                self.inventoryStockMin = int(value)
            else:
                self.inventoryStockMin = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('inventoryStockMax')
            if value not in (None,'null', 'none','None'):
                self.inventoryStockMax = int(value)
            else:
                self.inventoryStockMax = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('applyToSales')
            if value not in (None,'null', 'none','None'):
                self.applyToSales = bool(value)
            else:
                self.applyToSales = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('applyToPurchase')
            if value not in (None,'null', 'none','None'):
                self.applyToPurchase = bool(value)
            else:
                self.applyToPurchase = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productId')
            if value not in (None,'null', 'none','None'):
                self.productId = int(value)
            else:
                self.productId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('warehouseId')
            if value not in (None,'null', 'none','None'):
                self.warehouseId = int(value)
            else:
                self.warehouseId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('sku')
            if value not in (None,'null', 'none','None'):
                self.sku = str(value)
            else:
                self.sku = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productCost')
            if value not in (None,'null', 'none','None'):
                self.productCost = str(value)
            else:
                self.productCost = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('arrivalPrice')
            if value not in (None,'null', 'none','None'):
                self.arrivalPrice = str(value)
            else:
                self.arrivalPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        _, err = verify(str(self.packageType), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.measureUnit), [('required', True),])
        if err is not None:
            return err
        
        
        # TODO valid list
        # TODO valid list
        
        err = self.productType.valid()
        if err is not None:
            return err
        # TODO valid list
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        _, err = verify(int(self.productId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.warehouseId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'description': self.description,
            'packageType': self.packageType,
            'measureUnit': self.measureUnit,
            'netWeight': self.netWeight,
            'shippingWeight': self.shippingWeight,
            'specification': _dump_value(self.specification),
            'dimension': _dump_value(self.dimension),
            'dimensionUnit': self.dimensionUnit,
            'productType': self.productType.value,
            'thumbnail': _dump_value(self.thumbnail),
            'color': self.color,
            'shelfLife': self.shelfLife,
            'buffer': self.buffer,
            'dailySales': self.dailySales,
            'refPrice': self.refPrice,
            'lowestSalePrice': self.lowestSalePrice,
            'inStockPrice': self.inStockPrice,
            'isStopSale': self.isStopSale,
            'isOverSaleable': self.isOverSaleable,
            'isStopPurchase': self.isStopPurchase,
            'isTaxable': self.isTaxable,
            'isMobile': self.isMobile,
            'inventoryStockMin': self.inventoryStockMin,
            'inventoryStockMax': self.inventoryStockMax,
            'applyToSales': self.applyToSales,
            'applyToPurchase': self.applyToPurchase,
            'productId': self.productId,
            'warehouseId': self.warehouseId,
            'companyId': self.companyId,
            'sku': self.sku,
            'productCost': self.productCost,
            'arrivalPrice': self.arrivalPrice,
            'name': self.name,
        }

@dataclass(slots=True)
class UpdateProductResp:
    '''
    '''
    # success: true, fail: false
    ok: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ok')
            if value not in (None,'null', 'none','None'):
                self.ok = bool(value)
            else:
                self.ok = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ok': self.ok,
        }

@dataclass(slots=True)
class DeleteProductReq:
    '''
    '''
    # Product ID
    productId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('productId')
            if value not in (None,'null', 'none','None'):
                self.productId = int(value)
            else:
                self.productId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.productId), [('required', True),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'productId': self.productId,
        }

@dataclass(slots=True)
class DeleteProductResp:
    '''
    '''
    # success: true, fail: false
    ok: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ok')
            if value not in (None,'null', 'none','None'):
                self.ok = bool(value)
            else:
                self.ok = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ok': self.ok,
        }

@dataclass(slots=True)
class GetProductByIdReq:
    '''
    '''
    # Product ID
    productId: int
    # WarehouseId
    warehouseId: int
    # CompanyId
    companyId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('productId')
            if value not in (None,'null', 'none','None'):
                self.productId = int(value)
            else:
                self.productId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('warehouseId')
            if value not in (None,'null', 'none','None'):
                self.warehouseId = int(value)
            else:
                self.warehouseId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.productId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.warehouseId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'productId': self.productId,
            'warehouseId': self.warehouseId,
            'companyId': self.companyId,
        }

@dataclass(slots=True)
class GetProductByIdResp:
    '''
    '''
    # Description
    description: str
    # Package Type
    packageType: str
    # Measure Unit
    measureUnit: str
    # Net WT
    netWeight: float
    # Ship WT
    shippingWeight: float
    # Specification
    specification: list[str]
    # Dimension
    dimension: list[str]
    # Dimension Unit
    dimensionUnit: str
    # ProductType
    productType: PricingType
    # Image
    thumbnail: list[str]
    # Color
    color: str
    # Shelf Life (Days)
    shelfLife: int
    # Buffer (Days)
    buffer: int
    # Daily Sales
    dailySales: int
    # RefPrice
    refPrice: float
    # LowestSalePrice
    lowestSalePrice: float
    # InStockPrice
    inStockPrice: float
    # Stop Sale
    isStopSale: bool
    # Over Sellable
    isOverSaleable: bool
    # Stop Purchased
    isStopPurchase: bool
    # Taxable
    isTaxable: bool
    # IsMobile
    isMobile: bool
    # Inventory Stock Range (Min-Max)
    inventoryStockMin: int
    # Inventory Stock Range (Min-Max)
    inventoryStockMax: int
    # Apply To Sales
    applyToSales: bool
    # Apply To Purchase
    applyToPurchase: bool
    # Product ID
    productId: int
    # WarehouseId
    warehouseId: int
    # CompanyId
    companyId: int
    # Sku
    sku: str
    # ProductCost
    productCost: str
    # ArrivalPrice
    arrivalPrice: str
    # ProductName
    name: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('description')
            if value not in (None,'null', 'none','None'):
                self.description = str(value)
            else:
                self.description = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packageType')
            if value not in (None,'null', 'none','None'):
                self.packageType = str(value)
            else:
                self.packageType = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('measureUnit')
            if value not in (None,'null', 'none','None'):
                self.measureUnit = str(value)
            else:
                self.measureUnit = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('netWeight')
            if value not in (None,'null', 'none','None'):
                self.netWeight = float(value)
            else:
                self.netWeight = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('shippingWeight')
            if value not in (None,'null', 'none','None'):
                self.shippingWeight = float(value)
            else:
                self.shippingWeight = None
        except Exception as e:
            raise e
        
        self.specification = list(map(lambda x: str(x), data.get('specification') if data.get('specification') else []))
        self.dimension = list(map(lambda x: str(x), data.get('dimension') if data.get('dimension') else []))
        try:
            value = data.get('dimensionUnit')
            if value not in (None,'null', 'none','None'):
                self.dimensionUnit = str(value)
            else:
                self.dimensionUnit = None
        except Exception as e:
            raise e
        
        self.productType = PricingType(data.get('productType'))
        self.thumbnail = list(map(lambda x: str(x), data.get('thumbnail') if data.get('thumbnail') else []))
        try:
            value = data.get('color')
            if value not in (None,'null', 'none','None'):
                self.color = str(value)
            else:
                self.color = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('shelfLife')
            if value not in (None,'null', 'none','None'):
                self.shelfLife = int(value)
            else:
                self.shelfLife = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('buffer')
            if value not in (None,'null', 'none','None'):
                self.buffer = int(value)
            else:
                self.buffer = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('dailySales')
            if value not in (None,'null', 'none','None'):
                self.dailySales = int(value)
            else:
                self.dailySales = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('refPrice')
            if value not in (None,'null', 'none','None'):
                self.refPrice = float(value)
            else:
                self.refPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('lowestSalePrice')
            if value not in (None,'null', 'none','None'):
                self.lowestSalePrice = float(value)
            else:
                self.lowestSalePrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('inStockPrice')
            if value not in (None,'null', 'none','None'):
                self.inStockPrice = float(value)
            else:
                self.inStockPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isStopSale')
            if value not in (None,'null', 'none','None'):
                self.isStopSale = bool(value)
            else:
                self.isStopSale = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isOverSaleable')
            if value not in (None,'null', 'none','None'):
                self.isOverSaleable = bool(value)
            else:
                self.isOverSaleable = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isStopPurchase')
            if value not in (None,'null', 'none','None'):
                self.isStopPurchase = bool(value)
            else:
                self.isStopPurchase = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isTaxable')
            if value not in (None,'null', 'none','None'):
                self.isTaxable = bool(value)
            else:
                self.isTaxable = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isMobile')
            if value not in (None,'null', 'none','None'):
                self.isMobile = bool(value)
            else:
                self.isMobile = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('inventoryStockMin')
            if value not in (None,'null', 'none','None'):
                self.inventoryStockMin = int(value)
            else:
                self.inventoryStockMin = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('inventoryStockMax')
            if value not in (None,'null', 'none','None'):
                self.inventoryStockMax = int(value)
            else:
                self.inventoryStockMax = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('applyToSales')
            if value not in (None,'null', 'none','None'):
                self.applyToSales = bool(value)
            else:
                self.applyToSales = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('applyToPurchase')
            if value not in (None,'null', 'none','None'):
                self.applyToPurchase = bool(value)
            else:
                self.applyToPurchase = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productId')
            if value not in (None,'null', 'none','None'):
                self.productId = int(value)
            else:
                self.productId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('warehouseId')
            if value not in (None,'null', 'none','None'):
                self.warehouseId = int(value)
            else:
                self.warehouseId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('sku')
            if value not in (None,'null', 'none','None'):
                self.sku = str(value)
            else:
                self.sku = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productCost')
            if value not in (None,'null', 'none','None'):
                self.productCost = str(value)
            else:
                self.productCost = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('arrivalPrice')
            if value not in (None,'null', 'none','None'):
                self.arrivalPrice = str(value)
            else:
                self.arrivalPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        _, err = verify(str(self.packageType), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.measureUnit), [('required', True),])
        if err is not None:
            return err
        
        
        # TODO valid list
        # TODO valid list
        
        err = self.productType.valid()
        if err is not None:
            return err
        # TODO valid list
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        _, err = verify(int(self.productId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.warehouseId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'description': self.description,
            'packageType': self.packageType,
            'measureUnit': self.measureUnit,
            'netWeight': self.netWeight,
            'shippingWeight': self.shippingWeight,
            'specification': _dump_value(self.specification),
            'dimension': _dump_value(self.dimension),
            'dimensionUnit': self.dimensionUnit,
            'productType': self.productType.value,
            'thumbnail': _dump_value(self.thumbnail),
            'color': self.color,
            'shelfLife': self.shelfLife,
            'buffer': self.buffer,
            'dailySales': self.dailySales,
            'refPrice': self.refPrice,
            'lowestSalePrice': self.lowestSalePrice,
            'inStockPrice': self.inStockPrice,
            'isStopSale': self.isStopSale,
            'isOverSaleable': self.isOverSaleable,
            'isStopPurchase': self.isStopPurchase,
            'isTaxable': self.isTaxable,
            'isMobile': self.isMobile,
            'inventoryStockMin': self.inventoryStockMin,
            'inventoryStockMax': self.inventoryStockMax,
            'applyToSales': self.applyToSales,
            'applyToPurchase': self.applyToPurchase,
            'productId': self.productId,
            'warehouseId': self.warehouseId,
            'companyId': self.companyId,
            'sku': self.sku,
            'productCost': self.productCost,
            'arrivalPrice': self.arrivalPrice,
            'name': self.name,
        }

@dataclass(slots=True)
class GetProductBySpu:
    '''
    '''
    # ProductId
    productId: int
    # Sku
    sku: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('productId')
            if value not in (None,'null', 'none','None'):
                self.productId = int(value)
            else:
                self.productId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('sku')
            if value not in (None,'null', 'none','None'):
                self.sku = str(value)
            else:
                self.sku = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'productId': self.productId,
            'sku': self.sku,
        }

@dataclass(slots=True)
class GetProductBySpuResp:
    '''
    '''
    # Products
    products: list[GetProductBySpu]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.products = list(map(lambda x: GetProductBySpu(x), data.get('products') if data.get('products') else []))

    def valid(self):
        '''check object is valid'''
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'products': _dump_value(self.products),
        }

@dataclass(slots=True)
class GetProductListReq:
    '''
    '''
    # CompanyId
    companyId: int
    # CategoryId
    categoryId: int
    # Search
    search: str
    # PageId
    pageId: int
    # PageSize
    pageSize: int
    # Sort
    sort: ProductSort
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('categoryId')
            if value not in (None,'null', 'none','None'):
                self.categoryId = int(value)
            else:
                self.categoryId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('search')
            if value not in (None,'null', 'none','None'):
                self.search = str(value)
            else:
                self.search = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('pageId')
            if value not in (None,'null', 'none','None'):
                self.pageId = int(value)
            else:
                self.pageId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('pageSize')
            if value not in (None,'null', 'none','None'):
                self.pageSize = int(value)
            else:
                self.pageSize = None
        except Exception as e:
            raise e
        
        self.sort = ProductSort(data.get('sort'))

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.companyId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        
        
        
        
        err = self.sort.valid()
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'companyId': self.companyId,
            'categoryId': self.categoryId,
            'search': self.search,
            'pageId': self.pageId,
            'pageSize': self.pageSize,
            'sort': self.sort.value,
        }

@dataclass(slots=True)
class GetProductListRelatedCenterProductReq:
    '''
    '''
    # CompanyId
    companyId: int
    # CategoryId
    categoryId: int
    # Search
    search: str
    # PageId
    pageId: int
    # PageSize
    pageSize: int
    # Sort
    sort: ProductSort
    # VendorId
    vendorId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('categoryId')
            if value not in (None,'null', 'none','None'):
                self.categoryId = int(value)
            else:
                self.categoryId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('search')
            if value not in (None,'null', 'none','None'):
                self.search = str(value)
            else:
                self.search = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('pageId')
            if value not in (None,'null', 'none','None'):
                self.pageId = int(value)
            else:
                self.pageId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('pageSize')
            if value not in (None,'null', 'none','None'):
                self.pageSize = int(value)
            else:
                self.pageSize = None
        except Exception as e:
            raise e
        
        self.sort = ProductSort(data.get('sort'))
        try:
            value = data.get('vendorId')
            if value not in (None,'null', 'none','None'):
                self.vendorId = int(value)
            else:
                self.vendorId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.companyId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        
        
        
        
        err = self.sort.valid()
        if err is not None:
            return err
        _, err = verify(int(self.vendorId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'companyId': self.companyId,
            'categoryId': self.categoryId,
            'search': self.search,
            'pageId': self.pageId,
            'pageSize': self.pageSize,
            'sort': self.sort.value,
            'vendorId': self.vendorId,
        }

@dataclass(slots=True)
class GetProductListResp:
    '''
    '''
    # Total
    total: int
    # Page
    page: int
    # Page_size
    page_size: int
    # Pages
    pages: int
    # Product List
    data: list[UpdateProductReq]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('total')
            if value not in (None,'null', 'none','None'):
                self.total = int(value)
            else:
                self.total = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('page')
            if value not in (None,'null', 'none','None'):
                self.page = int(value)
            else:
                self.page = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('page_size')
            if value not in (None,'null', 'none','None'):
                self.page_size = int(value)
            else:
                self.page_size = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('pages')
            if value not in (None,'null', 'none','None'):
                self.pages = int(value)
            else:
                self.pages = None
        except Exception as e:
            raise e
        
        self.data = list(map(lambda x: UpdateProductReq(x), data.get('data') if data.get('data') else []))

    def valid(self):
        '''check object is valid'''
        
        
        
        
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'total': self.total,
            'page': self.page,
            'page_size': self.page_size,
            'pages': self.pages,
            'data': _dump_value(self.data),
        }

@dataclass(slots=True)
class ProductListRelatedCenterProduct:
    '''
    '''
    # Description
    description: str
    # Package Type
    packageType: str
    # Measure Unit
    measureUnit: str
    # Net WT
    netWeight: float
    # Ship WT
    shippingWeight: float
    # Specification
    specification: list[str]
    # Dimension
    dimension: list[str]
    # Dimension Unit
    dimensionUnit: str
    # ProductType
    productType: PricingType
    # Image
    thumbnail: list[str]
    # Color
    color: str
    # Shelf Life (Days)
    shelfLife: int
    # Buffer (Days)
    buffer: int
    # Daily Sales
    dailySales: int
    # RefPrice
    refPrice: float
    # LowestSalePrice
    lowestSalePrice: float
    # InStockPrice
    inStockPrice: float
    # Stop Sale
    isStopSale: bool
    # Over Sellable
    isOverSaleable: bool
    # Stop Purchased
    isStopPurchase: bool
    # Taxable
    isTaxable: bool
    # IsMobile
    isMobile: bool
    # Inventory Stock Range (Min-Max)
    inventoryStockMin: int
    # Inventory Stock Range (Min-Max)
    inventoryStockMax: int
    # Apply To Sales
    applyToSales: bool
    # Apply To Purchase
    applyToPurchase: bool
    # Product ID
    productId: int
    # WarehouseId
    warehouseId: int
    # CompanyId
    companyId: int
    # Sku
    sku: str
    # ProductCost
    productCost: str
    # ArrivalPrice
    arrivalPrice: str
    # ProductName
    name: str
    # CenterProductRefNum
    centerProductRefNum: str
    # CenterProductId
    centerProductId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('description')
            if value not in (None,'null', 'none','None'):
                self.description = str(value)
            else:
                self.description = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packageType')
            if value not in (None,'null', 'none','None'):
                self.packageType = str(value)
            else:
                self.packageType = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('measureUnit')
            if value not in (None,'null', 'none','None'):
                self.measureUnit = str(value)
            else:
                self.measureUnit = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('netWeight')
            if value not in (None,'null', 'none','None'):
                self.netWeight = float(value)
            else:
                self.netWeight = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('shippingWeight')
            if value not in (None,'null', 'none','None'):
                self.shippingWeight = float(value)
            else:
                self.shippingWeight = None
        except Exception as e:
            raise e
        
        self.specification = list(map(lambda x: str(x), data.get('specification') if data.get('specification') else []))
        self.dimension = list(map(lambda x: str(x), data.get('dimension') if data.get('dimension') else []))
        try:
            value = data.get('dimensionUnit')
            if value not in (None,'null', 'none','None'):
                self.dimensionUnit = str(value)
            else:
                self.dimensionUnit = None
        except Exception as e:
            raise e
        
        self.productType = PricingType(data.get('productType'))
        self.thumbnail = list(map(lambda x: str(x), data.get('thumbnail') if data.get('thumbnail') else []))
        try:
            value = data.get('color')
            if value not in (None,'null', 'none','None'):
                self.color = str(value)
            else:
                self.color = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('shelfLife')
            if value not in (None,'null', 'none','None'):
                self.shelfLife = int(value)
            else:
                self.shelfLife = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('buffer')
            if value not in (None,'null', 'none','None'):
                self.buffer = int(value)
            else:
                self.buffer = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('dailySales')
            if value not in (None,'null', 'none','None'):
                self.dailySales = int(value)
            else:
                self.dailySales = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('refPrice')
            if value not in (None,'null', 'none','None'):
                self.refPrice = float(value)
            else:
                self.refPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('lowestSalePrice')
            if value not in (None,'null', 'none','None'):
                self.lowestSalePrice = float(value)
            else:
                self.lowestSalePrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('inStockPrice')
            if value not in (None,'null', 'none','None'):
                self.inStockPrice = float(value)
            else:
                self.inStockPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isStopSale')
            if value not in (None,'null', 'none','None'):
                self.isStopSale = bool(value)
            else:
                self.isStopSale = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isOverSaleable')
            if value not in (None,'null', 'none','None'):
                self.isOverSaleable = bool(value)
            else:
                self.isOverSaleable = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isStopPurchase')
            if value not in (None,'null', 'none','None'):
                self.isStopPurchase = bool(value)
            else:
                self.isStopPurchase = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isTaxable')
            if value not in (None,'null', 'none','None'):
                self.isTaxable = bool(value)
            else:
                self.isTaxable = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('isMobile')
            if value not in (None,'null', 'none','None'):
                self.isMobile = bool(value)
            else:
                self.isMobile = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('inventoryStockMin')
            if value not in (None,'null', 'none','None'):
                self.inventoryStockMin = int(value)
            else:
                self.inventoryStockMin = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('inventoryStockMax')
            if value not in (None,'null', 'none','None'):
                self.inventoryStockMax = int(value)
            else:
                self.inventoryStockMax = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('applyToSales')
            if value not in (None,'null', 'none','None'):
                self.applyToSales = bool(value)
            else:
                self.applyToSales = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('applyToPurchase')
            if value not in (None,'null', 'none','None'):
                self.applyToPurchase = bool(value)
            else:
                self.applyToPurchase = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productId')
            if value not in (None,'null', 'none','None'):
                self.productId = int(value)
            else:
                self.productId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('warehouseId')
            if value not in (None,'null', 'none','None'):
                self.warehouseId = int(value)
            else:
                self.warehouseId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('sku')
            if value not in (None,'null', 'none','None'):
                self.sku = str(value)
            else:
                self.sku = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productCost')
            if value not in (None,'null', 'none','None'):
                self.productCost = str(value)
            else:
                self.productCost = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('arrivalPrice')
            if value not in (None,'null', 'none','None'):
                self.arrivalPrice = str(value)
            else:
                self.arrivalPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('centerProductRefNum')
            if value not in (None,'null', 'none','None'):
                self.centerProductRefNum = str(value)
            else:
                self.centerProductRefNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('centerProductId')
            if value not in (None,'null', 'none','None'):
                self.centerProductId = int(value)
            else:
                self.centerProductId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        _, err = verify(str(self.packageType), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.measureUnit), [('required', True),])
        if err is not None:
            return err
        
        
        # TODO valid list
        # TODO valid list
        
        err = self.productType.valid()
        if err is not None:
            return err
        # TODO valid list
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        _, err = verify(int(self.productId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.warehouseId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        
        
        
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'description': self.description,
            'packageType': self.packageType,
            'measureUnit': self.measureUnit,
            'netWeight': self.netWeight,
            'shippingWeight': self.shippingWeight,
            'specification': _dump_value(self.specification),
            'dimension': _dump_value(self.dimension),
            'dimensionUnit': self.dimensionUnit,
            'productType': self.productType.value,
            'thumbnail': _dump_value(self.thumbnail),
            'color': self.color,
            'shelfLife': self.shelfLife,
            'buffer': self.buffer,
            'dailySales': self.dailySales,
            'refPrice': self.refPrice,
            'lowestSalePrice': self.lowestSalePrice,
            'inStockPrice': self.inStockPrice,
            'isStopSale': self.isStopSale,
            'isOverSaleable': self.isOverSaleable,
            'isStopPurchase': self.isStopPurchase,
            'isTaxable': self.isTaxable,
            'isMobile': self.isMobile,
            'inventoryStockMin': self.inventoryStockMin,
            'inventoryStockMax': self.inventoryStockMax,
            'applyToSales': self.applyToSales,
            'applyToPurchase': self.applyToPurchase,
            'productId': self.productId,
            'warehouseId': self.warehouseId,
            'companyId': self.companyId,
            'sku': self.sku,
            'productCost': self.productCost,
            'arrivalPrice': self.arrivalPrice,
            'name': self.name,
            'centerProductRefNum': self.centerProductRefNum,
            'centerProductId': self.centerProductId,
        }

@dataclass(slots=True)
class GetProductListRelatedCenterProductResp:
    '''
    '''
    # Total
    total: int
    # Page
    page: int
    # Page_size
    page_size: int
    # Pages
    pages: int
    # Product List
    data: list[ProductListRelatedCenterProduct]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('total')
            if value not in (None,'null', 'none','None'):
                self.total = int(value)
            else:
                self.total = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('page')
            if value not in (None,'null', 'none','None'):
                self.page = int(value)
            else:
                self.page = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('page_size')
            if value not in (None,'null', 'none','None'):
                self.page_size = int(value)
            else:
                self.page_size = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('pages')
            if value not in (None,'null', 'none','None'):
                self.pages = int(value)
            else:
                self.pages = None
        except Exception as e:
            raise e
        
        self.data = list(map(lambda x: ProductListRelatedCenterProduct(x), data.get('data') if data.get('data') else []))

    def valid(self):
        '''check object is valid'''
        
        
        
        
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'total': self.total,
            'page': self.page,
            'page_size': self.page_size,
            'pages': self.pages,
            'data': _dump_value(self.data),
        }

@dataclass(slots=True)
class GetProductsByVendorReq:
    '''
    '''
    # CenterProductIds
    centerProductIds: list[int]
    # VendorId
    vendorId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.centerProductIds = list(map(lambda x: int(x), data.get('centerProductIds') if data.get('centerProductIds') else []))
        try:
            value = data.get('vendorId')
            if value not in (None,'null', 'none','None'):
                self.vendorId = int(value)
            else:
                self.vendorId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        # TODO valid list
        _, err = verify(int(self.vendorId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'centerProductIds': _dump_value(self.centerProductIds),
            'vendorId': self.vendorId,
        }

@dataclass(slots=True)
class GetProductByVendorResp:
    '''
    '''
    # Id
    id: int
    # CompanyId
    companyId: int
    # Name
    name: str
    # Description
    description: str
    # ProductNum
    productNum: str
    # GeneraNum
    generalNum: str
    # RefNum
    refNum: str
    # ProductType
    productType: str
    # PackageType
    packageType: str
    # NetWeight
    netWeight: float
    # PackageSize
    packageSize: str
    # Thumbnail
    thumbnail: str
    # Specification
    specification: str
    # Dimension 
    dimension: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('description')
            if value not in (None,'null', 'none','None'):
                self.description = str(value)
            else:
                self.description = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productNum')
            if value not in (None,'null', 'none','None'):
                self.productNum = str(value)
            else:
                self.productNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('generalNum')
            if value not in (None,'null', 'none','None'):
                self.generalNum = str(value)
            else:
                self.generalNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('refNum')
            if value not in (None,'null', 'none','None'):
                self.refNum = str(value)
            else:
                self.refNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productType')
            if value not in (None,'null', 'none','None'):
                self.productType = str(value)
            else:
                self.productType = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packageType')
            if value not in (None,'null', 'none','None'):
                self.packageType = str(value)
            else:
                self.packageType = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('netWeight')
            if value not in (None,'null', 'none','None'):
                self.netWeight = float(value)
            else:
                self.netWeight = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packageSize')
            if value not in (None,'null', 'none','None'):
                self.packageSize = str(value)
            else:
                self.packageSize = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('thumbnail')
            if value not in (None,'null', 'none','None'):
                self.thumbnail = str(value)
            else:
                self.thumbnail = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('specification')
            if value not in (None,'null', 'none','None'):
                self.specification = str(value)
            else:
                self.specification = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('dimension')
            if value not in (None,'null', 'none','None'):
                self.dimension = str(value)
            else:
                self.dimension = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'companyId': self.companyId,
            'name': self.name,
            'description': self.description,
            'productNum': self.productNum,
            'generalNum': self.generalNum,
            'refNum': self.refNum,
            'productType': self.productType,
            'packageType': self.packageType,
            'netWeight': self.netWeight,
            'packageSize': self.packageSize,
            'thumbnail': self.thumbnail,
            'specification': self.specification,
            'dimension': self.dimension,
        }

@dataclass(slots=True)
class GetProductsByVendorResp:
    '''
    '''
    # App Products
    products: list[GetProductByVendorResp]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.products = list(map(lambda x: GetProductByVendorResp(x), data.get('products') if data.get('products') else []))

    def valid(self):
        '''check object is valid'''
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'products': _dump_value(self.products),
        }

@dataclass(slots=True)
class CenterProductByProductReq:
    '''
    '''
    # AppProductId
    productId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('productId')
            if value not in (None,'null', 'none','None'):
                self.productId = int(value)
            else:
                self.productId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.productId), [('required', True),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'productId': self.productId,
        }

@dataclass(slots=True)
class GetCenterProductByProductReq:
    '''
    '''
    # AppProductIds
    productIds: list[CenterProductByProductReq]
    # VendorId
    vendorId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.productIds = list(map(lambda x: CenterProductByProductReq(x), data.get('productIds') if data.get('productIds') else []))
        try:
            value = data.get('vendorId')
            if value not in (None,'null', 'none','None'):
                self.vendorId = int(value)
            else:
                self.vendorId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        # TODO valid list
        _, err = verify(int(self.vendorId), [('required', True),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'productIds': _dump_value(self.productIds),
            'vendorId': self.vendorId,
        }

@dataclass(slots=True)
class GetAppProductByProductReq:
    '''
    '''
    # AppProductIds
    productIds: list[CenterProductByProductReq]
    # VendorId
    vendorId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.productIds = list(map(lambda x: CenterProductByProductReq(x), data.get('productIds') if data.get('productIds') else []))
        try:
            value = data.get('vendorId')
            if value not in (None,'null', 'none','None'):
                self.vendorId = int(value)
            else:
                self.vendorId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        # TODO valid list
        _, err = verify(int(self.vendorId), [('required', True),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'productIds': _dump_value(self.productIds),
            'vendorId': self.vendorId,
        }

@dataclass(slots=True)
class GetCenterProductByProductResp:
    '''
    '''
    # AppMapCenterProductIds
    appMapCenterProductIds: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('appMapCenterProductIds')
            if value not in (None,'null', 'none','None'):
                self.appMapCenterProductIds = str(value)
            else:
                self.appMapCenterProductIds = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'appMapCenterProductIds': self.appMapCenterProductIds,
        }

@dataclass(slots=True)
class GetAppProductByProductResp:
    '''
    '''
    # CenterMapAppProductIds
    CenterMapAppProductIds: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('CenterMapAppProductIds')
            if value not in (None,'null', 'none','None'):
                self.CenterMapAppProductIds = str(value)
            else:
                self.CenterMapAppProductIds = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'CenterMapAppProductIds': self.CenterMapAppProductIds,
        }

@dataclass(slots=True)
class GetConnectReq:
    '''
    '''
    # CenterProductId
    centerId: int
    # AppProductId
    appId: int
    # VendorId
    vendorId: int
    # Barcode
    barcode: str
    # VendorSku
    vendorSku: str
    # AscriptionCompanyId
    ascriptionCompanyId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('centerId')
            if value not in (None,'null', 'none','None'):
                self.centerId = int(value)
            else:
                self.centerId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('appId')
            if value not in (None,'null', 'none','None'):
                self.appId = int(value)
            else:
                self.appId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorId')
            if value not in (None,'null', 'none','None'):
                self.vendorId = int(value)
            else:
                self.vendorId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('barcode')
            if value not in (None,'null', 'none','None'):
                self.barcode = str(value)
            else:
                self.barcode = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorSku')
            if value not in (None,'null', 'none','None'):
                self.vendorSku = str(value)
            else:
                self.vendorSku = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('ascriptionCompanyId')
            if value not in (None,'null', 'none','None'):
                self.ascriptionCompanyId = int(value)
            else:
                self.ascriptionCompanyId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        _, err = verify(int(self.appId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.vendorId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'centerId': self.centerId,
            'appId': self.appId,
            'vendorId': self.vendorId,
            'barcode': self.barcode,
            'vendorSku': self.vendorSku,
            'ascriptionCompanyId': self.ascriptionCompanyId,
        }

@dataclass(slots=True)
class GetConnectResp:
    '''
    '''
    # success: true, fail: false
    ok: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ok')
            if value not in (None,'null', 'none','None'):
                self.ok = bool(value)
            else:
                self.ok = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ok': self.ok,
        }

@dataclass(slots=True)
class UpdateSpuReq:
    '''
    '''
    # Id
    id: int
    # Name
    name: str
    # Brand
    brand: str
    # Origin
    origin: str
    # Images
    images: list[str]
    # CategoryId
    categoryId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('brand')
            if value not in (None,'null', 'none','None'):
                self.brand = str(value)
            else:
                self.brand = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('origin')
            if value not in (None,'null', 'none','None'):
                self.origin = str(value)
            else:
                self.origin = None
        except Exception as e:
            raise e
        
        self.images = list(map(lambda x: str(x), data.get('images') if data.get('images') else []))
        try:
            value = data.get('categoryId')
            if value not in (None,'null', 'none','None'):
                self.categoryId = int(value)
            else:
                self.categoryId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.id), [('gt', 0),('required', True),])
        if err is not None:
            return err
        
        
        
        # TODO valid list
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'name': self.name,
            'brand': self.brand,
            'origin': self.origin,
            'images': _dump_value(self.images),
            'categoryId': self.categoryId,
        }

@dataclass(slots=True)
class UpdateSpuResp:
    '''
    '''
    # success: true, fail: false
    ok: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ok')
            if value not in (None,'null', 'none','None'):
                self.ok = bool(value)
            else:
                self.ok = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ok': self.ok,
        }

@dataclass(slots=True)
class GetSpuByProductIdReq:
    '''
    '''
    # Product Id
    productId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('productId')
            if value not in (None,'null', 'none','None'):
                self.productId = int(value)
            else:
                self.productId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.productId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'productId': self.productId,
        }

@dataclass(slots=True)
class GetSpuByProductIdResp:
    '''
    '''
    # Id
    id: int
    # Name
    name: str
    # Brand
    brand: str
    # Origin
    origin: str
    # Images
    images: list[str]
    # CategoryId
    categoryId: int
    # SPU
    spu: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('brand')
            if value not in (None,'null', 'none','None'):
                self.brand = str(value)
            else:
                self.brand = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('origin')
            if value not in (None,'null', 'none','None'):
                self.origin = str(value)
            else:
                self.origin = None
        except Exception as e:
            raise e
        
        self.images = list(map(lambda x: str(x), data.get('images') if data.get('images') else []))
        try:
            value = data.get('categoryId')
            if value not in (None,'null', 'none','None'):
                self.categoryId = int(value)
            else:
                self.categoryId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('spu')
            if value not in (None,'null', 'none','None'):
                self.spu = str(value)
            else:
                self.spu = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.id), [('gt', 0),('required', True),])
        if err is not None:
            return err
        
        
        
        # TODO valid list
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'name': self.name,
            'brand': self.brand,
            'origin': self.origin,
            'images': _dump_value(self.images),
            'categoryId': self.categoryId,
            'spu': self.spu,
        }

@dataclass(slots=True)
class GetVendorsByProductIdReq:
    '''
    '''
    # Product ID
    productId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('productId')
            if value not in (None,'null', 'none','None'):
                self.productId = int(value)
            else:
                self.productId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.productId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'productId': self.productId,
        }

@dataclass(slots=True)
class Vendors:
    '''
    '''
    # Id
    id: int
    # ProductId
    productId: int
    # VendorId
    vendorId: int
    # Barcode
    barcode: str
    # VendorSku
    vendorSku: str
    # Name
    name: str
    # VendorNum
    vendorNum: str
    # businessType
    businessType: str
    # paymentTerms
    paymentTerms: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productId')
            if value not in (None,'null', 'none','None'):
                self.productId = int(value)
            else:
                self.productId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorId')
            if value not in (None,'null', 'none','None'):
                self.vendorId = int(value)
            else:
                self.vendorId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('barcode')
            if value not in (None,'null', 'none','None'):
                self.barcode = str(value)
            else:
                self.barcode = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorSku')
            if value not in (None,'null', 'none','None'):
                self.vendorSku = str(value)
            else:
                self.vendorSku = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorNum')
            if value not in (None,'null', 'none','None'):
                self.vendorNum = str(value)
            else:
                self.vendorNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('businessType')
            if value not in (None,'null', 'none','None'):
                self.businessType = str(value)
            else:
                self.businessType = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('paymentTerms')
            if value not in (None,'null', 'none','None'):
                self.paymentTerms = str(value)
            else:
                self.paymentTerms = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        _, err = verify(int(self.productId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.vendorId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        
        
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'productId': self.productId,
            'vendorId': self.vendorId,
            'barcode': self.barcode,
            'vendorSku': self.vendorSku,
            'name': self.name,
            'vendorNum': self.vendorNum,
            'businessType': self.businessType,
            'paymentTerms': self.paymentTerms,
        }

@dataclass(slots=True)
class GetVendorsByProductIdResp:
    '''
    '''
    # Vendors
    vendors: list[Vendors]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.vendors = list(map(lambda x: Vendors(x), data.get('vendors') if data.get('vendors') else []))

    def valid(self):
        '''check object is valid'''
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'vendors': _dump_value(self.vendors),
        }

@dataclass(slots=True)
class UpdateVendorsByProductIdReq:
    '''
    '''
    # Vendors
    vendors: list[Vendors]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.vendors = list(map(lambda x: Vendors(x), data.get('vendors') if data.get('vendors') else []))

    def valid(self):
        '''check object is valid'''
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'vendors': _dump_value(self.vendors),
        }

@dataclass(slots=True)
class UpdateVendorsByProductIdResp:
    '''
    '''
    # success: true, fail: false
    ok: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ok')
            if value not in (None,'null', 'none','None'):
                self.ok = bool(value)
            else:
                self.ok = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ok': self.ok,
        }

@dataclass(slots=True)
class Convert:
    '''
    '''
    # Id
    id: int
    # from SKU
    fromSKU: str
    # to SKU
    toSKU: str
    # Convert Num
    convertNum: int
    # AutoConvert
    autoConvert: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('fromSKU')
            if value not in (None,'null', 'none','None'):
                self.fromSKU = str(value)
            else:
                self.fromSKU = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('toSKU')
            if value not in (None,'null', 'none','None'):
                self.toSKU = str(value)
            else:
                self.toSKU = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('convertNum')
            if value not in (None,'null', 'none','None'):
                self.convertNum = int(value)
            else:
                self.convertNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('autoConvert')
            if value not in (None,'null', 'none','None'):
                self.autoConvert = bool(value)
            else:
                self.autoConvert = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'fromSKU': self.fromSKU,
            'toSKU': self.toSKU,
            'convertNum': self.convertNum,
            'autoConvert': self.autoConvert,
        }

@dataclass(slots=True)
class GetConvertByProductIdReq:
    '''
    '''
    # Product ID
    productId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('productId')
            if value not in (None,'null', 'none','None'):
                self.productId = int(value)
            else:
                self.productId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.productId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'productId': self.productId,
        }

@dataclass(slots=True)
class GetConvertByProductIdResp:
    '''
    '''
    # Converts
    converts: list[Convert]
    # ProductId
    productId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.converts = list(map(lambda x: Convert(x), data.get('converts') if data.get('converts') else []))
        try:
            value = data.get('productId')
            if value not in (None,'null', 'none','None'):
                self.productId = int(value)
            else:
                self.productId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        # TODO valid list
        _, err = verify(int(self.productId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'converts': _dump_value(self.converts),
            'productId': self.productId,
        }

@dataclass(slots=True)
class UpdateConvertByProductIdReq:
    '''
    '''
    # Converts
    converts: list[Convert]
    # ProductId
    productId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.converts = list(map(lambda x: Convert(x), data.get('converts') if data.get('converts') else []))
        try:
            value = data.get('productId')
            if value not in (None,'null', 'none','None'):
                self.productId = int(value)
            else:
                self.productId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        # TODO valid list
        _, err = verify(int(self.productId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'converts': _dump_value(self.converts),
            'productId': self.productId,
        }

@dataclass(slots=True)
class UpdateConvertByProductIdResp:
    '''
    '''
    # success: true, fail: false
    ok: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ok')
            if value not in (None,'null', 'none','None'):
                self.ok = bool(value)
            else:
                self.ok = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ok': self.ok,
        }

@dataclass(slots=True)
class CreateCategoryReq:
    '''
    '''
    # CompanyId
    companyId: int
    # CategoryNum
    categoryNum: str
    # Name
    name: str
    # Description
    description: str
    # Image
    image: str
    # ParentId
    parentId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('categoryNum')
            if value not in (None,'null', 'none','None'):
                self.categoryNum = str(value)
            else:
                self.categoryNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('description')
            if value not in (None,'null', 'none','None'):
                self.description = str(value)
            else:
                self.description = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('image')
            if value not in (None,'null', 'none','None'):
                self.image = str(value)
            else:
                self.image = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('parentId')
            if value not in (None,'null', 'none','None'):
                self.parentId = int(value)
            else:
                self.parentId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.companyId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        
        _, err = verify(str(self.name), [('required', True),])
        if err is not None:
            return err
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'companyId': self.companyId,
            'categoryNum': self.categoryNum,
            'name': self.name,
            'description': self.description,
            'image': self.image,
            'parentId': self.parentId,
        }

@dataclass(slots=True)
class UpdateCategoryReq:
    '''
    '''
    # CompanyId
    companyId: int
    # CategoryNum
    categoryNum: str
    # Name
    name: str
    # Description
    description: str
    # Image
    image: str
    # ParentId
    parentId: int
    # Id
    id: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('categoryNum')
            if value not in (None,'null', 'none','None'):
                self.categoryNum = str(value)
            else:
                self.categoryNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('description')
            if value not in (None,'null', 'none','None'):
                self.description = str(value)
            else:
                self.description = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('image')
            if value not in (None,'null', 'none','None'):
                self.image = str(value)
            else:
                self.image = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('parentId')
            if value not in (None,'null', 'none','None'):
                self.parentId = int(value)
            else:
                self.parentId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.companyId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        
        _, err = verify(str(self.name), [('required', True),])
        if err is not None:
            return err
        
        
        
        _, err = verify(int(self.id), [('gt', 0),('required', True),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'companyId': self.companyId,
            'categoryNum': self.categoryNum,
            'name': self.name,
            'description': self.description,
            'image': self.image,
            'parentId': self.parentId,
            'id': self.id,
        }

@dataclass(slots=True)
class DeleteCategoryReq:
    '''
    '''
    # Id
    id: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.id), [('gt', 0),('required', True),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
        }

@dataclass(slots=True)
class CreateCategoryResp:
    '''
    '''
    # success: true, fail: false
    ok: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ok')
            if value not in (None,'null', 'none','None'):
                self.ok = bool(value)
            else:
                self.ok = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ok': self.ok,
        }

@dataclass(slots=True)
class GetCategoryReq:
    '''
    '''
    
    def __init__(self, data: dict):
        if data == None:
            return None

    def valid(self):
        '''check object is valid'''
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
        }

@dataclass(slots=True)
class CategoryNode:
    '''
    '''
    # Id
    id: int
    # CompanyId
    companyId: int
    # Name
    name: str
    # CategoryNum
    categoryNum: str
    # Description
    description: str
    # Image
    image: str
    # Children
    children: list[CategoryNode]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('categoryNum')
            if value not in (None,'null', 'none','None'):
                self.categoryNum = str(value)
            else:
                self.categoryNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('description')
            if value not in (None,'null', 'none','None'):
                self.description = str(value)
            else:
                self.description = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('image')
            if value not in (None,'null', 'none','None'):
                self.image = str(value)
            else:
                self.image = None
        except Exception as e:
            raise e
        
        self.children = list(map(lambda x: CategoryNode(x), data.get('children') if data.get('children') else []))

    def valid(self):
        '''check object is valid'''
        
        
        
        
        
        
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'companyId': self.companyId,
            'name': self.name,
            'categoryNum': self.categoryNum,
            'description': self.description,
            'image': self.image,
            'children': _dump_value(self.children),
        }

@dataclass(slots=True)
class GetCategoryResp:
    '''
    '''
    # Categories
    categories: list[CategoryNode]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.categories = list(map(lambda x: CategoryNode(x), data.get('categories') if data.get('categories') else []))

    def valid(self):
        '''check object is valid'''
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'categories': _dump_value(self.categories),
        }

@dataclass(slots=True)
class InventoryListReq:
    '''
    '''
    # CompanyId
    companyId: int
    # WarehouseId
    warehouseId: int
    # CategoryId
    categoryId: int
    # Vendor ID
    vendorId: int
    # 搜索关键字
    search: str
    # page size
    pageSize: int
    # 上一页最后一条记录的排序键，如果不是 id, 需要修改此字
    pageId: int
    # Sort
    sort: InventoryListSort
    # Product Status
    status: ProductStatus
    # Stock Level
    stockLevel: StockLevel
    # Group By
    groupBy: InventoryListGroupBy
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('warehouseId')
            if value not in (None,'null', 'none','None'):
                self.warehouseId = int(value)
            else:
                self.warehouseId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('categoryId')
            if value not in (None,'null', 'none','None'):
                self.categoryId = int(value)
            else:
                self.categoryId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorId')
            if value not in (None,'null', 'none','None'):
                self.vendorId = int(value)
            else:
                self.vendorId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('search')
            if value not in (None,'null', 'none','None'):
                self.search = str(value)
            else:
                self.search = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('pageSize')
            if value not in (None,'null', 'none','None'):
                self.pageSize = int(value)
            else:
                self.pageSize = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('pageId')
            if value not in (None,'null', 'none','None'):
                self.pageId = int(value)
            else:
                self.pageId = None
        except Exception as e:
            raise e
        
        self.sort = InventoryListSort(data.get('sort'))
        self.status = ProductStatus(data.get('status'))
        self.stockLevel = StockLevel(data.get('stockLevel'))
        self.groupBy = InventoryListGroupBy(data.get('groupBy'))

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.companyId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.warehouseId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        
        
        
        
        
        err = self.sort.valid()
        if err is not None:
            return err
        err = self.status.valid()
        if err is not None:
            return err
        err = self.stockLevel.valid()
        if err is not None:
            return err
        err = self.groupBy.valid()
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'companyId': self.companyId,
            'warehouseId': self.warehouseId,
            'categoryId': self.categoryId,
            'vendorId': self.vendorId,
            'search': self.search,
            'pageSize': self.pageSize,
            'pageId': self.pageId,
            'sort': self.sort.value,
            'status': self.status.value,
            'stockLevel': self.stockLevel.value,
            'groupBy': self.groupBy.value,
        }

@dataclass(slots=True)
class Inventory:
    '''
    '''
    # ID
    id: int
    # Image
    image: str
    # Name
    name: str
    # SPU
    spu: str
    # SKU
    sku: str
    # Package Spec
    packageSpec: str
    # In Stock
    inStock: int
    # On hand
    onHand: int
    # Presale
    presale: int
    # Purchased
    purchased: int
    # Inventory $
    inventoryValue: str
    # Cost
    cost: str
    # Sale $
    sale: str
    # Vendor
    vendor: list[int]
    # Warehouse
    warehouse: int
    # Daily Sales
    dailySales: int
    # Days Left
    daysLeft: int
    # Creator
    creator: str
    # Created
    created: str
    # Oversaleable
    oversaleable: bool
    # ProductId
    productId: int
    # SpuId
    spuId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('image')
            if value not in (None,'null', 'none','None'):
                self.image = str(value)
            else:
                self.image = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('spu')
            if value not in (None,'null', 'none','None'):
                self.spu = str(value)
            else:
                self.spu = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('sku')
            if value not in (None,'null', 'none','None'):
                self.sku = str(value)
            else:
                self.sku = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packageSpec')
            if value not in (None,'null', 'none','None'):
                self.packageSpec = str(value)
            else:
                self.packageSpec = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('inStock')
            if value not in (None,'null', 'none','None'):
                self.inStock = int(value)
            else:
                self.inStock = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('onHand')
            if value not in (None,'null', 'none','None'):
                self.onHand = int(value)
            else:
                self.onHand = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('presale')
            if value not in (None,'null', 'none','None'):
                self.presale = int(value)
            else:
                self.presale = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('purchased')
            if value not in (None,'null', 'none','None'):
                self.purchased = int(value)
            else:
                self.purchased = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('inventoryValue')
            if value not in (None,'null', 'none','None'):
                self.inventoryValue = str(value)
            else:
                self.inventoryValue = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('cost')
            if value not in (None,'null', 'none','None'):
                self.cost = str(value)
            else:
                self.cost = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('sale')
            if value not in (None,'null', 'none','None'):
                self.sale = str(value)
            else:
                self.sale = None
        except Exception as e:
            raise e
        
        self.vendor = list(map(lambda x: int(x), data.get('vendor') if data.get('vendor') else []))
        try:
            value = data.get('warehouse')
            if value not in (None,'null', 'none','None'):
                self.warehouse = int(value)
            else:
                self.warehouse = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('dailySales')
            if value not in (None,'null', 'none','None'):
                self.dailySales = int(value)
            else:
                self.dailySales = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('daysLeft')
            if value not in (None,'null', 'none','None'):
                self.daysLeft = int(value)
            else:
                self.daysLeft = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('creator')
            if value not in (None,'null', 'none','None'):
                self.creator = str(value)
            else:
                self.creator = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('created')
            if value not in (None,'null', 'none','None'):
                self.created = str(value)
            else:
                self.created = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('oversaleable')
            if value not in (None,'null', 'none','None'):
                self.oversaleable = bool(value)
            else:
                self.oversaleable = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productId')
            if value not in (None,'null', 'none','None'):
                self.productId = int(value)
            else:
                self.productId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('spuId')
            if value not in (None,'null', 'none','None'):
                self.spuId = int(value)
            else:
                self.spuId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        
        
        
        
        
        
        
        
        
        
        
        # TODO valid list
        
        
        
        
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'image': self.image,
            'name': self.name,
            'spu': self.spu,
            'sku': self.sku,
            'packageSpec': self.packageSpec,
            'inStock': self.inStock,
            'onHand': self.onHand,
            'presale': self.presale,
            'purchased': self.purchased,
            'inventoryValue': self.inventoryValue,
            'cost': self.cost,
            'sale': self.sale,
            'vendor': _dump_value(self.vendor),
            'warehouse': self.warehouse,
            'dailySales': self.dailySales,
            'daysLeft': self.daysLeft,
            'creator': self.creator,
            'created': self.created,
            'oversaleable': self.oversaleable,
            'productId': self.productId,
            'spuId': self.spuId,
        }

@dataclass(slots=True)
class InventoryListResp:
    '''
    '''
    # Total
    total: int
    # Page
    page: int
    # Pagesize
    page_size: int
    # Pages
    pages: int
    # List
    data: list[Inventory]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('total')
            if value not in (None,'null', 'none','None'):
                self.total = int(value)
            else:
                self.total = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('page')
            if value not in (None,'null', 'none','None'):
                self.page = int(value)
            else:
                self.page = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('page_size')
            if value not in (None,'null', 'none','None'):
                self.page_size = int(value)
            else:
                self.page_size = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('pages')
            if value not in (None,'null', 'none','None'):
                self.pages = int(value)
            else:
                self.pages = None
        except Exception as e:
            raise e
        
        self.data = list(map(lambda x: Inventory(x), data.get('data') if data.get('data') else []))

    def valid(self):
        '''check object is valid'''
        
        
        
        
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'total': self.total,
            'page': self.page,
            'page_size': self.page_size,
            'pages': self.pages,
            'data': _dump_value(self.data),
        }

@dataclass(slots=True)
class InventoryStatisticsReq:
    '''
    '''
    # CompanyId
    companyId: int
    # WarehouseId
    warehouseId: int
    # CategoryId
    categoryId: int
    # Vendor ID
    vendorId: int
    # 搜索关键字
    search: str
    # page size
    pageSize: int
    # 上一页最后一条记录的排序键，如果不是 id, 需要修改此字
    pageId: int
    # Sort
    sort: InventoryListSort
    # Product Status
    status: ProductStatus
    # Stock Level
    stockLevel: StockLevel
    # Group By
    groupBy: InventoryListGroupBy
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('warehouseId')
            if value not in (None,'null', 'none','None'):
                self.warehouseId = int(value)
            else:
                self.warehouseId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('categoryId')
            if value not in (None,'null', 'none','None'):
                self.categoryId = int(value)
            else:
                self.categoryId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendorId')
            if value not in (None,'null', 'none','None'):
                self.vendorId = int(value)
            else:
                self.vendorId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('search')
            if value not in (None,'null', 'none','None'):
                self.search = str(value)
            else:
                self.search = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('pageSize')
            if value not in (None,'null', 'none','None'):
                self.pageSize = int(value)
            else:
                self.pageSize = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('pageId')
            if value not in (None,'null', 'none','None'):
                self.pageId = int(value)
            else:
                self.pageId = None
        except Exception as e:
            raise e
        
        self.sort = InventoryListSort(data.get('sort'))
        self.status = ProductStatus(data.get('status'))
        self.stockLevel = StockLevel(data.get('stockLevel'))
        self.groupBy = InventoryListGroupBy(data.get('groupBy'))

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.companyId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.warehouseId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        
        
        
        
        
        err = self.sort.valid()
        if err is not None:
            return err
        err = self.status.valid()
        if err is not None:
            return err
        err = self.stockLevel.valid()
        if err is not None:
            return err
        err = self.groupBy.valid()
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'companyId': self.companyId,
            'warehouseId': self.warehouseId,
            'categoryId': self.categoryId,
            'vendorId': self.vendorId,
            'search': self.search,
            'pageSize': self.pageSize,
            'pageId': self.pageId,
            'sort': self.sort.value,
            'status': self.status.value,
            'stockLevel': self.stockLevel.value,
            'groupBy': self.groupBy.value,
        }

@dataclass(slots=True)
class InventoryStatisticsResp:
    '''
    '''
    # Total SKUs
    totalSkus: int
    # Total QTY
    totalQty: int
    # Total Inv
    totalInv: str
    # Total WT
    totalWt: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('totalSkus')
            if value not in (None,'null', 'none','None'):
                self.totalSkus = int(value)
            else:
                self.totalSkus = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('totalQty')
            if value not in (None,'null', 'none','None'):
                self.totalQty = int(value)
            else:
                self.totalQty = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('totalInv')
            if value not in (None,'null', 'none','None'):
                self.totalInv = str(value)
            else:
                self.totalInv = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('totalWt')
            if value not in (None,'null', 'none','None'):
                self.totalWt = str(value)
            else:
                self.totalWt = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'totalSkus': self.totalSkus,
            'totalQty': self.totalQty,
            'totalInv': self.totalInv,
            'totalWt': self.totalWt,
        }

@dataclass(slots=True)
class CheckExpiredReq:
    '''
    '''
    # Qty
    qty: int
    # Total WT
    totalWt: str
    # Unit $
    unitPrice: str
    # Arrival Cost
    arrivalCost: str
    # Expire Date
    expireDate: str
    # Pack Date
    packDate: str
    # Note
    note: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('qty')
            if value not in (None,'null', 'none','None'):
                self.qty = int(value)
            else:
                self.qty = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('totalWt')
            if value not in (None,'null', 'none','None'):
                self.totalWt = str(value)
            else:
                self.totalWt = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('unitPrice')
            if value not in (None,'null', 'none','None'):
                self.unitPrice = str(value)
            else:
                self.unitPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('arrivalCost')
            if value not in (None,'null', 'none','None'):
                self.arrivalCost = str(value)
            else:
                self.arrivalCost = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('expireDate')
            if value not in (None,'null', 'none','None'):
                self.expireDate = str(value)
            else:
                self.expireDate = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packDate')
            if value not in (None,'null', 'none','None'):
                self.packDate = str(value)
            else:
                self.packDate = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('note')
            if value not in (None,'null', 'none','None'):
                self.note = str(value)
            else:
                self.note = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.qty), [('gt', 0),])
        if err is not None:
            return err
        _, err = verify(str(self.totalWt), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.unitPrice), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.arrivalCost), [('required', True),])
        if err is not None:
            return err
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'qty': self.qty,
            'totalWt': self.totalWt,
            'unitPrice': self.unitPrice,
            'arrivalCost': self.arrivalCost,
            'expireDate': self.expireDate,
            'packDate': self.packDate,
            'note': self.note,
        }

@dataclass(slots=True)
class CheckExpiredResp:
    '''
    '''
    
    def __init__(self, data: dict):
        if data == None:
            return None

    def valid(self):
        '''check object is valid'''
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
        }

@dataclass(slots=True)
class GetInstockReq:
    '''
    '''
    # Inventory ID
    inventoryId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('inventoryId')
            if value not in (None,'null', 'none','None'):
                self.inventoryId = int(value)
            else:
                self.inventoryId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.inventoryId), [('gt', 0),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'inventoryId': self.inventoryId,
        }

@dataclass(slots=True)
class GetInstockResp:
    '''
    '''
    # Ref No.
    refNo: str
    # Presale
    presale: int
    # In Stock
    inStock: int
    # Purchased
    purchased: int
    # Batch List
    batchList: list[BatchInfo]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('refNo')
            if value not in (None,'null', 'none','None'):
                self.refNo = str(value)
            else:
                self.refNo = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('presale')
            if value not in (None,'null', 'none','None'):
                self.presale = int(value)
            else:
                self.presale = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('inStock')
            if value not in (None,'null', 'none','None'):
                self.inStock = int(value)
            else:
                self.inStock = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('purchased')
            if value not in (None,'null', 'none','None'):
                self.purchased = int(value)
            else:
                self.purchased = None
        except Exception as e:
            raise e
        
        self.batchList = list(map(lambda x: BatchInfo(x), data.get('batchList') if data.get('batchList') else []))

    def valid(self):
        '''check object is valid'''
        
        
        
        
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'refNo': self.refNo,
            'presale': self.presale,
            'inStock': self.inStock,
            'purchased': self.purchased,
            'batchList': _dump_value(self.batchList),
        }

@dataclass(slots=True)
class GetPresalesReq:
    '''
    '''
    # Inventory ID
    inventoryId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('inventoryId')
            if value not in (None,'null', 'none','None'):
                self.inventoryId = int(value)
            else:
                self.inventoryId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.inventoryId), [('gt', 0),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'inventoryId': self.inventoryId,
        }

@dataclass(slots=True)
class PresaleInfo:
    '''
    '''
    # SO No.
    soNo: str
    # Qty
    qty: int
    # Unit $
    unitPrice: str
    # Customer
    customer: str
    # ETD
    etd: str
    # Created
    created: str
    # Note
    note: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('soNo')
            if value not in (None,'null', 'none','None'):
                self.soNo = str(value)
            else:
                self.soNo = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('qty')
            if value not in (None,'null', 'none','None'):
                self.qty = int(value)
            else:
                self.qty = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('unitPrice')
            if value not in (None,'null', 'none','None'):
                self.unitPrice = str(value)
            else:
                self.unitPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('customer')
            if value not in (None,'null', 'none','None'):
                self.customer = str(value)
            else:
                self.customer = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('etd')
            if value not in (None,'null', 'none','None'):
                self.etd = str(value)
            else:
                self.etd = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('created')
            if value not in (None,'null', 'none','None'):
                self.created = str(value)
            else:
                self.created = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('note')
            if value not in (None,'null', 'none','None'):
                self.note = str(value)
            else:
                self.note = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'soNo': self.soNo,
            'qty': self.qty,
            'unitPrice': self.unitPrice,
            'customer': self.customer,
            'etd': self.etd,
            'created': self.created,
            'note': self.note,
        }

@dataclass(slots=True)
class GetPresalesResp:
    '''
    '''
    # presales
    presales: list[PresaleInfo]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.presales = list(map(lambda x: PresaleInfo(x), data.get('presales') if data.get('presales') else []))

    def valid(self):
        '''check object is valid'''
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'presales': _dump_value(self.presales),
        }

@dataclass(slots=True)
class GetPurchasedListReq:
    '''
    '''
    # Inventory ID
    inventoryId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('inventoryId')
            if value not in (None,'null', 'none','None'):
                self.inventoryId = int(value)
            else:
                self.inventoryId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.inventoryId), [('gt', 0),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'inventoryId': self.inventoryId,
        }

@dataclass(slots=True)
class PurchasedInfo:
    '''
    '''
    # PO No.
    poNo: str
    # Qty
    qty: int
    # Unit $
    unitPrice: str
    # Vendor
    vendor: str
    # ETA
    eta: str
    # Created
    created: str
    # Note
    note: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('poNo')
            if value not in (None,'null', 'none','None'):
                self.poNo = str(value)
            else:
                self.poNo = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('qty')
            if value not in (None,'null', 'none','None'):
                self.qty = int(value)
            else:
                self.qty = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('unitPrice')
            if value not in (None,'null', 'none','None'):
                self.unitPrice = str(value)
            else:
                self.unitPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('vendor')
            if value not in (None,'null', 'none','None'):
                self.vendor = str(value)
            else:
                self.vendor = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('eta')
            if value not in (None,'null', 'none','None'):
                self.eta = str(value)
            else:
                self.eta = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('created')
            if value not in (None,'null', 'none','None'):
                self.created = str(value)
            else:
                self.created = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('note')
            if value not in (None,'null', 'none','None'):
                self.note = str(value)
            else:
                self.note = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'poNo': self.poNo,
            'qty': self.qty,
            'unitPrice': self.unitPrice,
            'vendor': self.vendor,
            'eta': self.eta,
            'created': self.created,
            'note': self.note,
        }

@dataclass(slots=True)
class GetPurchasedListResp:
    '''
    '''
    # purchased
    purchased: list[PurchasedInfo]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.purchased = list(map(lambda x: PurchasedInfo(x), data.get('purchased') if data.get('purchased') else []))

    def valid(self):
        '''check object is valid'''
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'purchased': _dump_value(self.purchased),
        }

@dataclass(slots=True)
class UpdateProductData:
    '''
    '''
    # ProductId
    productId: int
    # Quantity
    quantity: int
    # BatchId
    batchId: int
    #Location
    location: int
    # Weight 
    weight: float
    # ProductType
    productType: str
    # UnitPrice
    unitPrice: float
    # ArrivalCost
    arrivalCost: float
    # ExpireDate
    expireDate: str
    # PackDate
    packDate: str
    # Note
    note: str
    # Purchase_Invoice_Line_Id
    purchase_invoice_line_id: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('productId')
            if value not in (None,'null', 'none','None'):
                self.productId = int(value)
            else:
                self.productId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('quantity')
            if value not in (None,'null', 'none','None'):
                self.quantity = int(value)
            else:
                self.quantity = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('batchId')
            if value not in (None,'null', 'none','None'):
                self.batchId = int(value)
            else:
                self.batchId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('location')
            if value not in (None,'null', 'none','None'):
                self.location = int(value)
            else:
                self.location = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('weight')
            if value not in (None,'null', 'none','None'):
                self.weight = float(value)
            else:
                self.weight = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productType')
            if value not in (None,'null', 'none','None'):
                self.productType = str(value)
            else:
                self.productType = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('unitPrice')
            if value not in (None,'null', 'none','None'):
                self.unitPrice = float(value)
            else:
                self.unitPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('arrivalCost')
            if value not in (None,'null', 'none','None'):
                self.arrivalCost = float(value)
            else:
                self.arrivalCost = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('expireDate')
            if value not in (None,'null', 'none','None'):
                self.expireDate = str(value)
            else:
                self.expireDate = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packDate')
            if value not in (None,'null', 'none','None'):
                self.packDate = str(value)
            else:
                self.packDate = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('note')
            if value not in (None,'null', 'none','None'):
                self.note = str(value)
            else:
                self.note = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('purchase_invoice_line_id')
            if value not in (None,'null', 'none','None'):
                self.purchase_invoice_line_id = int(value)
            else:
                self.purchase_invoice_line_id = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.productId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.quantity), [('gt', 0),('required', True),])
        if err is not None:
            return err
        
        
        
        _, err = verify(str(self.productType), [('required', True),])
        if err is not None:
            return err
        
        
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'productId': self.productId,
            'quantity': self.quantity,
            'batchId': self.batchId,
            'location': self.location,
            'weight': self.weight,
            'productType': self.productType,
            'unitPrice': self.unitPrice,
            'arrivalCost': self.arrivalCost,
            'expireDate': self.expireDate,
            'packDate': self.packDate,
            'note': self.note,
            'purchase_invoice_line_id': self.purchase_invoice_line_id,
        }

@dataclass(slots=True)
class UpdateBatchData:
    '''
    '''
    # BatchId
    batchId: int
    # Quantity
    quantity: int
    # Weight 
    weight: float
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('batchId')
            if value not in (None,'null', 'none','None'):
                self.batchId = int(value)
            else:
                self.batchId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('quantity')
            if value not in (None,'null', 'none','None'):
                self.quantity = int(value)
            else:
                self.quantity = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('weight')
            if value not in (None,'null', 'none','None'):
                self.weight = float(value)
            else:
                self.weight = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'batchId': self.batchId,
            'quantity': self.quantity,
            'weight': self.weight,
        }

@dataclass(slots=True)
class UpdateProductData2:
    '''
    '''
    # LineId
    lineId: int
    # ProductId
    productId: int
    # Quantity
    quantity: int
    # Weight
    weight: float
    # ProductType
    productType: str
    # Batches
    batches: list[UpdateBatchData]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('lineId')
            if value not in (None,'null', 'none','None'):
                self.lineId = int(value)
            else:
                self.lineId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productId')
            if value not in (None,'null', 'none','None'):
                self.productId = int(value)
            else:
                self.productId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('quantity')
            if value not in (None,'null', 'none','None'):
                self.quantity = int(value)
            else:
                self.quantity = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('weight')
            if value not in (None,'null', 'none','None'):
                self.weight = float(value)
            else:
                self.weight = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productType')
            if value not in (None,'null', 'none','None'):
                self.productType = str(value)
            else:
                self.productType = None
        except Exception as e:
            raise e
        
        self.batches = list(map(lambda x: UpdateBatchData(x), data.get('batches') if data.get('batches') else []))

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.lineId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.productId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.quantity), [('gt', 0),('equired', True),])
        if err is not None:
            return err
        _, err = verify(float(self.weight), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.productType), [('required', True),])
        if err is not None:
            return err
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'lineId': self.lineId,
            'productId': self.productId,
            'quantity': self.quantity,
            'weight': self.weight,
            'productType': self.productType,
            'batches': _dump_value(self.batches),
        }

@dataclass(slots=True)
class UpdateInventoryReq:
    '''
    '''
    # CompanyId
    companyId: int
    # WarehouseId
    warehouseId: int
    # ProductList
    productList: list[UpdateProductData]
    # Appoint
    isAppointBatch: bool
    # Calculation Method
    calculationMethod: MethodStatus
    # OrderNum
    orderNum: str
    # Request Method
    requestMethod: RequestStatus
    # Module
    module: ModuleStatus
    # Purchaseed
    purchased: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('warehouseId')
            if value not in (None,'null', 'none','None'):
                self.warehouseId = int(value)
            else:
                self.warehouseId = None
        except Exception as e:
            raise e
        
        self.productList = list(map(lambda x: UpdateProductData(x), data.get('productList') if data.get('productList') else []))
        try:
            value = data.get('isAppointBatch')
            if value not in (None,'null', 'none','None'):
                self.isAppointBatch = bool(value)
            else:
                self.isAppointBatch = None
        except Exception as e:
            raise e
        
        self.calculationMethod = MethodStatus(data.get('calculationMethod'))
        try:
            value = data.get('orderNum')
            if value not in (None,'null', 'none','None'):
                self.orderNum = str(value)
            else:
                self.orderNum = None
        except Exception as e:
            raise e
        
        self.requestMethod = RequestStatus(data.get('requestMethod'))
        self.module = ModuleStatus(data.get('module'))
        try:
            value = data.get('purchased')
            if value not in (None,'null', 'none','None'):
                self.purchased = str(value)
            else:
                self.purchased = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.companyId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.warehouseId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        # TODO valid list
        
        err = self.calculationMethod.valid()
        if err is not None:
            return err
        _, err = verify(str(self.orderNum), [('required', True),])
        if err is not None:
            return err
        err = self.requestMethod.valid()
        if err is not None:
            return err
        err = self.module.valid()
        if err is not None:
            return err
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'companyId': self.companyId,
            'warehouseId': self.warehouseId,
            'productList': _dump_value(self.productList),
            'isAppointBatch': self.isAppointBatch,
            'calculationMethod': self.calculationMethod.value,
            'orderNum': self.orderNum,
            'requestMethod': self.requestMethod.value,
            'module': self.module.value,
            'purchased': self.purchased,
        }

@dataclass(slots=True)
class UpdateInventory2Req:
    '''
    '''
    # CompanyId
    companyId: int
    # WarehouseId
    warehouseId: int
    # ProductList
    productList: list[UpdateProductData2]
    # Appoint
    isAppointBatch: bool
    # Calculation Method
    calculationMethod: MethodStatus
    # OrderNum
    orderNum: str
    # Request Method
    requestMethod: RequestStatus
    # Module
    module: ModuleStatus
    # Purchaseed
    purchased: str
    # PreSales
    presale: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('warehouseId')
            if value not in (None,'null', 'none','None'):
                self.warehouseId = int(value)
            else:
                self.warehouseId = None
        except Exception as e:
            raise e
        
        self.productList = list(map(lambda x: UpdateProductData2(x), data.get('productList') if data.get('productList') else []))
        try:
            value = data.get('isAppointBatch')
            if value not in (None,'null', 'none','None'):
                self.isAppointBatch = bool(value)
            else:
                self.isAppointBatch = None
        except Exception as e:
            raise e
        
        self.calculationMethod = MethodStatus(data.get('calculationMethod'))
        try:
            value = data.get('orderNum')
            if value not in (None,'null', 'none','None'):
                self.orderNum = str(value)
            else:
                self.orderNum = None
        except Exception as e:
            raise e
        
        self.requestMethod = RequestStatus(data.get('requestMethod'))
        self.module = ModuleStatus(data.get('module'))
        try:
            value = data.get('purchased')
            if value not in (None,'null', 'none','None'):
                self.purchased = str(value)
            else:
                self.purchased = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('presale')
            if value not in (None,'null', 'none','None'):
                self.presale = str(value)
            else:
                self.presale = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.companyId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.warehouseId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        # TODO valid list
        
        err = self.calculationMethod.valid()
        if err is not None:
            return err
        _, err = verify(str(self.orderNum), [('required', True),])
        if err is not None:
            return err
        err = self.requestMethod.valid()
        if err is not None:
            return err
        err = self.module.valid()
        if err is not None:
            return err
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'companyId': self.companyId,
            'warehouseId': self.warehouseId,
            'productList': _dump_value(self.productList),
            'isAppointBatch': self.isAppointBatch,
            'calculationMethod': self.calculationMethod.value,
            'orderNum': self.orderNum,
            'requestMethod': self.requestMethod.value,
            'module': self.module.value,
            'purchased': self.purchased,
            'presale': self.presale,
        }

@dataclass(slots=True)
class UpdatePurchasedReq:
    '''
    '''
    # WarehouseId
    warehouseId: int
    # Purchaseed
    purchased: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('warehouseId')
            if value not in (None,'null', 'none','None'):
                self.warehouseId = int(value)
            else:
                self.warehouseId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('purchased')
            if value not in (None,'null', 'none','None'):
                self.purchased = str(value)
            else:
                self.purchased = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.warehouseId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.purchased), [('required', True),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'warehouseId': self.warehouseId,
            'purchased': self.purchased,
        }

@dataclass(slots=True)
class UpdatePresaleReq:
    '''
    '''
    # WarehouseId
    warehouseId: int
    # Presale
    presale: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('warehouseId')
            if value not in (None,'null', 'none','None'):
                self.warehouseId = int(value)
            else:
                self.warehouseId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('presale')
            if value not in (None,'null', 'none','None'):
                self.presale = str(value)
            else:
                self.presale = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.warehouseId), [('gt', 0),('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.presale), [('required', True),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'warehouseId': self.warehouseId,
            'presale': self.presale,
        }

@dataclass(slots=True)
class GetBatchReq:
    '''
    '''
    # PurchaseInvoiceLineId
    purchaseInvoiceLineId: list[int]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.purchaseInvoiceLineId = list(map(lambda x: int(x), data.get('purchaseInvoiceLineId') if data.get('purchaseInvoiceLineId') else []))

    def valid(self):
        '''check object is valid'''
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'purchaseInvoiceLineId': _dump_value(self.purchaseInvoiceLineId),
        }

@dataclass(slots=True)
class GetBatchResp:
    '''
    '''
    # PurchaseInvoiceLineIdMapBatchId
    purchaseInvoiceLineIdMapBatchId: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('purchaseInvoiceLineIdMapBatchId')
            if value not in (None,'null', 'none','None'):
                self.purchaseInvoiceLineIdMapBatchId = str(value)
            else:
                self.purchaseInvoiceLineIdMapBatchId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'purchaseInvoiceLineIdMapBatchId': self.purchaseInvoiceLineIdMapBatchId,
        }

@dataclass(slots=True)
class UpdateInventoryResp:
    '''
    '''
    # success: true, fail: false
    ok: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ok')
            if value not in (None,'null', 'none','None'):
                self.ok = bool(value)
            else:
                self.ok = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ok': self.ok,
        }

@dataclass(slots=True)
class UpdateInventory2Resp:
    '''
    '''
    # ListData
    list: list[UpdateProductData2]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.list = list(map(lambda x: UpdateProductData2(x), data.get('list') if data.get('list') else []))

    def valid(self):
        '''check object is valid'''
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'list': _dump_value(self.list),
        }
