# coding=utf-8
# DO NOT EDIT! This code is generated by truckxi-api.

import httpx
import json

from .proto import *

class scm_center_authentication(object):

    def __init__(self, appname: str, addr: str, timeout: float = 0.5, token: str = ''):
        """
        :param appname: 发起请求方的微服务的名称, 将被写入到Header中发送给被请求的服务方
        :param addr: 被请求的服务地址, 格式为 "http://{ip}:{port}", 也可以是服务域名
        :param timeout: 超时时间, float型, 单位为秒
        :param token: 认证token
        """
        self.timeout = timeout
        self.appname = appname
        self.addr = addr
        self.token = token
        self.headers = {"X-SRC-APP": appname}
        
        limits = httpx.Limits(max_keepalive_connections=20, max_connections=100, keepalive_expiry=5)  # 一些附加限制
        self.client = httpx.AsyncClient(limits=limits, base_url=addr, timeout=timeout)  # 内网服务, 超时时间为0.1秒

    async def _check_alive(self):
        """
        通过API来检测服务可用性
        
        :param client: httpx.AsyncClient实例
        :return: 服务是否可用
        """
        api = '/api/server/api_keepalive'
        resp = await self.client.get(api)
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return True
            else:
                return False
        return False

    async def create_sales_order(self, req: CreateSalesOrderReq, headerOpts: dict = {}) -> CreateSalesOrderResp:
        """
         Create SalesOrder 弃用
        """
        api = "/api/center/sales/create"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def update_sales_order(self, req: UpdateSalesOrderReq, headerOpts: dict = {}) -> CreateSalesOrderResp:
        """
         Create SalesOrder or Update SalesOrder
        """
        api = "/api/center/sales/update"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def groups_and_categories(self, req: GetGroupsAndCategoriesReq, headerOpts: dict = {}) -> GetGroupsAndCategoriesResp:
        """
         Get Groups And Categories
        """
        api = "/api/center/product/groups_and_categories"
        headers = self.headers.copy()
        try:
            resp = await self.client.get(api, params=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def product_list(self, req: GetProductListReq, headerOpts: dict = {}) -> GetProductListResp:
        """
         Get Products
        """
        api = "/api/center/product/list"
        headers = self.headers.copy()
        try:
            resp = await self.client.get(api, params=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def get_product_by_id(self, req: GetProductByIdReq, headerOpts: dict = {}) -> GetProductByIdResp:
        """
         Get Product
        """
        api = "/api/center/product/get_by_id"
        headers = self.headers.copy()
        try:
            resp = await self.client.get(api, params=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def get_ref_num_by_ids(self, req: GetRefNumByIdReq, headerOpts: dict = {}) -> GetRefNumByIdResp:
        """
         Get RefNum by Ids
        """
        api = "/api/center/product/get_ref_num_by_ids"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def crontab_sales_order(self, req: ScheduledTasksReq, headerOpts: dict = {}) -> ScheduledTasksResp:
        """
         Crontab
        """
        api = "/api/center/crontab/create"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def sync_scm_product_to_center_product(self, req: SycnScmProductToCenterProductReq, headerOpts: dict = {}) -> SycnScmProductToCenterProductResp:
        """
         Sync Product
        """
        api = "/api/center/crontab/sync_scm_product_to_center_product"
        headers = self.headers.copy()
        headers['Content-Type'] = 'application/json'
        try:
            resp = await self.client.post(api, json=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}

    async def get_company(self, req: GetCompanyReq, headerOpts: dict = {}) -> GetCompanyResp:
        """
         Get Company
        """
        api = "/api/center/authentication/get"
        headers = self.headers.copy()
        try:
            resp = await self.client.get(api, params=req.dump_(), headers={**headers, **headerOpts})
        except httpx.ReadTimeout:
            return 'request timeout'
        if resp.status_code == 200:
            json_data = resp.json()
            code = json_data.get('code')
            if code == 200000:
                return resp.json()
            elif code == 400:
                return resp.json()
            else:
                return {}

        return {}
