from __future__ import annotations
# DO NOT EDIT! This code is generated by truckxi-api.

from dataclasses import dataclass
from .verify import verify
from datetime import datetime

def _dump_value(v):
    if isinstance(v, (list, tuple)):
        return list(map(_dump_value, v))
    if isinstance(v, dict):
        return {k:_dump_value(v) for k, v in v.items()}
    if isinstance(v, Enum):
        return v.value
    if hasattr(v, 'dump_'):
        return v.dump_()
    if isinstance(v, datetime):
        return v.isoformat()
    return v

class Enum:
    def __init__(self, value):
        self.value = value
    def __str__(self):
        return str(self.value)
    def __repr__(self):
        return str(self.value)


class Status(Enum):
    '''
    status
    '''
    # Open
    Open = "Open"
    # Close
    Close = "Close"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "Open": True,
            "Close": True,
            
        }
        if d.get(self.value) is None:
            return ValueError('Invalid value for Status: %s' % self.value)
        return None

class BusinessType(Enum):
    '''
    Business
    '''
    # Retail
    Retail = "Retail"
    # WholeSale
    WholeSale = "WholeSale"
    # ECOM
    ECOM = "ECOM"
    # Restaurant
    Restaurant = "Restaurant"
    # Supermarket
    Supermarket = "Supermarket"
    # Other
    Other = "Other"
    
    def __init__(self, value):
        self.value = value
    def valid(self):
        d = {
            "Retail": True,
            "WholeSale": True,
            "ECOM": True,
            "Restaurant": True,
            "Supermarket": True,
            "Other": True,
            
        }
        if d.get(self.value) is None:
            return ValueError('Invalid value for BusinessType: %s' % self.value)
        return None

@dataclass(slots=True)
class Ok:
    '''
    '''
    # success: true, fail: false
    ok: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ok')
            if value not in (None,'null', 'none','None'):
                self.ok = bool(value)
            else:
                self.ok = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ok': self.ok,
        }

@dataclass(slots=True)
class CenterProductLine:
    '''
    '''
    # ProductId
    productId: int
    # Quantity
    quantity: int
    # Weight
    weight: float
    # UnitPrice
    unitPrice: str
    # Subtotal
    subtotal: str
    # Notation
    notation: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('productId')
            if value not in (None,'null', 'none','None'):
                self.productId = int(value)
            else:
                self.productId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('quantity')
            if value not in (None,'null', 'none','None'):
                self.quantity = int(value)
            else:
                self.quantity = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('weight')
            if value not in (None,'null', 'none','None'):
                self.weight = float(value)
            else:
                self.weight = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('unitPrice')
            if value not in (None,'null', 'none','None'):
                self.unitPrice = str(value)
            else:
                self.unitPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('subtotal')
            if value not in (None,'null', 'none','None'):
                self.subtotal = str(value)
            else:
                self.subtotal = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('notation')
            if value not in (None,'null', 'none','None'):
                self.notation = str(value)
            else:
                self.notation = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.productId), [('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.quantity), [('required', True),])
        if err is not None:
            return err
        _, err = verify(float(self.weight), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.unitPrice), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.subtotal), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.notation), [('required', True),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'productId': self.productId,
            'quantity': self.quantity,
            'weight': self.weight,
            'unitPrice': self.unitPrice,
            'subtotal': self.subtotal,
            'notation': self.notation,
        }

@dataclass(slots=True)
class CreateSalesOrderReq:
    '''
    '''
    # RequestMethod 通过此字段判断是走创建逻辑还是走编辑逻辑
    requestMethod: str
    # SynDirection 通过此字段知道是那个方向同步过来的
    synDirection: str
    # CompanyId app端公司id，用于同步到scm的时候找到哪个customer下
    companyId: int
    # Ascription_company_id数据中心的公司id
    ascription_company_id: int
    # ScmCompanyId
    scmCompanyId: int
    # ScmCompanyCode
    companyCode: str
    # PurchaseOrderId app端的po_id
    purchaseOrderId: int
    # scmSalesOrderId scm端的so_id
    scmSalesOrderId: int
    # OrderStatus
    orderStatus: str
    # TotalPrice
    totalPrice: str
    # FinalPrice
    finalPrice: str
    # GrandPrice
    grandPrice: str
    # PostDatetime
    postDatetime: str
    # EtaDatetime
    etaDatetime: str
    # Note
    note: str
    # Lines
    lines: list[CenterProductLine]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('requestMethod')
            if value not in (None,'null', 'none','None'):
                self.requestMethod = str(value)
            else:
                self.requestMethod = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('synDirection')
            if value not in (None,'null', 'none','None'):
                self.synDirection = str(value)
            else:
                self.synDirection = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('ascription_company_id')
            if value not in (None,'null', 'none','None'):
                self.ascription_company_id = int(value)
            else:
                self.ascription_company_id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('scmCompanyId')
            if value not in (None,'null', 'none','None'):
                self.scmCompanyId = int(value)
            else:
                self.scmCompanyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('companyCode')
            if value not in (None,'null', 'none','None'):
                self.companyCode = str(value)
            else:
                self.companyCode = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('purchaseOrderId')
            if value not in (None,'null', 'none','None'):
                self.purchaseOrderId = int(value)
            else:
                self.purchaseOrderId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('scmSalesOrderId')
            if value not in (None,'null', 'none','None'):
                self.scmSalesOrderId = int(value)
            else:
                self.scmSalesOrderId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('orderStatus')
            if value not in (None,'null', 'none','None'):
                self.orderStatus = str(value)
            else:
                self.orderStatus = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('totalPrice')
            if value not in (None,'null', 'none','None'):
                self.totalPrice = str(value)
            else:
                self.totalPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('finalPrice')
            if value not in (None,'null', 'none','None'):
                self.finalPrice = str(value)
            else:
                self.finalPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('grandPrice')
            if value not in (None,'null', 'none','None'):
                self.grandPrice = str(value)
            else:
                self.grandPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('postDatetime')
            if value not in (None,'null', 'none','None'):
                self.postDatetime = str(value)
            else:
                self.postDatetime = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('etaDatetime')
            if value not in (None,'null', 'none','None'):
                self.etaDatetime = str(value)
            else:
                self.etaDatetime = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('note')
            if value not in (None,'null', 'none','None'):
                self.note = str(value)
            else:
                self.note = None
        except Exception as e:
            raise e
        
        self.lines = list(map(lambda x: CenterProductLine(x), data.get('lines') if data.get('lines') else []))

    def valid(self):
        '''check object is valid'''
        _, err = verify(str(self.requestMethod), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.synDirection), [('required', True),])
        if err is not None:
            return err
        
        
        
        
        
        
        _, err = verify(str(self.orderStatus), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.totalPrice), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.finalPrice), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.grandPrice), [('required', True),])
        if err is not None:
            return err
        
        
        
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'requestMethod': self.requestMethod,
            'synDirection': self.synDirection,
            'companyId': self.companyId,
            'ascription_company_id': self.ascription_company_id,
            'scmCompanyId': self.scmCompanyId,
            'companyCode': self.companyCode,
            'purchaseOrderId': self.purchaseOrderId,
            'scmSalesOrderId': self.scmSalesOrderId,
            'orderStatus': self.orderStatus,
            'totalPrice': self.totalPrice,
            'finalPrice': self.finalPrice,
            'grandPrice': self.grandPrice,
            'postDatetime': self.postDatetime,
            'etaDatetime': self.etaDatetime,
            'note': self.note,
            'lines': _dump_value(self.lines),
        }

@dataclass(slots=True)
class UpdateSalesOrderReq:
    '''
    '''
    # RequestMethod 通过此字段判断是走创建逻辑还是走编辑逻辑
    requestMethod: str
    # SynDirection 通过此字段知道是那个方向同步过来的
    synDirection: str
    # CompanyId app端公司id，用于同步到scm的时候找到哪个customer下
    companyId: int
    # Ascription_company_id数据中心的公司id
    ascription_company_id: int
    # ScmCompanyId
    scmCompanyId: int
    # ScmCompanyCode
    companyCode: str
    # PurchaseOrderId app端的po_id
    purchaseOrderId: int
    # scmSalesOrderId scm端的so_id
    scmSalesOrderId: int
    # OrderStatus
    orderStatus: str
    # TotalPrice
    totalPrice: str
    # FinalPrice
    finalPrice: str
    # GrandPrice
    grandPrice: str
    # PostDatetime
    postDatetime: str
    # EtaDatetime
    etaDatetime: str
    # Note
    note: str
    # Lines
    lines: list[CenterProductLine]
    # Id
    id: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('requestMethod')
            if value not in (None,'null', 'none','None'):
                self.requestMethod = str(value)
            else:
                self.requestMethod = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('synDirection')
            if value not in (None,'null', 'none','None'):
                self.synDirection = str(value)
            else:
                self.synDirection = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('ascription_company_id')
            if value not in (None,'null', 'none','None'):
                self.ascription_company_id = int(value)
            else:
                self.ascription_company_id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('scmCompanyId')
            if value not in (None,'null', 'none','None'):
                self.scmCompanyId = int(value)
            else:
                self.scmCompanyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('companyCode')
            if value not in (None,'null', 'none','None'):
                self.companyCode = str(value)
            else:
                self.companyCode = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('purchaseOrderId')
            if value not in (None,'null', 'none','None'):
                self.purchaseOrderId = int(value)
            else:
                self.purchaseOrderId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('scmSalesOrderId')
            if value not in (None,'null', 'none','None'):
                self.scmSalesOrderId = int(value)
            else:
                self.scmSalesOrderId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('orderStatus')
            if value not in (None,'null', 'none','None'):
                self.orderStatus = str(value)
            else:
                self.orderStatus = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('totalPrice')
            if value not in (None,'null', 'none','None'):
                self.totalPrice = str(value)
            else:
                self.totalPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('finalPrice')
            if value not in (None,'null', 'none','None'):
                self.finalPrice = str(value)
            else:
                self.finalPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('grandPrice')
            if value not in (None,'null', 'none','None'):
                self.grandPrice = str(value)
            else:
                self.grandPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('postDatetime')
            if value not in (None,'null', 'none','None'):
                self.postDatetime = str(value)
            else:
                self.postDatetime = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('etaDatetime')
            if value not in (None,'null', 'none','None'):
                self.etaDatetime = str(value)
            else:
                self.etaDatetime = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('note')
            if value not in (None,'null', 'none','None'):
                self.note = str(value)
            else:
                self.note = None
        except Exception as e:
            raise e
        
        self.lines = list(map(lambda x: CenterProductLine(x), data.get('lines') if data.get('lines') else []))
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(str(self.requestMethod), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.synDirection), [('required', True),])
        if err is not None:
            return err
        
        
        
        
        
        
        _, err = verify(str(self.orderStatus), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.totalPrice), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.finalPrice), [('required', True),])
        if err is not None:
            return err
        _, err = verify(str(self.grandPrice), [('required', True),])
        if err is not None:
            return err
        
        
        
        # TODO valid list
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'requestMethod': self.requestMethod,
            'synDirection': self.synDirection,
            'companyId': self.companyId,
            'ascription_company_id': self.ascription_company_id,
            'scmCompanyId': self.scmCompanyId,
            'companyCode': self.companyCode,
            'purchaseOrderId': self.purchaseOrderId,
            'scmSalesOrderId': self.scmSalesOrderId,
            'orderStatus': self.orderStatus,
            'totalPrice': self.totalPrice,
            'finalPrice': self.finalPrice,
            'grandPrice': self.grandPrice,
            'postDatetime': self.postDatetime,
            'etaDatetime': self.etaDatetime,
            'note': self.note,
            'lines': _dump_value(self.lines),
            'id': self.id,
        }

@dataclass(slots=True)
class CreateSalesOrderResp:
    '''
    '''
    # Sales Order Id
    id: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
        }

@dataclass(slots=True)
class GetProductListReq:
    '''
    '''
    # CompanyId
    companyId: int
    # level
    level: int
    # GroupId 
    groupId: int
    # CategoryId
    categoryId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('level')
            if value not in (None,'null', 'none','None'):
                self.level = int(value)
            else:
                self.level = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('groupId')
            if value not in (None,'null', 'none','None'):
                self.groupId = int(value)
            else:
                self.groupId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('categoryId')
            if value not in (None,'null', 'none','None'):
                self.categoryId = int(value)
            else:
                self.categoryId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'companyId': self.companyId,
            'level': self.level,
            'groupId': self.groupId,
            'categoryId': self.categoryId,
        }

@dataclass(slots=True)
class GetProductByIdReq:
    '''
    '''
    # ProductId
    productId: int
    # Level
    level: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('productId')
            if value not in (None,'null', 'none','None'):
                self.productId = int(value)
            else:
                self.productId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('level')
            if value not in (None,'null', 'none','None'):
                self.level = int(value)
            else:
                self.level = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.productId), [('required', True),])
        if err is not None:
            return err
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'productId': self.productId,
            'level': self.level,
        }

@dataclass(slots=True)
class GetRefNumByIdReq:
    '''
    '''
    # IdsDict
    idsDict: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('idsDict')
            if value not in (None,'null', 'none','None'):
                self.idsDict = str(value)
            else:
                self.idsDict = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'idsDict': self.idsDict,
        }

@dataclass(slots=True)
class GetRefNumByIdResp:
    '''
    '''
    # IdsDict
    idsDict: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('idsDict')
            if value not in (None,'null', 'none','None'):
                self.idsDict = str(value)
            else:
                self.idsDict = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'idsDict': self.idsDict,
        }

@dataclass(slots=True)
class Product:
    '''
    '''
    # Id
    id: int
    # Name
    name: str
    # ProductNum
    productNum: str
    # RefNum
    refNum: str
    # GeneralNum
    generalNum: str
    # Product Price
    productPrice: float
    # thumbnail
    thumbnail: str
    # Instock
    instock: float
    # NetWeight
    netWeight: float
    # PackageType 
    packageType: str
    # ProductType
    productType: str
    # PackageSize
    packageSize: str
    # Specification
    specification: str
    # Dimension
    dimension: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productNum')
            if value not in (None,'null', 'none','None'):
                self.productNum = str(value)
            else:
                self.productNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('refNum')
            if value not in (None,'null', 'none','None'):
                self.refNum = str(value)
            else:
                self.refNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('generalNum')
            if value not in (None,'null', 'none','None'):
                self.generalNum = str(value)
            else:
                self.generalNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productPrice')
            if value not in (None,'null', 'none','None'):
                self.productPrice = float(value)
            else:
                self.productPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('thumbnail')
            if value not in (None,'null', 'none','None'):
                self.thumbnail = str(value)
            else:
                self.thumbnail = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('instock')
            if value not in (None,'null', 'none','None'):
                self.instock = float(value)
            else:
                self.instock = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('netWeight')
            if value not in (None,'null', 'none','None'):
                self.netWeight = float(value)
            else:
                self.netWeight = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packageType')
            if value not in (None,'null', 'none','None'):
                self.packageType = str(value)
            else:
                self.packageType = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productType')
            if value not in (None,'null', 'none','None'):
                self.productType = str(value)
            else:
                self.productType = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packageSize')
            if value not in (None,'null', 'none','None'):
                self.packageSize = str(value)
            else:
                self.packageSize = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('specification')
            if value not in (None,'null', 'none','None'):
                self.specification = str(value)
            else:
                self.specification = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('dimension')
            if value not in (None,'null', 'none','None'):
                self.dimension = str(value)
            else:
                self.dimension = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'name': self.name,
            'productNum': self.productNum,
            'refNum': self.refNum,
            'generalNum': self.generalNum,
            'productPrice': self.productPrice,
            'thumbnail': self.thumbnail,
            'instock': self.instock,
            'netWeight': self.netWeight,
            'packageType': self.packageType,
            'productType': self.productType,
            'packageSize': self.packageSize,
            'specification': self.specification,
            'dimension': self.dimension,
        }

@dataclass(slots=True)
class GetProductListResp:
    '''
    '''
    # Product List
    products: list[Product]
    
    def __init__(self, data: dict):
        if data == None:
            return None
        self.products = list(map(lambda x: Product(x), data.get('products') if data.get('products') else []))

    def valid(self):
        '''check object is valid'''
        # TODO valid list
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'products': _dump_value(self.products),
        }

@dataclass(slots=True)
class GetProductByIdResp:
    '''
    '''
    # Id
    id: int
    # Name
    name: str
    # ProductNum
    productNum: str
    # RefNum
    refNum: str
    # GeneralNum
    generalNum: str
    # Product Price
    productPrice: float
    # thumbnail
    thumbnail: str
    # Instock
    instock: float
    # NetWeight
    netWeight: float
    # PackageType 
    packageType: str
    # ProductType
    productType: str
    # PackageSize
    packageSize: str
    # Specification
    specification: str
    # Dimension
    dimension: str
    # GroupNum
    groupNum: str
    # CategoryNum
    categoryNum: str
    # GroupName
    groupName: str
    # CategoryName
    categoryName: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productNum')
            if value not in (None,'null', 'none','None'):
                self.productNum = str(value)
            else:
                self.productNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('refNum')
            if value not in (None,'null', 'none','None'):
                self.refNum = str(value)
            else:
                self.refNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('generalNum')
            if value not in (None,'null', 'none','None'):
                self.generalNum = str(value)
            else:
                self.generalNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productPrice')
            if value not in (None,'null', 'none','None'):
                self.productPrice = float(value)
            else:
                self.productPrice = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('thumbnail')
            if value not in (None,'null', 'none','None'):
                self.thumbnail = str(value)
            else:
                self.thumbnail = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('instock')
            if value not in (None,'null', 'none','None'):
                self.instock = float(value)
            else:
                self.instock = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('netWeight')
            if value not in (None,'null', 'none','None'):
                self.netWeight = float(value)
            else:
                self.netWeight = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packageType')
            if value not in (None,'null', 'none','None'):
                self.packageType = str(value)
            else:
                self.packageType = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('productType')
            if value not in (None,'null', 'none','None'):
                self.productType = str(value)
            else:
                self.productType = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('packageSize')
            if value not in (None,'null', 'none','None'):
                self.packageSize = str(value)
            else:
                self.packageSize = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('specification')
            if value not in (None,'null', 'none','None'):
                self.specification = str(value)
            else:
                self.specification = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('dimension')
            if value not in (None,'null', 'none','None'):
                self.dimension = str(value)
            else:
                self.dimension = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('groupNum')
            if value not in (None,'null', 'none','None'):
                self.groupNum = str(value)
            else:
                self.groupNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('categoryNum')
            if value not in (None,'null', 'none','None'):
                self.categoryNum = str(value)
            else:
                self.categoryNum = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('groupName')
            if value not in (None,'null', 'none','None'):
                self.groupName = str(value)
            else:
                self.groupName = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('categoryName')
            if value not in (None,'null', 'none','None'):
                self.categoryName = str(value)
            else:
                self.categoryName = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'name': self.name,
            'productNum': self.productNum,
            'refNum': self.refNum,
            'generalNum': self.generalNum,
            'productPrice': self.productPrice,
            'thumbnail': self.thumbnail,
            'instock': self.instock,
            'netWeight': self.netWeight,
            'packageType': self.packageType,
            'productType': self.productType,
            'packageSize': self.packageSize,
            'specification': self.specification,
            'dimension': self.dimension,
            'groupNum': self.groupNum,
            'categoryNum': self.categoryNum,
            'groupName': self.groupName,
            'categoryName': self.categoryName,
        }

@dataclass(slots=True)
class GetGroupsAndCategoriesReq:
    '''
    '''
    # CompanyId
    companyId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('companyId')
            if value not in (None,'null', 'none','None'):
                self.companyId = int(value)
            else:
                self.companyId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(int(self.companyId), [('required', True),('gt', 0),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'companyId': self.companyId,
        }

@dataclass(slots=True)
class GetGroupsAndCategoriesResp:
    '''
    '''
    # Categories
    groups_and_categories: str
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('groups_and_categories')
            if value not in (None,'null', 'none','None'):
                self.groups_and_categories = str(value)
            else:
                self.groups_and_categories = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'groups_and_categories': self.groups_and_categories,
        }

@dataclass(slots=True)
class ScheduledTasksReq:
    '''
    '''
    
    def __init__(self, data: dict):
        if data == None:
            return None

    def valid(self):
        '''check object is valid'''
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
        }

@dataclass(slots=True)
class ScheduledTasksResp:
    '''
    '''
    # success: true, fail: false
    ok: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ok')
            if value not in (None,'null', 'none','None'):
                self.ok = bool(value)
            else:
                self.ok = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ok': self.ok,
        }

@dataclass(slots=True)
class SycnScmProductToCenterProductReq:
    '''
    '''
    
    def __init__(self, data: dict):
        if data == None:
            return None

    def valid(self):
        '''check object is valid'''
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
        }

@dataclass(slots=True)
class SycnScmProductToCenterProductResp:
    '''
    '''
    # success: true, fail: false
    ok: bool
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('ok')
            if value not in (None,'null', 'none','None'):
                self.ok = bool(value)
            else:
                self.ok = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'ok': self.ok,
        }

@dataclass(slots=True)
class GetCompanyReq:
    '''
    '''
    # CompanyCode
    companyCode: str
    # CompanyId
    scm_companyId: int
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('companyCode')
            if value not in (None,'null', 'none','None'):
                self.companyCode = str(value)
            else:
                self.companyCode = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('scm_companyId')
            if value not in (None,'null', 'none','None'):
                self.scm_companyId = int(value)
            else:
                self.scm_companyId = None
        except Exception as e:
            raise e
        

    def valid(self):
        '''check object is valid'''
        _, err = verify(str(self.companyCode), [('required', True),])
        if err is not None:
            return err
        _, err = verify(int(self.scm_companyId), [('required', True),])
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'companyCode': self.companyCode,
            'scm_companyId': self.scm_companyId,
        }

@dataclass(slots=True)
class GetCompanyResp:
    '''
    '''
    # Id
    id: int
    # Scm_companyId
    scm_companyId: int
    # Name
    name: str
    # Email
    email: str
    # Contact
    contact: str
    # Phone 
    phone: str
    #CompanyCode
    companyCode: str
    # BusinessType
    businessType: BusinessType
    # State
    state: str
    # City
    city: str
    # Street
    street: str
    # Street2
    street2: str
    # Street3
    street3: str
    # Zip
    zip: str
    # Fax
    fax: str
    # Logo Name
    logo_name: str
    # Logo Url
    logo_url: str
    # Status
    status: Status
    
    def __init__(self, data: dict):
        if data == None:
            return None
        try:
            value = data.get('id')
            if value not in (None,'null', 'none','None'):
                self.id = int(value)
            else:
                self.id = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('scm_companyId')
            if value not in (None,'null', 'none','None'):
                self.scm_companyId = int(value)
            else:
                self.scm_companyId = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('name')
            if value not in (None,'null', 'none','None'):
                self.name = str(value)
            else:
                self.name = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('email')
            if value not in (None,'null', 'none','None'):
                self.email = str(value)
            else:
                self.email = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('contact')
            if value not in (None,'null', 'none','None'):
                self.contact = str(value)
            else:
                self.contact = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('phone')
            if value not in (None,'null', 'none','None'):
                self.phone = str(value)
            else:
                self.phone = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('companyCode')
            if value not in (None,'null', 'none','None'):
                self.companyCode = str(value)
            else:
                self.companyCode = None
        except Exception as e:
            raise e
        
        self.businessType = BusinessType(data.get('businessType'))
        try:
            value = data.get('state')
            if value not in (None,'null', 'none','None'):
                self.state = str(value)
            else:
                self.state = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('city')
            if value not in (None,'null', 'none','None'):
                self.city = str(value)
            else:
                self.city = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('street')
            if value not in (None,'null', 'none','None'):
                self.street = str(value)
            else:
                self.street = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('street2')
            if value not in (None,'null', 'none','None'):
                self.street2 = str(value)
            else:
                self.street2 = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('street3')
            if value not in (None,'null', 'none','None'):
                self.street3 = str(value)
            else:
                self.street3 = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('zip')
            if value not in (None,'null', 'none','None'):
                self.zip = str(value)
            else:
                self.zip = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('fax')
            if value not in (None,'null', 'none','None'):
                self.fax = str(value)
            else:
                self.fax = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('logo_name')
            if value not in (None,'null', 'none','None'):
                self.logo_name = str(value)
            else:
                self.logo_name = None
        except Exception as e:
            raise e
        
        try:
            value = data.get('logo_url')
            if value not in (None,'null', 'none','None'):
                self.logo_url = str(value)
            else:
                self.logo_url = None
        except Exception as e:
            raise e
        
        self.status = Status(data.get('status'))

    def valid(self):
        '''check object is valid'''
        
        
        
        
        
        
        
        err = self.businessType.valid()
        if err is not None:
            return err
        
        
        
        
        
        
        
        
        
        err = self.status.valid()
        if err is not None:
            return err
        return None

    def dump_(self):
        '''dump object to dict'''
        return { 
            'id': self.id,
            'scm_companyId': self.scm_companyId,
            'name': self.name,
            'email': self.email,
            'contact': self.contact,
            'phone': self.phone,
            'companyCode': self.companyCode,
            'businessType': self.businessType.value,
            'state': self.state,
            'city': self.city,
            'street': self.street,
            'street2': self.street2,
            'street3': self.street3,
            'zip': self.zip,
            'fax': self.fax,
            'logo_name': self.logo_name,
            'logo_url': self.logo_url,
            'status': self.status.value,
        }
