# coding=utf-8
# DO NOT EDIT! This code is generated by truckxi-api.

from typing import Union
from collections.abc import Callable
import re

class ValueChecker:
    def __init__(self, value) -> None:
        self.value = value

    def check(self, rule: str, limit: Union[str, int, float, bool]) -> str:
        """检查值是否符合规则, 不符合规则的返回错误信息。"""
        func = getattr(self, rule, None) or self.common_func(rule, limit)
        if func is None: 
            raise Exception(f"暂不支持此规则的校验方法: {rule}")
        return func(limit)

    def required(self, limit:bool):
        if limit == True and (not self.value):
            return f'{self.value} 必填项 {limit} 规则'
            
    def email(self, limit:bool):
        if limit == True and self.value:
            if not re.match(r'^(\w|-)+(\.\w+)*@(\w)+((\.\w+)+)$', self.value):
                return f'{self.value} 不符合 email {limit} 规则'
            
    def phone(self, limit:bool):
        if limit == True and self.value:
            if not re.match(r'^1?\s?[\(]?(\d3|\d{3})[\)]?[-|\s]?(\d{3})[-|\s]?(\d{4})$', self.value):
                return f'{self.value} 不符合 phone {limit} 规则'
            
    def common_func(self, rule: str, limit: Union[str, int, float, bool]) -> Callable:
        """
        简单的校验方法: lt, lte, gt, gte, eq, ne, ge, le, contains, startswith, endswith等都使用object内建方法
        """
        funclibs = ["lt", "lte", "gt", "gte", "eq", "ne", "ge", "le", "contains", "startswith", "endswith"]
        funcname = rule
        if rule in ["lte", "gte"]:
            funcname = rule.replace("t", "")
        if rule not in funclibs:
            raise Exception(f"暂不支持此规则的校验方法: {rule}")
        func = getattr(self.value, f'__{funcname}__', None)
        func = func or getattr(self.value, funcname, None)
        if not func:
            raise Exception(f"{type(self.value)}数据类型暂不支持此规则的校验方法: {rule}")
        
        return lambda x: '' if func(x) is True else f"{self.value} 不符合 {rule} {limit} 规则"
    
    def ne_ignore_case(self, limit: Union[str, int, float, bool]) -> str:
        """实现 ne_ignore_case 规则, 忽略大小写情况下比较, 不同则返回None, 否则表示不符合条件"""
        if self.value.lower() == limit.lower():
            return f'{self.value} 不符合 ne_ignore_case {limit} 规则'


def verify(value, limits: list[tuple[str, Union[str, int, float, bool]]]) -> tuple[Union[str, int, float, bool], Union[str, None]]:
    checker = ValueChecker(value)
    for rule, limit in limits:
        err = checker.check(rule, limit)
        if err:
            return value, err
    return value, None

def test():
    verify(1, [("eq", 1), ("ne", 2), ("lte", 3), ("eq", "a")])
    verify('ab', [("eq", 'ab'), ("startswith", "a"), ("ne_ignore_case", "AB")])