"""
    splitit-web-api-v3

    Splitit's API  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://konfigthis.com
"""


import os
import unittest
import uuid

from splitit_client import ApiClient, Configuration
from splitit_client.api.installment_plan_api import InstallmentPlanApi  # noqa: E501
from splitit_client.models import (
    AddressDataModel,
    CardData,
    PaymentMethodType,
    InstallmentPlanCreateRequest,
    PaymentMethodModel,
    PlanDataModel,
    PurchaseMethod,
    ShopperData,
)


class TestInstallmentPlanApiSimple(unittest.TestCase):
    """InstallmentPlanApi unit test stubs"""

    def setUp(self):
        client_id = os.environ["SPLITIT_CLIENT_ID"]
        client_secret = os.environ["SPLITIT_CLIENT_SECRET"]
        configuration = Configuration(client_id=client_id, client_secret=client_secret)
        api_client = ApiClient(configuration)
        self.api = InstallmentPlanApi(api_client)  # noqa: E501

    def tearDown(self):
        pass

    def test_post(self):
        """Test case for post
        """
        request = InstallmentPlanCreateRequest(True, True, True, True)
        request.plan_data = PlanDataModel(
            total_amount=10.0,
            number_of_installments=10,
            currency="USD",
            purchase_method=PurchaseMethod("InStore"),
        )
        request.shopper = ShopperData(email="fake@email.com")
        request.billing_address = AddressDataModel(
            address_line1="144 Union St",
            city="Brooklyn",
            state="North Dakota",
            zip="11231",
            country="United States",
        )
        request.payment_method = PaymentMethodModel(
            type=PaymentMethodType("Card"),
            card=CardData(
                card_exp_month="12",
                card_exp_year="2025",
                card_cvv="111",
                card_number="4556997457604103",
                card_holder_full_name="Test User",
            ),
        )
        response = self.api.post(str(uuid.uuid4()), request)
        print(response)
        assert response is not None, "Received null response"


if __name__ == '__main__':
    unittest.main()
