# Contributing 

Thank you for considering contributing to algo-trader! 

## How to start
If you encounter a bug you wish to fix, or have a feature request, it is best to create an issue with the relevant 
information, so we can talk about the best course of action. 
Next step would be to fork the repo and create a bug/feature branch. 
For better visibility, it would be best if the branch name will have the issue number as its prefix. for example, `123-fix-that`.

## Setup your local environment
After forking and branching, make sure your local environment can run and pass the tests.
Running the test can be done with the provided running scripts in the [scripts](scripts) folder.

## What needs to be done
All open issues and feature requests should be listed in the issues tab. 
If you'd like to work on a new feature, check out the [enhancement](https://github.com/idanya/algo-trader/labels/enhancement) label. 
For fixing existing bugs, check out the [bugs](https://github.com/idanya/algo-trader/labels/bug) label.

Please make sure the feature/bug you are working on is confirmed and approved in the comments and/or added labels.  

## Make sure new code has test coverage
Please make sure all new code has the relevant tests to cover its logic. In cases of bug fixes, make sure to change the relevant tests to reflect the new behavior. 
If you fixed a bug and no test needed to be change, it is a good indicator that a test is missing and should be added. 

## Style and convention
Every one of us has its own style and way to write code. That's Ok and great. 
With that in mind, please make an effort to stay inline with the repo conventions and design so the code will be easily read and understood.

## Make a Pull Request
When you think your code is ready, which means: 

1. It's fixing the issue it meant to fix OR adding the functionality needed
2. The relevant existing/new tests are checking the new behavior and passing
3. Style and convention is inline with the repo "spirit"

Create a PR and reference the issue it solves in the description. 





